/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.campaign.manager.client;

import fr.emac.gind.campaign.manager.client.CampaignManagerNotifierClient;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.eventtype.GJaxbAddCampaignSolutionEvent;
import fr.emac.gind.eventtype.GJaxbCreateCampaignEvent;
import fr.emac.gind.eventtype.GJaxbRemoveCampaignSolutionEvent;
import fr.emac.gind.eventtype.GJaxbUpdateCampaignEvent;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import jakarta.jws.WebService;
import org.w3c.dom.Document;

@WebService(serviceName="NotifierClientService", portName="NotifierClientEndpoint", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
public class WSCampaignNotifierClient
extends AbstractNotifierClient {
    private CampaignManagerNotifierClient cmnc = null;

    public WSCampaignNotifierClient(String address, CampaignManagerNotifierClient cmnc) throws Exception {
        super(address);
        this.cmnc = cmnc;
    }

    public void notify(GJaxbNotify notify) {
        try {
            Document payload = WSNHelper.getInstance().getFirstMessageInNotification(notify);
            if (payload.getDocumentElement().getLocalName().equals("createCampaignEvent")) {
                GJaxbCreateCampaignEvent event = (GJaxbCreateCampaignEvent)XMLJAXBContext.getInstance().unmarshallDocument(payload, GJaxbCreateCampaignEvent.class);
                this.cmnc.onCreateCampaignEvent(event);
            } else if (payload.getDocumentElement().getLocalName().equals("updateCampaignEvent")) {
                GJaxbUpdateCampaignEvent event = (GJaxbUpdateCampaignEvent)XMLJAXBContext.getInstance().unmarshallDocument(payload, GJaxbUpdateCampaignEvent.class);
                this.cmnc.onUpdateCampaignEvent(event);
            } else if (payload.getDocumentElement().getLocalName().equals("addCampaignSolutionEvent")) {
                GJaxbAddCampaignSolutionEvent event = (GJaxbAddCampaignSolutionEvent)XMLJAXBContext.getInstance().unmarshallDocument(payload, GJaxbAddCampaignSolutionEvent.class);
                this.cmnc.onAddSolutionEvent(event);
            } else if (payload.getDocumentElement().getLocalName().equals("removeCampaignSolutionEvent")) {
                GJaxbRemoveCampaignSolutionEvent event = (GJaxbRemoveCampaignSolutionEvent)XMLJAXBContext.getInstance().unmarshallDocument(payload, GJaxbRemoveCampaignSolutionEvent.class);
                this.cmnc.onRemoveSolutionEvent(event);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

