/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.campaign.manager.launcher;

import fr.emac.gind.campaign.manager.server.CampaignManagerWebService;
import fr.emac.gind.launcher.AbstractLauncher;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.launcher.Main;
import fr.emac.gind.storage.launcher.EventStorageLauncher;
import java.util.HashMap;
import java.util.Map;

public class CampaignManagerServerLauncher
extends AbstractLauncher {
    private CampaignManagerWebService monitoring = null;
    private Map<String, Object> map = new HashMap<String, Object>();

    public String getInfo() {
        StringBuffer res = new StringBuffer();
        res.append("Monitoring Server.\n");
        res.append("Number of services exposed: " + this.monitoring.getAllAddresses().size() + "\n");
        res.append("\nList of services:\n");
        for (String string : this.monitoring.getAllAddresses()) {
            res.append("\t- " + string + "\n");
        }
        if (!this.map.isEmpty()) {
            res.append("\nConfiguration:\n");
            for (Map.Entry entry : this.map.entrySet()) {
                res.append("\t" + (String)entry.getKey() + " = " + String.valueOf(entry.getValue()) + "\n");
            }
        }
        return res.toString();
    }

    public String getName() {
        return "Monitoring Server";
    }

    public String getPromptName() {
        return "monitor";
    }

    public void startRunner(Configuration conf) throws Exception {
        this.monitoring = new CampaignManagerWebService();
        this.map.clear();
        this.map.put("serviceName", "MonitoringService");
        this.map.putAll(conf.getProperties());
        this.monitoring.start(this.map);
    }

    public void stopRunner() throws Exception {
        this.monitoring.stop();
    }

    static {
        Main.addLauncherToIgnore(EventStorageLauncher.class);
    }
}

