/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.cep.manager;

import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.event.broker.EventBrokerWebService;
import fr.emac.gind.event.broker.SubscriberBrokerManagerImpl;
import fr.emac.gind.event.cep.extensions.cypher.CypherCountQueryFunctionProcessor;
import fr.emac.gind.event.cep.extensions.cypher.CypherQueryFunctionProcessor;
import fr.emac.gind.event.cep.extensions.date.GetDurationFunction;
import fr.emac.gind.event.cep.extensions.date.GetLocalDateTimeFunction;
import fr.emac.gind.event.cep.extensions.date.IsBeforeFunction;
import fr.emac.gind.event.cep.extensions.date.MaxFunction;
import fr.emac.gind.event.cep.extensions.date.MinFunction;
import fr.emac.gind.event.cep.extensions.date.NowFunction;
import fr.emac.gind.event.cep.extensions.json.JSONArrayFunction;
import fr.emac.gind.event.cep.extensions.json.JSONObjectFunction;
import fr.emac.gind.event.cep.extensions.model.CountNodesFunction;
import fr.emac.gind.event.cep.extensions.model.FindFirstNodeFunction;
import fr.emac.gind.event.cep.extensions.model.FindNodeByPropertyFunction;
import fr.emac.gind.event.cep.extensions.model.FindNodesByTypesFunction;
import fr.emac.gind.event.cep.extensions.model.FormatModelInJSONArrayFunction;
import fr.emac.gind.event.cep.extensions.model.node.FindValuePropertyOnNodeFunction;
import fr.emac.gind.event.cep.extensions.model.node.GeoLocOnNodeFunction;
import fr.emac.gind.event.cep.extensions.model.node.GetIdFunction;
import fr.emac.gind.event.cep.extensions.model.node.GetNameFunction;
import fr.emac.gind.event.cep.extensions.model.node.GetOnNodeFunction;
import fr.emac.gind.event.cep.extensions.model.node.GetTypeFunction;
import fr.emac.gind.event.cep.extensions.object.IsNullFunction;
import fr.emac.gind.event.cep.extensions.util.CleanIdFunction;
import fr.emac.gind.event.cep.extensions.util.ContainsListFunction;
import fr.emac.gind.event.cep.extensions.util.GetFunction;
import fr.emac.gind.event.cep.extensions.util.GetOrCreateStaticIdWithKeyFunction;
import fr.emac.gind.event.cep.extensions.util.ListIntersectionFunction;
import fr.emac.gind.event.cep.extensions.util.RandBoundFunction;
import fr.emac.gind.event.cep.extensions.util.StringFunction;
import fr.emac.gind.event.cep.manager.CepRulesManagerNotifier;
import fr.emac.gind.event.cep.manager.EventListener;
import fr.emac.gind.event.cep.manager.SiddhiContextExtended;
import fr.emac.gind.event.interpretation.config.InterpretationConfigDeployHelper;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.interpretationconfigs.DeployFault;
import fr.emac.gind.interpretationconfigs.GetInterpretationConfigFault;
import fr.emac.gind.interpretationconfigs.GetInterpretationConfigsFault;
import fr.emac.gind.interpretationconfigs.InterpretationCommand;
import fr.emac.gind.interpretationconfigs.UndeployFault;
import fr.emac.gind.interpretationconfigs.UpdateInterpretationConfigFault;
import fr.emac.gind.model.interpretation.config.GJaxbDeploy;
import fr.emac.gind.model.interpretation.config.GJaxbDeployResponse;
import fr.emac.gind.model.interpretation.config.GJaxbDeployResult;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfig;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfigResponse;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfigs;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfigsResponse;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfig;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfigs;
import fr.emac.gind.model.interpretation.config.GJaxbSubscriptionRequiredType;
import fr.emac.gind.model.interpretation.config.GJaxbUndeploy;
import fr.emac.gind.model.interpretation.config.GJaxbUndeployResponse;
import fr.emac.gind.model.interpretation.config.GJaxbUpdateInterpretationConfig;
import fr.emac.gind.model.interpretation.config.GJaxbUpdateInterpretationConfigResponse;
import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.core.SiddhiManager;
import io.siddhi.core.config.SiddhiContext;
import io.siddhi.core.query.output.callback.QueryCallback;
import io.siddhi.extension.execution.string.ConcatFunctionExtension;
import io.siddhi.extension.execution.string.ContainsFunctionExtension;
import io.siddhi.extension.execution.string.EqualsIgnoreCaseFunctionExtension;
import io.siddhi.extension.execution.string.LowerFunctionExtension;
import io.siddhi.extension.execution.string.SplitFunctionExtension;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="InterpretationConfigsCommandSOAP", serviceName="InterpretationConfigsCommandService", targetNamespace="http://www.gind.emac.fr/InterpretationConfigs", wsdlLocation="wsdl/InterpretationApi.wsdl", endpointInterface="fr.emac.gind.interpretationconfigs.InterpretationCommand")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
public class CepRulesManagerCommand
implements InterpretationCommand {
    private static final Logger LOG = LoggerFactory.getLogger((String)CepRulesManagerCommand.class.getName());
    private SiddhiManager siddhiManager = null;
    private String producerAddress = null;
    private CepRulesManagerNotifier notifier = null;
    private NotificationManagerImpl subscriber = null;
    private Map<String, Map<QName, List<SiddhiAppRuntime>>> mapExecRuntime = Collections.synchronizedMap(new HashMap());
    private Map<String, Map<String, GJaxbInterpretationConfig>> mapRules = new HashMap<String, Map<String, GJaxbInterpretationConfig>>();

    public CepRulesManagerCommand(String producerAddress, NotificationManagerImpl subscriber, Map<String, Object> context) throws Exception {
        this.siddhiManager = new SiddhiManager();
        this.siddhiManager.setExtension("str:concat", ConcatFunctionExtension.class);
        this.siddhiManager.setExtension("str:split", SplitFunctionExtension.class);
        this.siddhiManager.setExtension("str:lower", LowerFunctionExtension.class);
        this.siddhiManager.setExtension("str:contains", ContainsFunctionExtension.class);
        this.siddhiManager.setExtension("str:equalsIgnoreCase", EqualsIgnoreCaseFunctionExtension.class);
        this.siddhiManager.setExtension("cypher:query", CypherQueryFunctionProcessor.class);
        this.siddhiManager.setExtension("cypher:countQuery", CypherCountQueryFunctionProcessor.class);
        this.siddhiManager.setExtension("model:formatInJSONArray", FormatModelInJSONArrayFunction.class);
        this.siddhiManager.setExtension("model:countNodes", CountNodesFunction.class);
        this.siddhiManager.setExtension("model:findNodeByProperty", FindNodeByPropertyFunction.class);
        this.siddhiManager.setExtension("model:findNodesByTypes", FindNodesByTypesFunction.class);
        this.siddhiManager.setExtension("model:findFirstNode", FindFirstNodeFunction.class);
        this.siddhiManager.setExtension("node:getId", GetIdFunction.class);
        this.siddhiManager.setExtension("node:getName", GetNameFunction.class);
        this.siddhiManager.setExtension("node:getType", GetTypeFunction.class);
        this.siddhiManager.setExtension("node:get", GetOnNodeFunction.class);
        this.siddhiManager.setExtension("node:findValueProperty", FindValuePropertyOnNodeFunction.class);
        this.siddhiManager.setExtension("node:geoloc", GeoLocOnNodeFunction.class);
        this.siddhiManager.setExtension("object:isNull", IsNullFunction.class);
        this.siddhiManager.setExtension("util:cleanId", CleanIdFunction.class);
        this.siddhiManager.setExtension("util:string", StringFunction.class);
        this.siddhiManager.setExtension("util:randbound", RandBoundFunction.class);
        this.siddhiManager.setExtension("util:get", GetFunction.class);
        this.siddhiManager.setExtension("util:containsList", ContainsListFunction.class);
        this.siddhiManager.setExtension("util:listIntersection", ListIntersectionFunction.class);
        this.siddhiManager.setExtension("util:getOrCreateStaticIdWithKey", GetOrCreateStaticIdWithKeyFunction.class);
        this.siddhiManager.setExtension("date:now", NowFunction.class);
        this.siddhiManager.setExtension("date:isBefore", IsBeforeFunction.class);
        this.siddhiManager.setExtension("date:getLocalDateTime", GetLocalDateTimeFunction.class);
        this.siddhiManager.setExtension("date:min", MinFunction.class);
        this.siddhiManager.setExtension("date:max", MaxFunction.class);
        this.siddhiManager.setExtension("date:getDuration", GetDurationFunction.class);
        this.siddhiManager.setExtension("json:array", JSONArrayFunction.class);
        this.siddhiManager.setExtension("json:obj", JSONObjectFunction.class);
        SiddhiContext siddhiContext = (SiddhiContext)ReflectionHelper.getPrivateFieldValue(SiddhiManager.class, (Object)this.siddhiManager, (String)"siddhiContext");
        SiddhiContextExtended siddhiContextExtended = new SiddhiContextExtended(siddhiContext, context);
        Field field = SiddhiManager.class.getDeclaredField("siddhiContext");
        field.setAccessible(true);
        ReflectionHelper.setFieldValue((Object)this.siddhiManager, (Field)field, (Object)((Object)siddhiContextExtended));
        this.producerAddress = producerAddress;
        this.subscriber = subscriber;
    }

    private String createCollabKnownKey(String collaborationName, String knowledgeSpaceName) {
        return RegExpHelper.toRegexFriendlyName((String)("_c__" + collaborationName + "_k__" + knowledgeSpaceName));
    }

    public void setNotifier(CepRulesManagerNotifier notifier) {
        this.notifier = notifier;
    }

    public SiddhiManager getSiddhiManager() {
        return this.siddhiManager;
    }

    public NotificationManagerImpl getSubscriber() {
        return this.subscriber;
    }

    public Map<String, Map<QName, List<SiddhiAppRuntime>>> getMapExecRuntime() {
        return this.mapExecRuntime;
    }

    public Map<String, Map<String, GJaxbInterpretationConfig>> getMapRules() {
        return this.mapRules;
    }

    public GJaxbDeployResponse deploy(GJaxbDeploy request) throws DeployFault {
        GJaxbDeployResponse response = new GJaxbDeployResponse();
        response.setResult(new GJaxbDeployResult());
        try {
            GJaxbInterpretationConfigs rules = InterpretationConfigDeployHelper.extractInterpretationConfig((GJaxbDeploy)request);
            for (GJaxbInterpretationConfig rule : rules.getInterpretationConfig()) {
                this.createStatementFromRule(rule, false);
                response.getResult().getRuleId().add(rule.getId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeployFault(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    private void createStatementFromRule(GJaxbInterpretationConfig rule, boolean force) throws Exception {
        if (rule.getContext() == null) {
            throw new Exception("Context in cep rule cannot be null!!!");
        }
        if (rule.getContext().getSubscriptionsRequired() == null || rule.getContext().getSubscriptionsRequired().getEntry().isEmpty()) {
            throw new Exception("Required subscriptions cannot be null in cep rule!!!");
        }
        List entries = rule.getContext().getSubscriptionsRequired().getEntry();
        String from = rule.getCepRule().getRule();
        from = from.replace("from ", "@info(name = '" + rule.getId().toString() + "_CallBack') \nfrom ");
        Object executionPlan = "@App:name('" + rule.getId().toString() + "')" + rule.getCepRule().getStreamDefinition() + "\n" + from;
        String collaborationName = "";
        String knowledgeSpaceName = "";
        if (rule.getContext() != null) {
            if (rule.getContext().getCollaborationName() != null) {
                collaborationName = rule.getContext().getCollaborationName();
            }
            if (rule.getContext().getKnowledgeSpaceName() != null) {
                knowledgeSpaceName = rule.getContext().getKnowledgeSpaceName();
            }
        }
        executionPlan = ((String)executionPlan).replace("${collaborationName}", collaborationName).replace("${knowledgeSpaceName}", knowledgeSpaceName);
        String collabKnownKey = this.createCollabKnownKey(collaborationName, knowledgeSpaceName);
        if (!this.ruleAlreadyDeploy(collabKnownKey, rule) || force) {
            LOG.debug("Execution plan: \n" + (String)executionPlan);
            executionPlan = ((String)executionPlan).trim().replaceAll("\\n", " ").replaceAll("\\t", " ").replaceAll("  ", " ");
            SiddhiAppRuntime executionPlanRuntime = this.siddhiManager.createSiddhiAppRuntime((String)executionPlan);
            executionPlanRuntime.addCallback(rule.getId() + "_CallBack", (QueryCallback)new EventListener(this.producerAddress, rule, this.subscriber));
            for (GJaxbSubscriptionRequiredType entry : entries) {
                try {
                    QName topicUsed = entry.getTopic();
                    LOG.debug("topicUsed: " + String.valueOf(topicUsed));
                    String subscriptionAddress = entry.getEndpointAddressToSubscribe();
                    if (subscriptionAddress != null && !subscriptionAddress.isEmpty()) {
                        LOG.debug("CEP SUBSCRIBE ON " + String.valueOf(topicUsed) + " => OK");
                        if (subscriptionAddress.endsWith("/BrokerSubscriber") && LocalRegistry.getInstance().findWS(EventBrokerWebService.class) != null) {
                            EventBrokerWebService localEventBroker = (EventBrokerWebService)LocalRegistry.getInstance().findWS(EventBrokerWebService.class);
                            SubscriberBrokerManagerImpl localEventBrokerNotifier = (SubscriberBrokerManagerImpl)localEventBroker.getImplementation(SubscriberBrokerManagerImpl.class);
                            this.notifier.subscribeOn((NotificationManagerImpl)localEventBrokerNotifier, topicUsed);
                        } else {
                            this.notifier.subscribeOn(subscriptionAddress, topicUsed);
                        }
                    }
                    if (this.mapExecRuntime.get(collabKnownKey) == null) {
                        this.mapExecRuntime.put(collabKnownKey, new HashMap());
                    }
                    if (this.mapExecRuntime.get(collabKnownKey).get(entry.getCorrespondingEvent()) == null) {
                        this.mapExecRuntime.get(collabKnownKey).put(entry.getCorrespondingEvent(), new ArrayList());
                    }
                    this.mapExecRuntime.get(collabKnownKey).get(entry.getCorrespondingEvent()).removeIf(plan -> plan.getName().equals(executionPlanRuntime.getName()));
                    this.mapExecRuntime.get(collabKnownKey).get(entry.getCorrespondingEvent()).add(executionPlanRuntime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
            if (this.mapRules.get(collabKnownKey) == null) {
                this.mapRules.put(collabKnownKey, new HashMap());
            }
            this.mapRules.get(collabKnownKey).put(rule.getId(), rule);
            LOG.debug("Rule added in list: " + String.valueOf(this.getTriggerEventNameOfRules()));
            executionPlanRuntime.start();
        } else {
            LOG.warn("Rule '" + rule.getName() + "' already deployed !!!");
        }
    }

    private boolean ruleAlreadyDeploy(String collabKnownKey, GJaxbInterpretationConfig rule) {
        if (this.mapExecRuntime.get(collabKnownKey) != null) {
            for (List<SiddhiAppRuntime> listRules : this.mapExecRuntime.get(collabKnownKey).values()) {
                for (SiddhiAppRuntime ruleDeployed : listRules) {
                    if (!ruleDeployed.getName().contains(rule.getId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<QName> getTriggerEventNameOfRules() {
        ArrayList<QName> res = new ArrayList<QName>();
        for (Map<QName, List<SiddhiAppRuntime>> mapExec : this.mapExecRuntime.values()) {
            res.addAll(mapExec.keySet());
        }
        return res;
    }

    public List<String> getRulesName() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map<String, GJaxbInterpretationConfig> mapExec : this.mapRules.values()) {
            res.addAll(mapExec.keySet());
        }
        return res;
    }

    public GJaxbUndeployResponse undeploy(GJaxbUndeploy parameters) throws UndeployFault {
        GJaxbUndeployResponse res = new GJaxbUndeployResponse();
        try {
            String collab = "";
            if (parameters.getCollaborationName() != null) {
                collab = parameters.getCollaborationName();
            }
            String knowledge = "";
            if (parameters.getKnowledgeSpaceName() != null) {
                knowledge = parameters.getKnowledgeSpaceName();
            }
            String collabKnownKey = this.createCollabKnownKey(collab, knowledge);
            for (String ruleId : parameters.getRequest().getRuleId()) {
                GJaxbInterpretationConfig rule = this.mapRules.get(collabKnownKey).remove(ruleId);
                if (rule == null) continue;
                List entries = rule.getContext().getSubscriptionsRequired().getEntry();
                for (GJaxbSubscriptionRequiredType entry : entries) {
                    if (this.mapExecRuntime.get(collabKnownKey) == null) continue;
                    Iterator<SiddhiAppRuntime> it = this.mapExecRuntime.get(collabKnownKey).get(entry.getCorrespondingEvent()).iterator();
                    SiddhiAppRuntime execPlanToRemove = null;
                    while (it.hasNext()) {
                        SiddhiAppRuntime currentExecPlan = it.next();
                        if (!currentExecPlan.getName().equals(ruleId.toString())) continue;
                        execPlanToRemove = currentExecPlan;
                        break;
                    }
                    if (execPlanToRemove == null) continue;
                    execPlanToRemove.shutdown();
                    this.mapExecRuntime.get(collabKnownKey).get(entry.getCorrespondingEvent()).remove(execPlanToRemove);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UndeployFault(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbGetInterpretationConfigResponse getInterpretationConfig(GJaxbGetInterpretationConfig parameters) throws GetInterpretationConfigFault {
        GJaxbInterpretationConfig rule;
        String collabKnownKey;
        GJaxbGetInterpretationConfigResponse res = new GJaxbGetInterpretationConfigResponse();
        String collab = "";
        if (parameters.getCollaborationName() != null) {
            collab = parameters.getCollaborationName();
        }
        String knowledge = "";
        if (parameters.getKnowledgeSpaceName() != null) {
            knowledge = parameters.getKnowledgeSpaceName();
        }
        if (this.mapRules.get(collabKnownKey = this.createCollabKnownKey(collab, knowledge)) != null && (rule = this.mapRules.get(collabKnownKey).get(parameters.getRuleId())) != null) {
            res.setInterpretationConfig(rule);
        }
        return res;
    }

    public GJaxbGetInterpretationConfigsResponse getInterpretationConfigs(GJaxbGetInterpretationConfigs parameters) throws GetInterpretationConfigsFault {
        GJaxbGetInterpretationConfigsResponse res = new GJaxbGetInterpretationConfigsResponse();
        try {
            String collabKnownKey;
            String collab = "";
            if (parameters.getCollaborationName() != null) {
                collab = parameters.getCollaborationName();
            }
            String knowledge = "";
            if (parameters.getKnowledgeSpaceName() != null) {
                knowledge = parameters.getKnowledgeSpaceName();
            }
            if (this.mapRules.get(collabKnownKey = this.createCollabKnownKey(collab, knowledge)) != null) {
                for (Map.Entry<String, GJaxbInterpretationConfig> entry_rules : this.mapRules.get(collabKnownKey).entrySet()) {
                    GJaxbInterpretationConfig rule = entry_rules.getValue();
                    res.getInterpretationConfig().add(rule);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GetInterpretationConfigsFault(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbUpdateInterpretationConfigResponse updateInterpretationConfig(GJaxbUpdateInterpretationConfig parameters) throws UpdateInterpretationConfigFault {
        return null;
    }

    public void reset() {
        this.mapExecRuntime.clear();
        this.mapRules.clear();
    }
}

