/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.cep.transformer;

import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.event.cep.extensions.model.bo.EdgeBO;
import fr.emac.gind.event.cep.extensions.model.bo.NodeBO;
import fr.emac.gind.event.cep.transformer.AbstractDataTransformer;
import fr.emac.gind.eventtype.GJaxbPublishModelEvent;
import fr.emac.gind.json_connector.GJaxbSensorEvent;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class BasicXMLTransformer
extends AbstractDataTransformer {
    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean identifyPayload(Object payload) throws Exception {
        return payload instanceof Element;
    }

    @Override
    public Object[] transformPayloadToOrderingValue(Object payload, StreamDefinition definition, Map<QName, String> context) throws Exception {
        ArrayList<Object> dt = new ArrayList<Object>();
        Element event = (Element)payload;
        if (DOMUtil.getInstance().getFirstElement(event).getLocalName().equals("node") && DOMUtil.getInstance().getFirstElement(event).getNamespaceURI().equals("http://www.gind.emac.fr/modeler/genericModel")) {
            GJaxbNode node = (GJaxbNode)XMLJAXBContext.getInstance().unmarshallDocument(DOMUtil.getInstance().createDocumentFromElement(DOMUtil.getInstance().getFirstElement(event)), GJaxbNode.class);
            dt.add(new NodeBO(node));
        } else if (event.getLocalName().equals("sensorEvent") && event.getNamespaceURI().equals("http://www.gind.emac.fr/json_connector")) {
            GJaxbSensorEvent sensorEvent = (GJaxbSensorEvent)XMLJAXBContext.getInstance().unmarshallDocument(DOMUtil.getInstance().createDocumentFromElement(event), GJaxbSensorEvent.class);
            dt.clear();
            for (Attribute attr : definition.getAttributeList()) {
                if ("eventId".equals(attr.getName())) {
                    dt.add(sensorEvent.getEventId());
                    continue;
                }
                if ("sensorId".equals(attr.getName())) {
                    dt.add(sensorEvent.getSensorId());
                    continue;
                }
                if ("sensorType".equals(attr.getName())) {
                    dt.add(sensorEvent.getSensorType().toString());
                    continue;
                }
                if ("sensorNature__dedicatedNature".equals(attr.getName())) {
                    dt.add(sensorEvent.getSensorNature() != null && sensorEvent.getSensorNature().getDedicatedNature() != null ? sensorEvent.getSensorNature().getDedicatedNature().toString() : null);
                    continue;
                }
                if ("sensorNature__quantitativeNature".equals(attr.getName())) {
                    dt.add(sensorEvent.getSensorNature() != null && sensorEvent.getSensorNature().getQuantitativeNature() != null ? sensorEvent.getSensorNature().getQuantitativeNature().toString() : null);
                    continue;
                }
                if ("sensorNature__socialNature".equals(attr.getName())) {
                    dt.add(sensorEvent.getSensorNature() != null && sensorEvent.getSensorNature().getSocialNature() != null ? sensorEvent.getSensorNature().getSocialNature().toString() : null);
                    continue;
                }
                if ("sensorNature__mediaNature".equals(attr.getName())) {
                    dt.add(sensorEvent.getSensorNature() != null && sensorEvent.getSensorNature().getMediaNature() != null ? sensorEvent.getSensorNature().getMediaNature().toString() : null);
                    continue;
                }
                if ("date".equals(attr.getName())) {
                    dt.add(sensorEvent.getDate().toString());
                    continue;
                }
                if ("position__point__latitude".equals(attr.getName())) {
                    dt.add(sensorEvent.getPosition() != null && sensorEvent.getPosition().getPoint() != null ? Double.valueOf(sensorEvent.getPosition().getPoint().getLatitude()) : null);
                    continue;
                }
                if ("position__point__longitude".equals(attr.getName())) {
                    dt.add(sensorEvent.getPosition() != null && sensorEvent.getPosition().getPoint() != null ? Double.valueOf(sensorEvent.getPosition().getPoint().getLongitude()) : null);
                    continue;
                }
                if ("position__point__altitude".equals(attr.getName())) {
                    dt.add(sensorEvent.getPosition() != null && sensorEvent.getPosition().getPoint() != null ? sensorEvent.getPosition().getPoint().getAltitude() : null);
                    continue;
                }
                if ("position__point__markerIcon".equals(attr.getName())) {
                    dt.add(sensorEvent.getPosition() != null && sensorEvent.getPosition().getPoint() != null ? sensorEvent.getPosition().getPoint().getMarkerIcon() : null);
                    continue;
                }
                if ("data__dedicated__value".equals(attr.getName())) {
                    dt.add(sensorEvent.getData().getDedicated() != null ? Boolean.valueOf(sensorEvent.getData().getDedicated().isValue()) : null);
                    continue;
                }
                if ("data__quantitative__value".equals(attr.getName())) {
                    dt.add(sensorEvent.getData().getQuantitative() != null ? Float.valueOf(sensorEvent.getData().getQuantitative().getValue()) : null);
                    continue;
                }
                if ("data__media__value".equals(attr.getName())) {
                    dt.add(sensorEvent.getData().getMedia() != null ? sensorEvent.getData().getMedia().getValue() : null);
                    continue;
                }
                if ("data__others__knowledge__value__addNodeEvent".equals(attr.getName())) {
                    dt.add(sensorEvent.getData().getOthers() != null && sensorEvent.getData().getOthers().getKnowledge() != null && sensorEvent.getData().getOthers().getKnowledge().getValue() != null && sensorEvent.getData().getOthers().getKnowledge().getValue().getAddNodeEvent() != null ? sensorEvent.getData().getOthers().getKnowledge().getValue().getAddNodeEvent() : null);
                    continue;
                }
                if ("data__others__knowledge__value__updateNodeEvent".equals(attr.getName())) {
                    dt.add(sensorEvent.getData().getOthers() != null && sensorEvent.getData().getOthers().getKnowledge() != null && sensorEvent.getData().getOthers().getKnowledge().getValue() != null && sensorEvent.getData().getOthers().getKnowledge().getValue().getUpdateNodeEvent() != null ? sensorEvent.getData().getOthers().getKnowledge().getValue().getUpdateNodeEvent() : null);
                    continue;
                }
                if ("data__others__knowledge__value__removeNodeEvent".equals(attr.getName())) {
                    dt.add(sensorEvent.getData().getOthers() != null && sensorEvent.getData().getOthers().getKnowledge() != null && sensorEvent.getData().getOthers().getKnowledge().getValue() != null && sensorEvent.getData().getOthers().getKnowledge().getValue().getRemoveNodeEvent() != null ? sensorEvent.getData().getOthers().getKnowledge().getValue().getRemoveNodeEvent() : null);
                    continue;
                }
                if ("data__others__knowledge__value__addEdgeEvent".equals(attr.getName())) {
                    dt.add(sensorEvent.getData().getOthers() != null && sensorEvent.getData().getOthers().getKnowledge() != null && sensorEvent.getData().getOthers().getKnowledge().getValue() != null && sensorEvent.getData().getOthers().getKnowledge().getValue().getAddEdgeEvent() != null ? sensorEvent.getData().getOthers().getKnowledge().getValue().getAddEdgeEvent() : null);
                    continue;
                }
                if ("data__others__knowledge__value__updateEdgeEvent".equals(attr.getName())) {
                    dt.add(sensorEvent.getData().getOthers() != null && sensorEvent.getData().getOthers().getKnowledge() != null && sensorEvent.getData().getOthers().getKnowledge().getValue() != null && sensorEvent.getData().getOthers().getKnowledge().getValue().getUpdateEdgeEvent() != null ? sensorEvent.getData().getOthers().getKnowledge().getValue().getUpdateEdgeEvent() : null);
                    continue;
                }
                if ("data__others__knowledge__value__removeEdgeEvent".equals(attr.getName())) {
                    dt.add(sensorEvent.getData().getOthers() != null && sensorEvent.getData().getOthers().getKnowledge() != null && sensorEvent.getData().getOthers().getKnowledge().getValue() != null && sensorEvent.getData().getOthers().getKnowledge().getValue().getRemoveEdgeEvent() != null ? sensorEvent.getData().getOthers().getKnowledge().getValue().getRemoveEdgeEvent() : null);
                    continue;
                }
                if ("data__others__knowledge__value__addNodeEvent__node".equals(attr.getName())) {
                    dt.add(sensorEvent.getData().getOthers() != null && sensorEvent.getData().getOthers().getKnowledge() != null && sensorEvent.getData().getOthers().getKnowledge().getValue() != null && sensorEvent.getData().getOthers().getKnowledge().getValue().getAddNodeEvent() != null ? new NodeBO(sensorEvent.getData().getOthers().getKnowledge().getValue().getAddNodeEvent().getNode()) : null);
                    continue;
                }
                if ("data__others__knowledge__value__updateNodeEvent__node".equals(attr.getName())) {
                    dt.add(sensorEvent.getData().getOthers() != null && sensorEvent.getData().getOthers().getKnowledge() != null && sensorEvent.getData().getOthers().getKnowledge().getValue() != null && sensorEvent.getData().getOthers().getKnowledge().getValue().getUpdateNodeEvent() != null ? new NodeBO(sensorEvent.getData().getOthers().getKnowledge().getValue().getUpdateNodeEvent().getNode()) : null);
                    continue;
                }
                if ("data__others__knowledge__value__removeNodeEvent__node".equals(attr.getName())) {
                    dt.add(sensorEvent.getData().getOthers() != null && sensorEvent.getData().getOthers().getKnowledge() != null && sensorEvent.getData().getOthers().getKnowledge().getValue() != null && sensorEvent.getData().getOthers().getKnowledge().getValue().getRemoveNodeEvent() != null ? new NodeBO(sensorEvent.getData().getOthers().getKnowledge().getValue().getRemoveNodeEvent().getNode()) : null);
                    continue;
                }
                if ("data__others__knowledge__value__addEdgeEvent__edge".equals(attr.getName())) {
                    dt.add(sensorEvent.getData().getOthers() != null && sensorEvent.getData().getOthers().getKnowledge() != null && sensorEvent.getData().getOthers().getKnowledge().getValue() != null && sensorEvent.getData().getOthers().getKnowledge().getValue().getAddEdgeEvent() != null ? new EdgeBO(sensorEvent.getData().getOthers().getKnowledge().getValue().getAddEdgeEvent().getEdge()) : null);
                    continue;
                }
                if ("data__others__knowledge__value__updateEdgeEvent__edge".equals(attr.getName())) {
                    dt.add(sensorEvent.getData().getOthers() != null && sensorEvent.getData().getOthers().getKnowledge() != null && sensorEvent.getData().getOthers().getKnowledge().getValue() != null && sensorEvent.getData().getOthers().getKnowledge().getValue().getUpdateEdgeEvent() != null ? new EdgeBO(sensorEvent.getData().getOthers().getKnowledge().getValue().getUpdateEdgeEvent().getEdge()) : null);
                    continue;
                }
                if ("data__others__knowledge__value__removeEdgeEvent__edge".equals(attr.getName())) {
                    dt.add(sensorEvent.getData().getOthers() != null && sensorEvent.getData().getOthers().getKnowledge() != null && sensorEvent.getData().getOthers().getKnowledge().getValue() != null && sensorEvent.getData().getOthers().getKnowledge().getValue().getRemoveEdgeEvent() != null ? new EdgeBO(sensorEvent.getData().getOthers().getKnowledge().getValue().getRemoveEdgeEvent().getEdge()) : null);
                    continue;
                }
                throw new Exception("Attr '" + attr.getName() + "' not found !!!");
            }
            dt.add(sensorEvent.getCollaborationName());
            dt.add(sensorEvent.getKnowledgeSpaceName());
        } else if (DOMUtil.getInstance().getFirstElement(event).getLocalName().equals("model") && DOMUtil.getInstance().getFirstElement(event).getNamespaceURI().equals("http://www.gind.emac.fr/EventType")) {
            GJaxbPublishModelEvent.Model model = (GJaxbPublishModelEvent.Model)XMLJAXBContext.getInstance().unmarshallDocument(DOMUtil.getInstance().createDocumentFromElement(DOMUtil.getInstance().getFirstElement(event)), GJaxbPublishModelEvent.Model.class);
            GJaxbGenericModel newModel = new GJaxbGenericModel();
            model.getNodes().forEach(n -> newModel.getNode().add(n.getNode()));
            model.getEdges().forEach(e -> newModel.getEdge().add(e.getEdge()));
            dt.add(newModel);
        } else {
            this.createObjectFromElement((Element)payload, definition, dt);
        }
        dt.add(context);
        return dt.toArray(new Object[dt.size()]);
    }

    private void createObjectFromElement(Element parent, StreamDefinition definition, List<Object> data) throws Exception {
        List childs = DOMUtil.getInstance().getElements(parent);
        if (childs.size() > 0) {
            for (Element child : childs) {
                this.createObjectFromElement(child, definition, data);
            }
        } else {
            data.add(this.createData(parent.getLocalName(), parent.getTextContent(), definition));
        }
    }

    private Object createData(String name, String value, StreamDefinition definition) {
        Object data = value;
        int attributePosition = definition.getAttributePosition(name);
        Attribute attr = (Attribute)definition.getAttributeList().get(attributePosition);
        switch (attr.getType()) {
            case BOOL: {
                data = Boolean.valueOf(value);
                break;
            }
            case DOUBLE: {
                data = Double.valueOf(value);
                break;
            }
            case FLOAT: {
                data = Float.valueOf(value);
                break;
            }
            case INT: {
                data = Integer.valueOf(value);
                break;
            }
            case LONG: {
                data = Long.valueOf(value);
                break;
            }
            case STRING: {
                data = String.valueOf(value);
                break;
            }
            default: {
                data = value;
            }
        }
        return data;
    }
}

