/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.cep.extensions.cypher;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import fr.emac.gind.event.cep.manager.SiddhiContextExtended;
import fr.emac.gind.gov.core.client.Neo4JClient;
import fr.emac.gind.neo4j.GJaxbQuery;
import fr.emac.gind.neo4j.GJaxbQueryResponse;
import fr.emac.gind.neo4j.GJaxbSelectedKnowledgeSpace;
import fr.emac.gind.neo4j.Neo4J;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.stream.function.StreamFunctionProcessor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CypherCountQueryFunctionProcessor
extends StreamFunctionProcessor {
    private Logger LOG = LoggerFactory.getLogger((String)CypherCountQueryFunctionProcessor.class.getName());
    private List<Attribute> retrunAttributes;
    private Map<String, Object> context = null;
    private Neo4J neo4jClient = null;
    private ObjectMapper mapper = new ObjectMapper();

    public Neo4J getNeo4JClient() throws Exception {
        if (this.neo4jClient == null) {
            this.neo4jClient = Neo4JClient.createClient((String)((String)this.context.get("governance")).replace("/gov", "/GovNeo4J"));
        }
        return this.neo4jClient;
    }

    protected Object[] process(Object data) {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    protected Object[] process(Object[] data) {
        String query = data[0].toString();
        String collaborationName = data[1].toString();
        String knownledgeSpaceName = data[2].toString();
        if (data.length > 3) {
            ArrayList<Object> params = new ArrayList<Object>();
            for (int i = 4; i < data.length; ++i) {
                params.add(data[i]);
            }
            for (Object e : params) {
                query = query.replaceFirst("\\$[0-9]+", e.toString());
            }
        }
        this.LOG.debug("query: " + query);
        GJaxbQuery request = new GJaxbQuery();
        request.setQuery(query);
        request.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
        request.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
        request.getSelectedKnowledgeSpace().setKnowledgeName(knownledgeSpaceName);
        try {
            GJaxbQueryResponse response = this.getNeo4JClient().query(request);
            String string = response.getJsonResponse();
            JsonNode tree = this.mapper.readTree(string);
            if (tree.has("long")) {
                return new Object[]{tree.get("long").asLong()};
            }
            return new Object[0];
        }
        catch (Exception e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
            throw new SiddhiAppValidationException((Throwable)e);
        }
    }

    protected StateFactory init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("First parameter should be of type string");
        }
        if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Second parameter should be of type string");
        }
        if (attributeExpressionExecutors[2].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Third parameter should be of type string");
        }
        if (attributeExpressionExecutors[3].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Four parameter should be of type string");
        }
        SiddhiContextExtended extentedContext = (SiddhiContextExtended)siddhiQueryContext.getSiddhiContext();
        this.context = extentedContext.getContext();
        Object obj = ReflectionHelper.getPrivateFieldValue((Class)attributeExpressionExecutors[3].getClass(), (Object)attributeExpressionExecutors[3], (String)"value");
        this.retrunAttributes = Arrays.asList(new Attribute(obj.toString(), Attribute.Type.LONG));
        return null;
    }

    public List<Attribute> getReturnAttributes() {
        return this.retrunAttributes;
    }
}

