/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.cep.manager;

import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.event.cep.manager.CepRulesManagerCommand;
import fr.emac.gind.event.cep.transformer.TransformerManager;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.gov.core.client.util.Neo4JId;
import fr.emac.gind.json_connector.GJaxbSensorEvent;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfig;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotificationMessageHolderType;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import io.siddhi.core.SiddhiAppRuntime;
import io.siddhi.core.stream.input.InputHandler;
import io.siddhi.query.api.definition.StreamDefinition;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@WebService(serviceName="NotifierClientService", portName="NotifierClientEndpoint", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
public class CepRulesManagerNotifier
extends AbstractNotifierClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)CepRulesManagerNotifier.class.getName());
    private static int cpt = 0;
    private CepRulesManagerCommand cmc = null;
    private String producerAddress = null;
    private TransformerManager transformerManager = null;

    public CepRulesManagerNotifier(String producerAddress, CepRulesManagerCommand cmc) throws Exception {
        super(producerAddress);
        this.producerAddress = producerAddress;
        this.cmc = cmc;
        this.transformerManager = new TransformerManager();
    }

    public synchronized void notify(GJaxbNotify notify) {
        LOG.debug("Executing operation notify on cep");
        try {
            Document event = this.getEventInNotify(notify);
            LOG.debug("****** Notify on CEP: \n" + XMLPrettyPrinter.print((Node)event));
            System.out.println("****** Notify on CEP: \n" + XMLPrettyPrinter.print((Node)event));
            HashMap<QName, String> context = new HashMap<QName, String>();
            for (Object obj : notify.getAny()) {
                Element elmt = (Element)obj;
                if (!elmt.getLocalName().equals("context") || !elmt.getNamespaceURI().equals("http://www.gind.emac.fr")) continue;
                List childs = DOMUtil.getInstance().getElements(elmt);
                childs.forEach(e -> {
                    QName qname = new QName(e.getNamespaceURI(), e.getLocalName());
                    String value = e.getTextContent();
                    context.put(qname, value);
                });
            }
            QName eventQName = new QName(event.getDocumentElement().getNamespaceURI(), event.getDocumentElement().getLocalName());
            List<SiddhiAppRuntime> executionPlanRuntimes = this.findExecutionsPlanRuntime(event);
            if (!executionPlanRuntimes.isEmpty()) {
                for (SiddhiAppRuntime executionPlanRuntime : executionPlanRuntimes) {
                    System.out.println("Rule activates : " + executionPlanRuntime.getName());
                    LOG.debug("Rule activates : " + executionPlanRuntime.getName());
                    InputHandler inputHandler = executionPlanRuntime.getInputHandler(eventQName.getLocalPart());
                    StreamDefinition definition = (StreamDefinition)executionPlanRuntime.getStreamDefinitionMap().get(inputHandler.getStreamId());
                    Object[] data = this.transformerManager.transformPayloadToOrderingValue(event.getDocumentElement(), definition, context);
                    System.out.println("Data : " + this.printEventData(data));
                    LOG.debug("Data : " + this.printEventData(data));
                    inputHandler.send(System.currentTimeMillis(), data);
                }
            } else {
                String errorMsg = "Impossible to find rules corresponding to event: " + String.valueOf(eventQName) + ". Existing rules: " + String.valueOf(this.cmc.getTriggerEventNameOfRules());
                LOG.warn(errorMsg);
            }
            LOG.debug("****** NUMBER OF NOTIFICATION RECEIVED ON CEP: " + ++cpt);
        }
        catch (Exception e1) {
            LOG.error(e1.getMessage(), (Throwable)e1);
            e1.printStackTrace();
        }
    }

    private String printEventData(Object[] data) {
        Object res = "[";
        for (Object obj : data) {
            res = (String)res + String.valueOf(obj) + ", ";
        }
        res = ((String)res).substring(0, ((String)res).length() - ", ".length());
        res = (String)res + "]";
        return res;
    }

    private synchronized List<SiddhiAppRuntime> findExecutionsPlanRuntime(Document event) throws Exception {
        QName eventQName = new QName(event.getDocumentElement().getNamespaceURI(), event.getDocumentElement().getLocalName());
        ArrayList<SiddhiAppRuntime> res = new ArrayList<SiddhiAppRuntime>();
        for (Map<QName, List<SiddhiAppRuntime>> mapExec : this.cmc.getMapExecRuntime().values()) {
            if (mapExec.get(eventQName) == null) continue;
            List<SiddhiAppRuntime> siddhiAppRuntimes = mapExec.get(eventQName);
            if (event.getDocumentElement().getLocalName().equals("sensorEvent") && event.getDocumentElement().getNamespaceURI().equals("http://www.gind.emac.fr/json_connector")) {
                GJaxbSensorEvent sensorEvent = (GJaxbSensorEvent)XMLJAXBContext.getInstance().unmarshallDocument(event, GJaxbSensorEvent.class);
                for (SiddhiAppRuntime siddhiAppRuntime : siddhiAppRuntimes) {
                    String ruleName = siddhiAppRuntime.getName().replace("_CallBack", "");
                    for (Map<String, GJaxbInterpretationConfig> rulesMap : this.cmc.getMapRules().values()) {
                        GJaxbInterpretationConfig rule = rulesMap.get(ruleName);
                        if (rule == null) continue;
                        if (rule.getContext().getDataSourcesConcerned() != null && !rule.getContext().getDataSourcesConcerned().getDataSourceId().isEmpty()) {
                            if (!this.ruleIsForSensor(sensorEvent, rule) || res.contains(siddhiAppRuntime)) continue;
                            res.add(siddhiAppRuntime);
                            continue;
                        }
                        if (res.contains(siddhiAppRuntime)) continue;
                        res.add(siddhiAppRuntime);
                    }
                }
                continue;
            }
            res.addAll(siddhiAppRuntimes);
        }
        return res;
    }

    public boolean ruleIsForSensor(GJaxbSensorEvent sensorEvent, GJaxbInterpretationConfig rule) {
        String sensorEventId = Neo4JId.cleanId((String)sensorEvent.getSensorId());
        for (String dataSourceID : rule.getContext().getDataSourcesConcerned().getDataSourceId()) {
            String dsId = Neo4JId.cleanId((String)dataSourceID);
            if (!dsId.contains(sensorEventId)) continue;
            return true;
        }
        return false;
    }

    private Document getEventInNotify(GJaxbNotify notify) throws Exception {
        Document doc = null;
        for (GJaxbNotificationMessageHolderType msgh : notify.getNotificationMessage()) {
            if (msgh.getMessage().getAny() instanceof Element) {
                Element elmt = (Element)msgh.getMessage().getAny();
                doc = DOMUtil.getInstance().newDocument();
                doc.appendChild(doc.adoptNode(elmt));
                continue;
            }
            doc = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)msgh.getMessage().getAny());
        }
        return doc;
    }
}

