/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.cep.transformer;

import fr.emac.gind.event.cep.transformer.AbstractDataTransformer;
import io.siddhi.query.api.definition.StreamDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformerManager {
    private static Logger LOG = LoggerFactory.getLogger((String)TransformerManager.class.getName());
    private ServiceLoader<AbstractDataTransformer> dataTransformersLoader = ServiceLoader.load(AbstractDataTransformer.class);
    private List<AbstractDataTransformer> dataTransformers = new ArrayList<AbstractDataTransformer>();

    public TransformerManager() throws Exception {
        this.initDataTransformers();
    }

    private void initDataTransformers() throws Exception {
        this.dataTransformers.clear();
        this.dataTransformersLoader.reload();
        for (AbstractDataTransformer dataTransformer : this.dataTransformersLoader) {
            this.dataTransformers.add(dataTransformer);
        }
    }

    public Object[] transformPayloadToOrderingValue(Object payload, StreamDefinition definition, Map<QName, String> context) throws Exception {
        for (AbstractDataTransformer dt : this.dataTransformers) {
            if (!dt.identifyPayload(payload)) continue;
            LOG.debug("Data transformer find: " + dt.getName());
            return dt.transformPayloadToOrderingValue(payload, definition, context);
        }
        throw new Exception("Impossible to find a valid transformer");
    }
}

