/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.monitoring.detection;

import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.models_gov.ModelsGov;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.monitoring.detection.ResultConcept;
import fr.emac.gind.monitoring.detectionReport.GJaxbDetectionReports;
import fr.emac.gind.monitoring.detectionReport.GJaxbModelsComparison;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractDetection<O> {
    private CoreGov core = null;
    private CoreGov coreClient = null;
    private ModelsGov modelClient = null;
    protected NodeModelComparator separatedNodes;
    protected static final String COMMON_NODES = "commonNodes";
    protected static final String EXPECTED_NODES = "expectedNodes";
    protected static final String FIELD_NODES = "fieldNodes";
    protected static final String DIFFERENT_NODES = "differentNodes";
    protected static final String EXPECTED_EDGES = "expectedEdges";
    protected static final String FIELD_EDGES = "fieldEdges";

    public void setCore(CoreGov core) {
        this.core = core;
    }

    public CoreGov getCoreClient() {
        return this.coreClient;
    }

    public void setCoreClient(CoreGov coreClient) {
        this.coreClient = coreClient;
    }

    public ModelsGov getModelClient() {
        return this.modelClient;
    }

    public void setModelClient(ModelsGov modelClient) {
        this.modelClient = modelClient;
    }

    public abstract String getName();

    public GJaxbDetectionReports detect(String currentCollaborationName, String currentKnowledgeSpaceName, List<GJaxbProperty> data, List<GJaxbModelsComparison> modelsComparisons) throws Exception {
        HashMap<String, Map<String, List<ResultConcept<O>>>> reports = new HashMap<String, Map<String, List<ResultConcept<O>>>>();
        this.setData(data);
        for (GJaxbModelsComparison modelComparison : modelsComparisons) {
            Map<String, List> categoryReports = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry(COMMON_NODES, new ArrayList()), new AbstractMap.SimpleEntry(EXPECTED_NODES, new ArrayList()), new AbstractMap.SimpleEntry(FIELD_NODES, new ArrayList()), new AbstractMap.SimpleEntry(DIFFERENT_NODES, new ArrayList()), new AbstractMap.SimpleEntry(EXPECTED_EDGES, new ArrayList()), new AbstractMap.SimpleEntry(FIELD_EDGES, new ArrayList())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
            String category = modelComparison.getCategory();
            if (category == null) {
                category = "no_category";
            }
            reports.put(category, categoryReports);
            this.separatedNodes = this.separateNodes(modelComparison.getExpectedModel(), modelComparison.getFieldModel());
            for (GJaxbNode gJaxbNode : this.separatedNodes.getCommonsNodes()) {
                categoryReports.get(COMMON_NODES).add(this.createCommonReport(gJaxbNode));
            }
            for (GJaxbNode gJaxbNode : this.separatedNodes.getOnlyNodesOnExpected()) {
                categoryReports.get(EXPECTED_NODES).add(this.compareNodes(gJaxbNode, null));
            }
            for (GJaxbNode gJaxbNode : this.separatedNodes.getOnlyNodesOnField()) {
                categoryReports.get(FIELD_NODES).add(this.compareNodes(null, gJaxbNode));
            }
            for (AbstractMap.SimpleEntry simpleEntry : this.separatedNodes.getCommonNodesWithDifferentAttributes()) {
                categoryReports.get(DIFFERENT_NODES).add(this.compareNodes((GJaxbNode)simpleEntry.getKey(), (GJaxbNode)simpleEntry.getValue()));
            }
            EdgeModelComparator sortedEdges = this.sortEdges(modelComparison.getExpectedModel(), modelComparison.getFieldModel());
            for (GJaxbEdge edge : sortedEdges.getOnlyEdgesOnExpected()) {
                categoryReports.get(EXPECTED_EDGES).add(this.compareEdges(edge, null));
            }
            for (GJaxbEdge edge : sortedEdges.getOnlyEdgesOnField()) {
                categoryReports.get(FIELD_EDGES).add(this.compareEdges(null, edge));
            }
        }
        return this.analyseResults(reports);
    }

    protected abstract ResultConcept<O> createCommonReport(GJaxbNode var1);

    protected abstract boolean equalsNodes(GJaxbNode var1, GJaxbNode var2);

    protected NodeModelComparator separateNodes(GJaxbModelsComparison.ExpectedModel expectedModel, GJaxbModelsComparison.FieldModel fieldModel) {
        NodeModelComparator nodesComparator = new NodeModelComparator(this);
        if (expectedModel.getGenericModel() != null) {
            for (GJaxbNode nodeE : expectedModel.getGenericModel().getNode()) {
                GJaxbNode foundNodeF = null;
                for (GJaxbNode nodeF : fieldModel.getGenericModel().getNode()) {
                    if (!this.equalsNodes(nodeE, nodeF)) continue;
                    foundNodeF = nodeF;
                    break;
                }
                if (foundNodeF != null && !this.containsNode(nodesComparator.getCommonsNodes(), nodeE)) {
                    if (this.compareSimilarNodeAttributes(nodeE, foundNodeF)) {
                        nodesComparator.getCommonsNodes().add(nodeE);
                        continue;
                    }
                    nodesComparator.getCommonNodesWithDifferentAttributes().add(new AbstractMap.SimpleEntry<GJaxbNode, GJaxbNode>(nodeE, foundNodeF));
                    continue;
                }
                if (this.containsNode(nodesComparator.getOnlyNodesOnExpected(), nodeE)) continue;
                nodesComparator.getOnlyNodesOnExpected().add(nodeE);
            }
        }
        if (fieldModel.getGenericModel() != null) {
            for (GJaxbNode nodeF : fieldModel.getGenericModel().getNode()) {
                if (this.containsNode(nodesComparator.getCommonsNodes(), nodeF) || this.containsPNode(nodesComparator.getCommonNodesWithDifferentAttributes(), nodeF) || this.containsNode(nodesComparator.getOnlyNodesOnField(), nodeF)) continue;
                nodesComparator.getOnlyNodesOnField().add(nodeF);
            }
        }
        return nodesComparator;
    }

    protected boolean compareSimilarNodeAttributes(GJaxbNode nodeE, GJaxbNode nodeF) {
        block0: for (GJaxbProperty propE : nodeE.getProperty()) {
            for (GJaxbProperty propF : nodeF.getProperty()) {
                if (!propE.getName().equals(propF.getName())) continue;
                if (propE.getValue() == null || propE.getValue().equals(propF.getValue())) continue block0;
                return false;
            }
        }
        return true;
    }

    protected boolean containsNode(List<GJaxbNode> nodes, GJaxbNode node) {
        for (GJaxbNode n : nodes) {
            if (!n.getId().equals(node.getId())) continue;
            return true;
        }
        return false;
    }

    protected boolean containsPNode(List<AbstractMap.SimpleEntry<GJaxbNode, GJaxbNode>> pnodes, GJaxbNode node) {
        for (AbstractMap.SimpleEntry<GJaxbNode, GJaxbNode> pnode : pnodes) {
            if (!node.getId().equals(pnode.getKey().getId())) continue;
            return true;
        }
        return false;
    }

    protected EdgeModelComparator sortEdges(GJaxbModelsComparison.ExpectedModel expectedModel, GJaxbModelsComparison.FieldModel fieldModel) {
        EdgeModelComparator egdesComparator = new EdgeModelComparator(this);
        if (expectedModel.getGenericModel() != null) {
            for (GJaxbEdge nodeE : expectedModel.getGenericModel().getEdge()) {
                boolean found = false;
                for (GJaxbEdge nodeF : fieldModel.getGenericModel().getEdge()) {
                    if (!nodeE.getId().equals(nodeF.getId())) continue;
                    found = true;
                }
                if (found && !this.containsEdge(egdesComparator.getCommonsEdges(), nodeE)) {
                    egdesComparator.getCommonsEdges().add(nodeE);
                    continue;
                }
                if (this.containsEdge(egdesComparator.getOnlyEdgesOnExpected(), nodeE)) continue;
                egdesComparator.getOnlyEdgesOnExpected().add(nodeE);
            }
        }
        if (fieldModel.getGenericModel() != null) {
            for (GJaxbEdge nodeF : fieldModel.getGenericModel().getEdge()) {
                if (this.containsEdge(egdesComparator.getCommonsEdges(), nodeF) || this.containsEdge(egdesComparator.getOnlyEdgesOnField(), nodeF)) continue;
                egdesComparator.getOnlyEdgesOnField().add(nodeF);
            }
        }
        return egdesComparator;
    }

    private boolean containsEdge(List<GJaxbEdge> edges, GJaxbEdge edge) {
        for (GJaxbEdge n : edges) {
            if (!n.getId().equals(edge.getId())) continue;
            return true;
        }
        return false;
    }

    public abstract void setData(List<GJaxbProperty> var1) throws Exception;

    public abstract ResultConcept<O> compareNodes(GJaxbNode var1, GJaxbNode var2) throws Exception;

    public abstract ResultConcept<O> compareEdges(GJaxbEdge var1, GJaxbEdge var2);

    public abstract GJaxbDetectionReports analyseResults(Map<String, Map<String, List<ResultConcept<O>>>> var1);

    public abstract String getInputJavascriptFunctionToCall();

    public abstract String getOutputJavascriptFunctionToCall();

    public abstract String getDescription();

    protected class NodeModelComparator {
        List<GJaxbNode> commonsNodes = new ArrayList<GJaxbNode>();
        List<GJaxbNode> onlyNodesOnExpected = new ArrayList<GJaxbNode>();
        List<GJaxbNode> onlyNodesOnField = new ArrayList<GJaxbNode>();
        List<AbstractMap.SimpleEntry<GJaxbNode, GJaxbNode>> commonNodesWithDifferentAttributes = new ArrayList<AbstractMap.SimpleEntry<GJaxbNode, GJaxbNode>>();

        protected NodeModelComparator(AbstractDetection this$0) {
        }

        public List<GJaxbNode> getCommonsNodes() {
            return this.commonsNodes;
        }

        public String retrieveAttributesDeviationReport() {
            StringBuilder sb = new StringBuilder();
            for (AbstractMap.SimpleEntry<GJaxbNode, GJaxbNode> p : this.commonNodesWithDifferentAttributes) {
                sb.append("node " + p.getKey().getId() + "\n");
                block1: for (GJaxbProperty propLeft : p.getKey().getProperty()) {
                    String propName = propLeft.getName();
                    String propLeftValue = propLeft.getValue();
                    List rightProps = p.getValue().getProperty();
                    for (GJaxbProperty rightProp : rightProps) {
                        if (!rightProp.getName().equals(propName)) continue;
                        String propRightValue = rightProp.getValue();
                        if (propLeftValue.equals(propRightValue)) continue block1;
                        sb.append(propName + ": ");
                        sb.append("expected " + propLeftValue + " | ");
                        sb.append("field    " + propRightValue);
                        sb.append("\n");
                        continue block1;
                    }
                }
            }
            return sb.toString();
        }

        public List<GJaxbNode> getOnlyNodesOnExpected() {
            return this.onlyNodesOnExpected;
        }

        public List<GJaxbNode> getOnlyNodesOnField() {
            return this.onlyNodesOnField;
        }

        public List<AbstractMap.SimpleEntry<GJaxbNode, GJaxbNode>> getCommonNodesWithDifferentAttributes() {
            return this.commonNodesWithDifferentAttributes;
        }
    }

    protected class EdgeModelComparator {
        List<GJaxbEdge> commonsEdges = new ArrayList<GJaxbEdge>();
        List<GJaxbEdge> onlyEdgesOnExpected = new ArrayList<GJaxbEdge>();
        List<GJaxbEdge> onlyEdgesOnField = new ArrayList<GJaxbEdge>();

        protected EdgeModelComparator(AbstractDetection this$0) {
        }

        public List<GJaxbEdge> getCommonsEdges() {
            return this.commonsEdges;
        }

        public List<GJaxbEdge> getOnlyEdgesOnExpected() {
            return this.onlyEdgesOnExpected;
        }

        public List<GJaxbEdge> getOnlyEdgesOnField() {
            return this.onlyEdgesOnField;
        }
    }
}

