/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.monitoring.detection.client;

import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.monitoring.detection.DetectFault;
import fr.emac.gind.monitoring.detection.Detection;
import fr.emac.gind.monitoring.detection.GJaxbDetect;
import fr.emac.gind.monitoring.detection.GJaxbDetectResponse;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHandler;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import jakarta.jws.WebMethod;
import jakarta.jws.WebResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DetectionClient
implements Detection {
    private SOAPSender sender = null;
    private String serverAddress = null;

    private DetectionClient(String serverAddress) throws Exception {
        assert (serverAddress != null);
        this.serverAddress = serverAddress;
        this.sender = new SOAPSender(new SOAPInterceptor[0]);
    }

    public static Detection createClient(String remoteAddress) throws Exception {
        Detection client = (Detection)LocalRegistry.getInstance().findWSImplementation(Detection.class);
        if (client == null) {
            client = new DetectionClient(remoteAddress);
        }
        return client;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    @WebMethod(action="http://www.gind.emac.fr/monitoring/detection/detect")
    @WebResult(name="detectResponse", targetNamespace="http://www.gind.emac.fr/monitoring/detection/", partName="parameters")
    public GJaxbDetectResponse detect(GJaxbDetect parameters) throws DetectFault {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "http://www.gind.emac.fr/monitoring/detection/detect");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbDetectResponse response = (GJaxbDetectResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbDetectResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new DetectFault(e.getMessage(), null, e);
        }
    }
}

