/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.monitoring.detection.launcher;

import fr.emac.gind.launcher.AbstractLauncher;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.monitoring.detection.DetectionWebService;
import java.util.HashMap;
import java.util.Map;

public class DetectionLauncher
extends AbstractLauncher {
    private DetectionWebService detection = null;
    private Map<String, Object> map = new HashMap<String, Object>();

    public String getInfo() {
        StringBuffer res = new StringBuffer();
        res.append("Detection Service.\n");
        res.append("Number of services exposed: " + this.detection.getAllAddresses().size() + "\n");
        res.append("\nList of services:\n");
        for (String string : this.detection.getAllAddresses()) {
            res.append("\t- " + string + "\n");
        }
        if (!this.map.isEmpty()) {
            res.append("\nConfiguration:\n");
            for (Map.Entry entry : this.map.entrySet()) {
                res.append("\t" + (String)entry.getKey() + " = " + String.valueOf(entry.getValue()) + "\n");
            }
        }
        return res.toString();
    }

    public String getName() {
        return "Detection Service";
    }

    public String getPromptName() {
        return "detection-gov";
    }

    public void startRunner(Configuration conf) throws Exception {
        this.detection = new DetectionWebService();
        this.map.clear();
        this.map.putAll(conf.getProperties());
        this.detection.start(this.map);
    }

    public void stopRunner() throws Exception {
        this.detection.stop();
    }
}

