/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.monitoring.detection;

import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.detectiongeneratorinstance.GJaxbDetectionGeneratorInstance;
import fr.emac.gind.detectiongeneratorinstance.GJaxbDetectionGeneratorInstances;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.models.client.ModelsGovClient;
import fr.emac.gind.gov.models_gov.ModelsGov;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.monitoring.detection.AbstractDetection;
import fr.emac.gind.monitoring.detection.DetectFault;
import fr.emac.gind.monitoring.detection.Detection;
import fr.emac.gind.monitoring.detection.GJaxbDetect;
import fr.emac.gind.monitoring.detection.GJaxbDetectResponse;
import fr.emac.gind.monitoring.detectionReport.GJaxbDetectionReports;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@WebService(portName="detectionSOAPEndpoint", serviceName="detectionService", targetNamespace="http://www.gind.emac.fr/monitoring/detection/", wsdlLocation="wsdl/detection.wsdl", endpointInterface="fr.emac.gind.monitoring.detection.Detection")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
public class DetectionImpl
implements Detection {
    private static Logger LOG = LoggerFactory.getLogger((String)DetectionImpl.class.getName());
    private Map<String, Object> context = null;
    private ServiceLoader<AbstractDetection<?>> detectionGeneratorLoader = ServiceLoader.load(AbstractDetection.class);
    private Map<String, AbstractDetection<?>> detectionGenerators = new HashMap();
    private CoreGov coreClient = null;
    private ModelsGov modelsClient = null;

    public DetectionImpl(Map<String, Object> context) throws Exception {
        this.context = context;
        String host = (String)context.get("host");
        Integer port = Integer.parseInt(context.get("port").toString());
        Integer proxyPort = Integer.parseInt(context.get("proxy-port").toString());
        this.coreClient = CoreGovClient.createClient((String)SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)host, (int)port, (int)proxyPort, (String)"/GovCore"));
        this.modelsClient = ModelsGovClient.createClient((String)SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)host, (int)port, (int)proxyPort, (String)"/GovModels"));
        this.initDetectionGenerators();
    }

    public GJaxbDetectResponse detect(GJaxbDetect parameters) throws DetectFault {
        GJaxbDetectionReports reports = null;
        try {
            AbstractDetection<?> procGen = this.detectionGenerators.get(parameters.getDetectionGeneratorInstance().getClazz());
            LOG.debug(XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters)));
            procGen.setCore(this.coreClient);
            List inputParams = null;
            if (parameters.getInputData() != null) {
                inputParams = parameters.getInputData().getProperty();
            }
            reports = procGen.detect(parameters.getCurrentCollaborationName(), parameters.getCurrentKnowledgeSpaceName(), inputParams, parameters.getModelsComparison());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new DetectFault(e.getMessage(), null, e);
        }
        GJaxbDetectResponse resp = new GJaxbDetectResponse();
        resp.setDetectionReports(reports);
        return resp;
    }

    private GJaxbDetectionGeneratorInstances initDetectionGenerators() throws Exception {
        GJaxbDetectionGeneratorInstances res = new GJaxbDetectionGeneratorInstances();
        this.detectionGenerators.clear();
        this.detectionGeneratorLoader.reload();
        for (AbstractDetection<?> detectionGenerator : this.detectionGeneratorLoader) {
            detectionGenerator.setCoreClient(this.coreClient);
            detectionGenerator.setModelClient(this.modelsClient);
            this.detectionGenerators.put(detectionGenerator.getClass().getName(), detectionGenerator);
            GJaxbDetectionGeneratorInstance gen = new GJaxbDetectionGeneratorInstance();
            gen.setName(detectionGenerator.getName());
            gen.setClazz(detectionGenerator.getClass().getName());
            gen.setDescription(detectionGenerator.getDescription());
            gen.setInputNgClickFunction(detectionGenerator.getInputJavascriptFunctionToCall());
            gen.setOutputNgClickFunction(detectionGenerator.getOutputJavascriptFunctionToCall());
            res.getDetectionGeneratorInstance().add(gen);
        }
        return res;
    }
}

