/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * first author: Nicolas SALATGE
 */
"use strict";


var d3StrategyDetectionOutput = {
    directive: {
        name: "d3StrategyDetectionOutputFormDirective",
        directive: function () {
            return {
                restrict: 'E',
                templateUrl: '/##application_name##/webjars/gind/d3StrategyDetection/javascripts/d3StrategyDetectionOutputForm.html' // replacement HTML (can use our scope vars here)
            }
        }
    },
    controller: {
        name: "d3StrategyDetectionOutputFormController",
        controller: function($scope) {

        }
    }
};
var d3StrategyDetectionInput = {
    directive: {
        name: "d3StrategyDetectionInputFormDirective",
        directive: function () {
            return {
                restrict: 'E',
                templateUrl: '/##application_name##/webjars/gind/d3StrategyDetection/javascripts/d3StrategyDetectionInputForm.html' // replacement HTML (can use our scope vars here)
            }
        }
    },
    controller: {
        name: "d3StrategyDetectionInputFormController",
        controller: function($scope) {

        }
    }
};
var d3StrategyDetectionEditionMatrix = {
    directive: {
        name: "d3StrategyDetectionMatrixEditionFormDirective",
        directive: function () {
            return {
                restrict: 'E',
                templateUrl: '/##application_name##/webjars/gind/d3StrategyDetection/javascripts/d3StrategyDetectionMatrixEditionForm.html' // replacement HTML (can use our scope vars here)
            }
        }
    },
    controller: {
        name: "d3StrategyDetectionMatrixEditionFormController",
        controller: function($scope) {

        }
    }
};


application.addWebComponent(d3StrategyDetectionOutput);
application.addWebComponent(d3StrategyDetectionInput);
application.addWebComponent(d3StrategyDetectionEditionMatrix);

/**
 *
 * @param{string} title
 * @param{string} msg
 * @constructor
 */
var d3StrategyDetectionOutputFormDialog = function(detectionGeneratorInstances, modelsComparisons, categories, $http, aes, sharedContextService, data) {
    var me = this;

    me.dialog = $('#d3StrategyDetectionOutputForm');
    ModalDialogUtil.applyView('#d3StrategyDetectionOutputForm', ModalDialogUtil.defaultMessageDialogView);

    console.log("me.dialog");
    console.log(me.dialog);
    console.log("me.dialog.scope()");
    console.log(me.dialog.scope());
    me.dialog.scope().data = data;
    me.dialog.scope().reports = data.detectResponse.detectionReports.detectionReport;


    me.show = function() {
        me.dialog.appendTo("body").modal('show');
    }

    me.dialog.scope().deduceProcess = function() {
        console.log("deduce process");
        deduceProcess($http, sharedContextService, aes);
        me.dialog.modal('hide');
    }

}


/**
 *
 * @param{string} title
 * @param{string} msg
 * @constructor
 */
var d3StrategyDetectionInputFormDialog = function(detectionGeneratorInstance, modelsComparisons, categories, $http, aes, sharedContextService) {
    var me = this;

    me.dialog = $('#d3StrategyDetectionInputForm');
    ModalDialogUtil.applyView('#d3StrategyDetectionInputForm', ModalDialogUtil.defaultMessageDialogView);

    console.log("me.dialog");
    console.log(me.dialog);
    console.log("me.dialog.scope()");
    console.log(me.dialog.scope());

    me.dialog.scope().predefinedMatrix = [];
    var ucContextProp = PropertyUtil.findProperty("ucContext", sharedContextService.currentUser.property);

    if(ucContextProp != null && ucContextProp.value != null) {
        var ucContext = util.parseJSON(ucContextProp.value);
        me.dialog.scope().predefinedMatrix = ucContext.input_detection_data;
    }

    me.dialog.scope().loadPredefinedMatrix = function () {
        var choices = {
            choices: [],
            selectedValue: null
        }
        for(var i = 0; i < me.dialog.scope().predefinedMatrix.length; i++) {
            var detectionMatrix = me.dialog.scope().predefinedMatrix[i];
            choices.choices.push({
                value: detectionMatrix.object.name,
                url: detectionMatrix.object.url
            })
        }


        new SingleChoiceDialog("Choose predefined matrix", choices, {
            function: function() {
                var loader = new LoadingDialog();
                loader.setCaller(function (loader) {

                    var requestParameters = {
                        url: choices.selectedValue.url,
                        className: "fr.emac.gind.detection.d3.GJaxbConceptsMatrix"
                    }

                    $http.defaults.headers.common['Authorization'] = 'AES ' + sharedContextService.currentToken;
                    $http({
                        url: bootstrap.createURL('/iota/loadPredefinedDataByUseCase'),
                        method: "POST",
                        data: requestParameters,
                        headers: {'Content-Type': 'application/json'}
                    }).then(function (response) {
                        console.log("post data after uuuuuuuuuuuuuuuuuuu :");
                        console.log(response);
                        loader.hide();
                        var conceptsMatrix = response.data.conceptsMatrix;


                        me.hide();
                        new MatrixEditionFormDialog(detectionGeneratorInstance, modelsComparisons, categories, $http, aes, sharedContextService, conceptsMatrix).show();

                    });
                })
                loader.show();
            }
        }).show();

    }

    me.dialog.scope().loadExistingMatrix = function() {

        new UploadSingleFileDialog('Upload matrix', bootstrap.createURL('/uploadfile/uploadXMLFileToJSON'), {
            function: function (data) {
                console.log("upload done: ");
                console.log(data);
                var conceptsMatrix = data.conceptsMatrix;


                me.hide();
                new MatrixEditionFormDialog(detectionGeneratorInstance, modelsComparisons, categories, $http, aes, sharedContextService, conceptsMatrix).show();
            },
            data: JSON.stringify({
                currentCollaborationName: sharedContextService.currentCollaborationName,
                currentKnowledgeSpaceName: sharedContextService.currentKnowledgeSpaceName,
                className: "fr.emac.gind.detection.d3.GJaxbConceptsMatrix"
            })
        }).show();

    }

    me.dialog.scope().createNewMatrix = function() {
        var matrix = {
            name: "matrix",
            concept: [],
        };

        for(var category in categories) {
            if(categories[category].effectiveMetaModel != undefined && categories[category].effectiveMetaModel != null) {
                for(var i = 0; i < categories[category].effectiveMetaModel.node.length; i++) {
                    var node = categories[category].effectiveMetaModel.node[i];
                    if(!me.dialog.scope().containsAlreadyConcept(matrix, node.type)) {
                        matrix.concept.push({
                            name: node.type,
                            importance: 1.0,
                            additionCost: 1.0,
                            deletionCost: 1.0,
                            modificationCost: 1.0
                        });
                    }
                }
            }
        }

        me.hide();
        new MatrixEditionFormDialog(detectionGeneratorInstance, modelsComparisons, categories, $http, aes, sharedContextService, matrix).show();
    }

    me.dialog.scope().containsAlreadyConcept = function(matrix, name) {
        for(var i = 0; i < matrix.concept.length; i++) {
            var concept = matrix.concept[i];
            if(concept.name == name) {
                return true;
            }
        }
        return false;
    }

    me.show = function() {
        me.dialog.appendTo("body").modal('show');
        me.dialog.modal({
            backdrop: 'static'
        });
    }

    me.hide = function() {
        me.dialog.modal('hide');
    }

}


var MatrixEditionFormDialog = function(detectionGeneratorInstance, modelsComparisons, categories, $http, aes, sharedContextService, matrix) {
    var me = this;

    me.dialog = $('#d3StrategyDetectionMatrixEditionForm');
    ModalDialogUtil.applyView('#d3StrategyDetectionMatrixEditionForm', ModalDialogUtil.defaultMessageDialogView);

    console.log("me.dialog");
    console.log(me.dialog);
    console.log("me.dialog.scope()");
    console.log(me.dialog.scope());
    me.dialog.scope().matrix = matrix;


    me.show = function() {
        me.dialog.appendTo("body").modal('show');
    }

    me.dialog.scope().exportMatrix = function() {
        var loader = new LoadingDialog();
        loader.setCaller(function (loader) {

            var request = {
                data: JSON.stringify({ conceptsMatrix: matrix } ),
                className: "fr.emac.gind.detection.d3.GJaxbConceptsMatrix"
            }

            $http({
                url: bootstrap.createURL('/iota/exportDataByUseCase'),
                method: "POST",
                data: request,
                responseType : "blob",
                transformResponse: function(data, headersGetter){
                    return data;
                },
                headers: {'Content-Type': 'application/json'}
            }).success(function (data, status, headers, config) {
                console.log("post data after:");
                console.log(data);
                var date = new Date().toJSON();
                date = date.substring(0, date.indexOf('.'));

                // see FileSaver.js
                saveAs(data, date + "_" + "d3_detectionMatrix" + ".xml");

                loader.hide();
            });

        })
        loader.show();

    }


    me.dialog.scope().detect = function() {
        var loader = new LoadingDialog();
        loader.setCaller(function (loader) {
            var request = {
                detectionStrategies: JSON.stringify(detectionGeneratorInstance),
                modelsComparisons: JSON.stringify(modelsComparisons),
                currentCollaborationName: sharedContextService.currentCollaborationName,
                currentKnowledgeSpaceName: sharedContextService.currentKnowledgeSpaceName,
                data: JSON.stringify({ conceptsMatrix: matrix })
            }
            $http({
                url: bootstrap.createURL('/iota/detect'),
                method: "POST",
                data: request,
                headers: {'Content-Type': 'application/json'}
            }).success(function (data, status, headers, config) {
                console.log("response detection generator:");
                console.log(data);
                loader.hide();
                if (detectionGeneratorInstance.output_ng_click_function != null && detectionGeneratorInstance.output_ng_click_function != undefined) {
                    eval(detectionGeneratorInstance.output_ng_click_function);
                }
            });
        })
        loader.show();
    }

}
