/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.game_master.service;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.game_master.FaultMessage;
import fr.emac.gind.game_master.GameMasterApi;
import fr.emac.gind.game_master.data.GJaxbCreateGameScenario;
import fr.emac.gind.game_master.data.GJaxbCreateGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbDeleteGameScenario;
import fr.emac.gind.game_master.data.GJaxbDeleteGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbDeleteGameScenarios;
import fr.emac.gind.game_master.data.GJaxbDeleteGameScenariosResponse;
import fr.emac.gind.game_master.data.GJaxbExportGameScenarios;
import fr.emac.gind.game_master.data.GJaxbExportGameScenariosResponse;
import fr.emac.gind.game_master.data.GJaxbFindGameScenarioById;
import fr.emac.gind.game_master.data.GJaxbFindGameScenarioByIdResponse;
import fr.emac.gind.game_master.data.GJaxbFindGameScenarioByName;
import fr.emac.gind.game_master.data.GJaxbFindGameScenarioByNameResponse;
import fr.emac.gind.game_master.data.GJaxbGameScenario;
import fr.emac.gind.game_master.data.GJaxbGetCurrentGameScenario;
import fr.emac.gind.game_master.data.GJaxbGetCurrentGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbGetGameScenario;
import fr.emac.gind.game_master.data.GJaxbGetGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbGetGameScenarios;
import fr.emac.gind.game_master.data.GJaxbGetGameScenariosResponse;
import fr.emac.gind.game_master.data.GJaxbSaveGameScenario;
import fr.emac.gind.game_master.data.GJaxbSaveGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbSetCurrentGameScenario;
import fr.emac.gind.game_master.data.GJaxbSetCurrentGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbUpdateGameScenario;
import fr.emac.gind.game_master.data.GJaxbUpdateGameScenarioResponse;
import fr.emac.gind.game_master.data.GJaxbUpdateMockEndpointBackup;
import fr.emac.gind.game_master.data.GJaxbUpdateMockEndpointBackupResponse;
import fr.emac.gind.game_master.data.GJaxbUpdateSensorControlerBackup;
import fr.emac.gind.game_master.data.GJaxbUpdateSensorControlerBackupResponse;
import fr.emac.gind.gov.core.client.CoreGovClient;
import fr.emac.gind.gov.core.client.util.Neo4JId;
import fr.emac.gind.gov.core_gov.CoreGov;
import fr.emac.gind.gov.core_gov.GJaxbGetNode;
import fr.emac.gind.gov.core_gov.GJaxbGetNodeResponse;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.mock.endpoints.manager.MockEndpointManager;
import fr.emac.gind.mock.endpoints.manager.MockEndpointManagerClient;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbCreateMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbCreateMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbGetMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbGetMockEndpointResponse;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbMockEndpointBackup;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.sensors.controler.SensorControler;
import fr.emac.gind.sensors.controler.SensorControlerClient;
import fr.emac.gind.sensors.controler.data.GJaxbAddDatasetAndRefreshModelOnSensorControler;
import fr.emac.gind.sensors.controler.data.GJaxbAddDatasetAndRefreshModelOnSensorControlerResponse;
import fr.emac.gind.sensors.controler.data.GJaxbCreateSensorControler;
import fr.emac.gind.sensors.controler.data.GJaxbCreateSensorControlerResponse;
import fr.emac.gind.sensors.controler.data.GJaxbDatasetInfo;
import fr.emac.gind.sensors.controler.data.GJaxbGetSensorControler;
import fr.emac.gind.sensors.controler.data.GJaxbGetSensorControlerResponse;
import fr.emac.gind.sensors.controler.data.GJaxbSensorControlerBackup;
import fr.emac.gind.sensors.controler.data.GJaxbSensorControlerModel;
import fr.emac.gind.sensors.controler.data.GJaxbStoreAllDatasetsOfAllSensorControlers;
import fr.emac.gind.sensors.controler.data.GJaxbStoreAllDatasetsOfAllSensorControlersResponse;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import fr.emac.gind.storage.GJaxbPut;
import fr.emac.gind.storage.GJaxbPutResponse;
import fr.emac.gind.storage.GJaxbQuery;
import fr.emac.gind.storage.GJaxbQueryResponse;
import fr.emac.gind.storage.GJaxbRemove;
import fr.emac.gind.storage.GJaxbRemoveAll;
import fr.emac.gind.storage.GJaxbRemoveAllResponse;
import fr.emac.gind.storage.GJaxbRemoveResponse;
import fr.emac.gind.storage.GJaxbUpdate;
import fr.emac.gind.storage.GJaxbUpdateResponse;
import fr.emac.gind.storage.Storage;
import fr.emac.gind.storage.client.StorageClient;
import jakarta.jws.WebService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@WebService(serviceName="game_master-service", portName="game_master-serviceSOAP", targetNamespace="http://www.gind.emac.fr/game_master/", wsdlLocation="wsdl/game_master_api.wsdl", endpointInterface="fr.emac.gind.game_master.GameMasterApi")
public class GameMasterSOAPImpl
implements GameMasterApi {
    private static final Logger LOG = LoggerFactory.getLogger((String)GameMasterSOAPImpl.class.getName());
    private Storage storageClient = null;
    private CoreGov coreGovClient = null;
    private SensorControler sensorControler = null;
    private MockEndpointManager mockEndpointManager = null;
    private Map<String, String> existingGameScenarios = new HashMap<String, String>();
    private String collection_name = null;

    public GameMasterSOAPImpl(Map<String, Object> context) throws Exception {
        this.collection_name = "GameScenario_" + RegExpHelper.toRegexFriendlyName((String)((String)context.get("host")).replace(".", "_")) + "_" + Integer.parseInt(context.get("port").toString());
        this.storageClient = StorageClient.createClient((String)((String)context.get("storage")));
        this.coreGovClient = CoreGovClient.createClient((String)((String)context.get("governance")));
        this.sensorControler = SensorControlerClient.createClient((String)((String)context.get("sensor-controler-server")));
        this.mockEndpointManager = MockEndpointManagerClient.createClient((String)((String)context.get("mock-endpoints-manager-server")));
    }

    public GJaxbCreateGameScenarioResponse createGameScenario(GJaxbCreateGameScenario parameters) throws FaultMessage {
        GJaxbCreateGameScenarioResponse res = new GJaxbCreateGameScenarioResponse();
        try {
            GJaxbGameScenario existingGameScenario = this.findGameScenarioById(parameters.getGameScenario().getScenarioId(), parameters.getCollaborationName(), parameters.getKnowledgeSpaceName());
            if (existingGameScenario == null) {
                GJaxbGameScenario gameScenario = parameters.getGameScenario();
                String document = "<jgind:json xmlns:jgind=\"http://www.gind.emac.fr/json\"><![CDATA[" + JSONJAXBContext.getInstance().marshallAnyElement((Object)gameScenario) + "]]></jgind:json>";
                org.w3c.dom.Document doc = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(document.getBytes()));
                GJaxbPut put = new GJaxbPut();
                put.setCollection(this.collection_name);
                put.setAny((Object)doc.getDocumentElement());
                GJaxbPutResponse resp = this.storageClient.put(put);
                gameScenario.setMongoDBId(resp.getId());
                existingGameScenario = gameScenario;
            }
            GJaxbUpdateGameScenario upReq = new GJaxbUpdateGameScenario();
            upReq.setGameScenario(existingGameScenario);
            upReq.setCollaborationName(parameters.getCollaborationName());
            upReq.setKnowledgeSpaceName(parameters.getKnowledgeSpaceName());
            this.updateGameScenario(upReq);
            res.setGameScenario(existingGameScenario);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, e);
        }
        return res;
    }

    private void verifyGameScenario(GJaxbGameScenario gameScenario) throws Exception {
        for (GJaxbSensorControlerBackup scb : gameScenario.getSensorControlerBackup()) {
            if (scb.getDatasetInfo() != null) continue;
            throw new Exception("No dataset found for: " + scb.getDataSource().getName());
        }
    }

    public GJaxbUpdateGameScenarioResponse updateGameScenario(GJaxbUpdateGameScenario parameters) throws FaultMessage {
        GJaxbUpdateGameScenarioResponse res = new GJaxbUpdateGameScenarioResponse();
        try {
            GJaxbUpdate update = new GJaxbUpdate();
            update.setCollection(this.collection_name);
            update.setId(parameters.getGameScenario().getMongoDBId());
            this.verifyGameScenario(parameters.getGameScenario());
            String document = "<jgind:json xmlns:jgind=\"http://www.gind.emac.fr/json\"><![CDATA[" + JSONJAXBContext.getInstance().marshallAnyElement((Object)parameters.getGameScenario()) + "]]></jgind:json>";
            org.w3c.dom.Document doc = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(document.getBytes()));
            update.setAny((Object)doc.getDocumentElement());
            assert (update.getId() != null);
            GJaxbUpdateResponse resp = this.storageClient.update(update);
            res.setGameScenario(parameters.getGameScenario());
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    private GJaxbGameScenario findGameScenarioById(String gameScenarioId, String collaborationName, String knowledgeSpaceName) throws Exception {
        GJaxbFindGameScenarioById findReq = new GJaxbFindGameScenarioById();
        findReq.setScenarioId(gameScenarioId);
        findReq.setCollaborationName(collaborationName);
        findReq.setKnowledgeSpaceName(knowledgeSpaceName);
        GJaxbFindGameScenarioByIdResponse findResp = this.findGameScenarioById(findReq);
        return findResp.getGameScenario();
    }

    public GJaxbFindGameScenarioByIdResponse findGameScenarioById(GJaxbFindGameScenarioById parameters) throws FaultMessage {
        GJaxbFindGameScenarioByIdResponse _return = new GJaxbFindGameScenarioByIdResponse();
        try {
            GJaxbQuery query = new GJaxbQuery();
            query.setCollection(this.collection_name);
            query.setQuery("{\n   \"gameScenario.scenarioId\" : \"" + parameters.getScenarioId() + "\" \n}");
            GJaxbQueryResponse queryResponse = this.storageClient.query(query);
            for (Object obj : queryResponse.getAny()) {
                Element result = (Element)obj;
                Document doc = Document.parse((String)result.getTextContent());
                GJaxbGameScenario gameScenario = (GJaxbGameScenario)JSONJAXBContext.getInstance().unmarshall("{ \"gameScenario\" : " + ((Document)doc.get((Object)"gameScenario")).toJson() + " }", GJaxbGameScenario.class);
                this.verifyGameScenario(gameScenario);
                _return.setGameScenario(gameScenario);
            }
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return _return;
    }

    public GJaxbFindGameScenarioByNameResponse findGameScenarioByName(GJaxbFindGameScenarioByName parameters) throws FaultMessage {
        GJaxbFindGameScenarioByNameResponse _return = new GJaxbFindGameScenarioByNameResponse();
        try {
            GJaxbQuery query = new GJaxbQuery();
            query.setCollection(this.collection_name);
            query.setQuery("{\n   \"gameScenario.name\" : \"" + parameters.getName() + "\" \n}");
            GJaxbQueryResponse queryResponse = this.storageClient.query(query);
            for (Object obj : queryResponse.getAny()) {
                Element result = (Element)obj;
                Document doc = Document.parse((String)result.getTextContent());
                GJaxbGameScenario gameScenario = (GJaxbGameScenario)JSONJAXBContext.getInstance().unmarshall("{ \"gameScenario\" : " + ((Document)doc.get((Object)"gameScenario")).toJson() + " }", GJaxbGameScenario.class);
                this.verifyGameScenario(gameScenario);
                _return.setGameScenario(gameScenario);
            }
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return _return;
    }

    public GJaxbGetGameScenarioResponse getGameScenario(GJaxbGetGameScenario parameters) throws FaultMessage {
        GJaxbGetGameScenarioResponse _return = new GJaxbGetGameScenarioResponse();
        try {
            GJaxbQuery query = new GJaxbQuery();
            query.setCollection(this.collection_name);
            query.setQuery("{\n   \"gameScenario.scenarioId\" : \"" + parameters.getScenarioId() + "\" \n}");
            GJaxbQueryResponse queryResponse = this.storageClient.query(query);
            for (Object obj : queryResponse.getAny()) {
                Element result = (Element)obj;
                Document doc = Document.parse((String)result.getTextContent());
                GJaxbGameScenario gameScenario = (GJaxbGameScenario)JSONJAXBContext.getInstance().unmarshall("{ \"gameScenario\" : " + ((Document)doc.get((Object)"gameScenario")).toJson() + " }", GJaxbGameScenario.class);
                _return.setGameScenario(this.lightGameScenario(gameScenario));
            }
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return _return;
    }

    private void replaceExistingSensorControlerBackupIfExist(GJaxbSensorControlerBackup rd, List<GJaxbSensorControlerBackup> rds) {
        rds.removeIf(r -> Neo4JId.cleanId((String)r.getDataSource().getId()).equals(Neo4JId.cleanId((String)rd.getDataSource().getId())));
        rds.add(rd);
    }

    private GJaxbGameScenario lightGameScenario(GJaxbGameScenario gameScenario) {
        GJaxbGameScenario copyGs = new GJaxbGameScenario();
        copyGs.setScenarioId(gameScenario.getScenarioId());
        copyGs.setMongoDBId(gameScenario.getMongoDBId());
        copyGs.setName(gameScenario.getName());
        copyGs.setNumberOfTimeSteps(gameScenario.getNumberOfTimeSteps());
        copyGs.setTimeBetweenSteps(gameScenario.getTimeBetweenSteps());
        gameScenario.getSensorControlerBackup().forEach(oldSensorCtrlBackup -> {
            GJaxbSensorControlerBackup newSensorCtrlBackup = new GJaxbSensorControlerBackup();
            newSensorCtrlBackup.setDataSource(oldSensorCtrlBackup.getDataSource());
            newSensorCtrlBackup.setDatasetInfo(oldSensorCtrlBackup.getDatasetInfo());
            newSensorCtrlBackup.setSelected(oldSensorCtrlBackup.isSelected());
            this.replaceExistingSensorControlerBackupIfExist(newSensorCtrlBackup, copyGs.getSensorControlerBackup());
        });
        copyGs.getMockEndpointBackup().addAll(gameScenario.getMockEndpointBackup());
        copyGs.getActuatorsAggregator().addAll(gameScenario.getActuatorsAggregator());
        return copyGs;
    }

    public GJaxbGetGameScenariosResponse getGameScenarios(GJaxbGetGameScenarios parameters) throws FaultMessage {
        return this.extractGameScenarios(parameters, true);
    }

    private GJaxbGetGameScenariosResponse extractGameScenarios(GJaxbGetGameScenarios parameters, boolean light) throws FaultMessage {
        GJaxbGetGameScenariosResponse _return = new GJaxbGetGameScenariosResponse();
        try {
            GJaxbQuery query = new GJaxbQuery();
            query.setCollection(this.collection_name);
            query.setQuery("{\n}");
            GJaxbQueryResponse queryResponse = this.storageClient.query(query);
            for (Object obj : queryResponse.getAny()) {
                Element result = (Element)obj;
                Document doc = Document.parse((String)result.getTextContent());
                GJaxbGameScenario gameScenario = (GJaxbGameScenario)JSONJAXBContext.getInstance().unmarshall("{ \"gameScenario\" : " + ((Document)doc.get((Object)"gameScenario")).toJson() + " }", GJaxbGameScenario.class);
                if (gameScenario.getName() == null) continue;
                if (light) {
                    _return.getGameScenario().add(this.lightGameScenario(gameScenario));
                    continue;
                }
                _return.getGameScenario().add(gameScenario);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, e);
        }
        return _return;
    }

    public GJaxbDeleteGameScenarioResponse deleteGameScenario(GJaxbDeleteGameScenario parameters) throws FaultMessage {
        GJaxbDeleteGameScenarioResponse response = new GJaxbDeleteGameScenarioResponse();
        try {
            GJaxbRemove remove = new GJaxbRemove();
            remove.setCollection(this.collection_name);
            remove.setId(parameters.getMongoDBId());
            GJaxbRemoveResponse resp = this.storageClient.remove(remove);
            Element result = (Element)resp.getAny();
            Document doc = Document.parse((String)result.getTextContent());
            GJaxbGameScenario gameScenario = (GJaxbGameScenario)JSONJAXBContext.getInstance().unmarshall("{ \"gameScenario\" : " + ((Document)doc.get((Object)"gameScenario")).toJson() + " }", GJaxbGameScenario.class);
            response.setGameScenario(gameScenario);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            LOG.error(ex.getMessage(), ex);
            throw new FaultMessage(ex.getMessage(), null, ex);
        }
        return response;
    }

    public GJaxbSaveGameScenarioResponse saveGameScenario(GJaxbSaveGameScenario parameters) throws FaultMessage {
        GJaxbSaveGameScenarioResponse response = new GJaxbSaveGameScenarioResponse();
        try {
            String gameScenarioId = parameters.getScenarioId();
            GJaxbFindGameScenarioById findReq = new GJaxbFindGameScenarioById();
            findReq.setScenarioId(gameScenarioId);
            findReq.setCollaborationName(parameters.getCollaborationName());
            findReq.setKnowledgeSpaceName(parameters.getKnowledgeSpaceName());
            GJaxbFindGameScenarioByIdResponse findResp = this.findGameScenarioById(findReq);
            GJaxbGameScenario gs = findResp.getGameScenario();
            if (gs != null) {
                GJaxbStoreAllDatasetsOfAllSensorControlers req = new GJaxbStoreAllDatasetsOfAllSensorControlers();
                req.setCollaborationName(parameters.getCollaborationName());
                req.setKnowledgeSpaceName(parameters.getKnowledgeSpaceName());
                GJaxbStoreAllDatasetsOfAllSensorControlersResponse resp = this.sensorControler.storeAllDatasetsOfAllSensorControlers(req);
                for (GJaxbSensorControlerBackup newSensorCtrlBackup : resp.getSensorControlerBackup()) {
                    GJaxbSensorControlerBackup oldSensorCtrlBackup = new GJaxbSensorControlerBackup();
                    oldSensorCtrlBackup.setGameScenarioId(gameScenarioId);
                    oldSensorCtrlBackup.setDataSource(new GJaxbSensorControlerBackup.DataSource());
                    oldSensorCtrlBackup.getDataSource().setId(Neo4JId.cleanId((String)newSensorCtrlBackup.getDataSource().getId()));
                    oldSensorCtrlBackup.getDataSource().setName(newSensorCtrlBackup.getDataSource().getName());
                    oldSensorCtrlBackup.setSelected(newSensorCtrlBackup.isSelected());
                    oldSensorCtrlBackup.setDatasetInfo(new GJaxbDatasetInfo());
                    oldSensorCtrlBackup.getDatasetInfo().setName(newSensorCtrlBackup.getDatasetInfo().getName());
                    oldSensorCtrlBackup.getDatasetInfo().setZip(newSensorCtrlBackup.getDatasetInfo().getZip());
                    this.replaceExistingSensorControlerBackupIfExist(oldSensorCtrlBackup, gs.getSensorControlerBackup());
                }
                GJaxbUpdateGameScenario upReq = new GJaxbUpdateGameScenario();
                upReq.setGameScenario(gs);
                upReq.setCollaborationName(parameters.getCollaborationName());
                upReq.setKnowledgeSpaceName(parameters.getKnowledgeSpaceName());
                this.updateGameScenario(upReq);
            }
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbGetCurrentGameScenarioResponse getCurrentGameScenario(GJaxbGetCurrentGameScenario parameters) throws FaultMessage {
        GJaxbGetCurrentGameScenarioResponse response = new GJaxbGetCurrentGameScenarioResponse();
        try {
            String key = RegExpHelper.toRegexFriendlyName((String)parameters.getCollaborationName()) + ":" + RegExpHelper.toRegexFriendlyName((String)parameters.getKnowledgeSpaceName());
            if (this.existingGameScenarios.get(key) != null) {
                String scenarioId = this.existingGameScenarios.get(key);
                GJaxbFindGameScenarioById findReq = new GJaxbFindGameScenarioById();
                findReq.setScenarioId(scenarioId);
                findReq.setCollaborationName(parameters.getCollaborationName());
                findReq.setKnowledgeSpaceName(parameters.getKnowledgeSpaceName());
                GJaxbFindGameScenarioByIdResponse findResp = this.findGameScenarioById(findReq);
                response.setGameScenario(findResp.getGameScenario());
                List<GJaxbSensorControlerModel> sensorControlerModels = this.createAllSensorControlerModels(response.getGameScenario(), parameters.getCollaborationName(), parameters.getKnowledgeSpaceName());
                response.getSensorControlerModel().addAll(sensorControlerModels);
                List<GJaxbMockEndpoint> mockEndpoints = this.createAllMockEndpoints(response.getGameScenario(), parameters.getCollaborationName(), parameters.getKnowledgeSpaceName());
                response.getMockEndpoint().addAll(mockEndpoints);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbSetCurrentGameScenarioResponse setCurrentGameScenario(GJaxbSetCurrentGameScenario parameters) throws FaultMessage {
        GJaxbSetCurrentGameScenarioResponse response = new GJaxbSetCurrentGameScenarioResponse();
        try {
            String key = RegExpHelper.toRegexFriendlyName((String)parameters.getCollaborationName()) + ":" + RegExpHelper.toRegexFriendlyName((String)parameters.getKnowledgeSpaceName());
            String existingScenarioId = this.existingGameScenarios.get(key);
            if (existingScenarioId == null || !existingScenarioId.equals(parameters.getScenarioId())) {
                GJaxbGameScenario newGameScenario = null;
                GJaxbFindGameScenarioById findReq = new GJaxbFindGameScenarioById();
                findReq.setScenarioId(parameters.getScenarioId());
                findReq.setCollaborationName(parameters.getCollaborationName());
                findReq.setKnowledgeSpaceName(parameters.getKnowledgeSpaceName());
                GJaxbFindGameScenarioByIdResponse findResp = this.findGameScenarioById(findReq);
                newGameScenario = findResp.getGameScenario();
                if (newGameScenario == null) {
                    throw new Exception("Impossible to find game scenario with scenarioId: " + parameters.getScenarioId());
                }
                List<GJaxbSensorControlerModel> sensorControlerModels = this.createAllSensorControlerModels(newGameScenario, parameters.getCollaborationName(), parameters.getKnowledgeSpaceName());
                response.getSensorControlerModel().addAll(sensorControlerModels);
                for (GJaxbMockEndpointBackup mockEndpointB : newGameScenario.getMockEndpointBackup()) {
                    GJaxbCreateMockEndpoint req = new GJaxbCreateMockEndpoint();
                    req.setCollaborationName(parameters.getCollaborationName());
                    req.setKnowledgeSpaceName(parameters.getKnowledgeSpaceName());
                    req.setGameScenarioId(parameters.getScenarioId());
                    req.setMockEndpoint(mockEndpointB.getMockEndpoint());
                    req.setStartEndpoint(true);
                    this.mockEndpointManager.createMockEndpoint(req);
                }
                this.existingGameScenarios.put(key, parameters.getScenarioId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public List<GJaxbSensorControlerModel> createAllSensorControlerModels(GJaxbGameScenario newGameScenario, String collaborationName, String knowledgeSpaceName) throws fr.emac.gind.sensors.controler.FaultMessage, fr.emac.gind.gov.core_gov.FaultMessage {
        ArrayList<GJaxbSensorControlerModel> sensorControlerModels = new ArrayList<GJaxbSensorControlerModel>();
        for (GJaxbSensorControlerBackup sensorCtrlBackup : newGameScenario.getSensorControlerBackup()) {
            GJaxbSensorControlerModel sensorControlerModel = this.createSensorCtrlModelFromSensorCrtlBackup(sensorCtrlBackup, newGameScenario.getScenarioId(), collaborationName, knowledgeSpaceName);
            if (sensorControlerModel == null) continue;
            sensorControlerModels.add(sensorControlerModel);
        }
        return sensorControlerModels;
    }

    public GJaxbSensorControlerModel createSensorCtrlModelFromSensorCrtlBackup(GJaxbSensorControlerBackup sensorCtrlBackup, String gameScenarioId, String collaborationName, String knowledgeSpaceName) throws fr.emac.gind.sensors.controler.FaultMessage, fr.emac.gind.gov.core_gov.FaultMessage {
        GJaxbGetSensorControler getReq = new GJaxbGetSensorControler();
        getReq.setDataSourceId(sensorCtrlBackup.getDataSource().getId());
        getReq.setCollaborationName(collaborationName);
        getReq.setKnowledgeSpaceName(knowledgeSpaceName);
        GJaxbGetSensorControlerResponse getResp = this.sensorControler.getSensorControler(getReq);
        GJaxbSensorControlerModel sensorControlerModel = getResp.getSensorControlerModel();
        if (sensorControlerModel == null) {
            GJaxbGetNode getNodeReq = new GJaxbGetNode();
            getNodeReq.setId(Neo4JId.cleanId((String)sensorCtrlBackup.getDataSource().getId()));
            getNodeReq.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            getNodeReq.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
            getNodeReq.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
            GJaxbGetNodeResponse getNodeResp = this.coreGovClient.getNode(getNodeReq);
            if (getNodeResp.getNode() != null) {
                GJaxbCreateSensorControler createReq = new GJaxbCreateSensorControler();
                createReq.setDataSource(new GJaxbCreateSensorControler.DataSource());
                createReq.getDataSource().setId(Neo4JId.cleanId((String)getNodeResp.getNode().getId()));
                createReq.getDataSource().setName(GenericModelHelper.getName((GJaxbNode)getNodeResp.getNode()));
                createReq.setGameScenarioId(gameScenarioId);
                createReq.setSelected(sensorCtrlBackup.isSelected());
                createReq.setType(GenericModelHelper.findProperty((String)"type", (List)getNodeResp.getNode().getProperty()).getValue());
                createReq.setNature(GenericModelHelper.findProperty((String)"nature", (List)getNodeResp.getNode().getProperty()).getValue());
                createReq.setCollaborationName(collaborationName);
                createReq.setKnowledgeSpaceName(knowledgeSpaceName);
                GJaxbCreateSensorControlerResponse createResp = this.sensorControler.createSensorControler(createReq);
                sensorControlerModel = createResp.getSensorControlerModel();
            }
        }
        if (sensorCtrlBackup.getDatasetInfo() != null && sensorCtrlBackup.getDatasetInfo().isSetZip() && sensorControlerModel != null) {
            GJaxbAddDatasetAndRefreshModelOnSensorControler addDataReq = new GJaxbAddDatasetAndRefreshModelOnSensorControler();
            addDataReq.setDataSourceId(sensorControlerModel.getDataSource().getId());
            addDataReq.setGameScenarioId(gameScenarioId);
            addDataReq.setZip(sensorCtrlBackup.getDatasetInfo().getZip());
            addDataReq.setCollaborationName(collaborationName);
            addDataReq.setKnowledgeSpaceName(knowledgeSpaceName);
            addDataReq.setSelected(sensorControlerModel.isSelected());
            GJaxbAddDatasetAndRefreshModelOnSensorControlerResponse gJaxbAddDatasetAndRefreshModelOnSensorControlerResponse = this.sensorControler.addDatasetAndRefreshModelOnSensorControler(addDataReq);
        }
        return sensorControlerModel;
    }

    private List<GJaxbMockEndpoint> createAllMockEndpoints(GJaxbGameScenario newGameScenario, String collaborationName, String knowledgeSpaceName) throws Exception {
        ArrayList<GJaxbMockEndpoint> mockEndpoints = new ArrayList<GJaxbMockEndpoint>();
        for (GJaxbMockEndpointBackup mockEndpointBackup : newGameScenario.getMockEndpointBackup()) {
            GJaxbMockEndpoint mockEndpoint = this.createMockEndpointFromMockEndpointBackup(mockEndpointBackup, newGameScenario.getScenarioId(), collaborationName, knowledgeSpaceName);
            if (mockEndpoint == null) continue;
            mockEndpoints.add(mockEndpoint);
        }
        return mockEndpoints;
    }

    private GJaxbMockEndpoint createMockEndpointFromMockEndpointBackup(GJaxbMockEndpointBackup mockEndpointBackup, String gameScenarioId, String collaborationName, String knowledgeSpaceName) throws Exception {
        GJaxbGetMockEndpoint getReq = new GJaxbGetMockEndpoint();
        getReq.setId(mockEndpointBackup.getMockEndpoint().getId());
        getReq.setGameScenarioId(gameScenarioId);
        getReq.setCollaborationName(collaborationName);
        getReq.setKnowledgeSpaceName(knowledgeSpaceName);
        GJaxbGetMockEndpointResponse getResp = this.mockEndpointManager.getMockEndpoint(getReq);
        GJaxbMockEndpoint mockEndpoint = getResp.getMockEndpoint();
        if (mockEndpoint == null) {
            GJaxbGetNode getNodeReq = new GJaxbGetNode();
            getNodeReq.setId(Neo4JId.cleanId((String)mockEndpointBackup.getMockEndpoint().getNode().getId()));
            getNodeReq.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
            getNodeReq.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
            getNodeReq.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
            GJaxbGetNodeResponse getNodeResp = this.coreGovClient.getNode(getNodeReq);
            if (getNodeResp.getNode() != null) {
                GJaxbCreateMockEndpoint createReq = new GJaxbCreateMockEndpoint();
                createReq.setMockEndpoint(mockEndpointBackup.getMockEndpoint());
                createReq.setGameScenarioId(gameScenarioId);
                createReq.setStartEndpoint(mockEndpointBackup.getMockEndpoint().isSelected());
                createReq.setCollaborationName(collaborationName);
                createReq.setKnowledgeSpaceName(knowledgeSpaceName);
                GJaxbCreateMockEndpointResponse createResp = this.mockEndpointManager.createMockEndpoint(createReq);
                mockEndpoint = createResp.getMockEndpoint();
            }
        }
        return mockEndpoint;
    }

    public GJaxbExportGameScenariosResponse exportGameScenarios(GJaxbExportGameScenarios parameters) throws FaultMessage {
        GJaxbExportGameScenariosResponse response = new GJaxbExportGameScenariosResponse();
        try {
            String key = RegExpHelper.toRegexFriendlyName((String)parameters.getCollaborationName()) + ":" + RegExpHelper.toRegexFriendlyName((String)parameters.getKnowledgeSpaceName());
            String currentScenarioId = this.existingGameScenarios.get(key);
            GJaxbSaveGameScenario saveReq = new GJaxbSaveGameScenario();
            saveReq.setScenarioId(currentScenarioId);
            saveReq.setCollaborationName(parameters.getCollaborationName());
            saveReq.setKnowledgeSpaceName(parameters.getKnowledgeSpaceName());
            this.saveGameScenario(saveReq);
            GJaxbGetGameScenarios getScsReq = new GJaxbGetGameScenarios();
            getScsReq.setCollaborationName(parameters.getCollaborationName());
            getScsReq.setKnowledgeSpaceName(parameters.getKnowledgeSpaceName());
            GJaxbGetGameScenariosResponse getScsResp = this.extractGameScenarios(getScsReq, false);
            response.getGameScenario().addAll(getScsResp.getGameScenario());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbDeleteGameScenariosResponse deleteGameScenarios(GJaxbDeleteGameScenarios parameters) throws FaultMessage {
        GJaxbDeleteGameScenariosResponse response = new GJaxbDeleteGameScenariosResponse();
        try {
            GJaxbRemoveAll remove = new GJaxbRemoveAll();
            remove.setCollection(this.collection_name);
            GJaxbRemoveAllResponse gJaxbRemoveAllResponse = this.storageClient.removeAll(remove);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            LOG.error(ex.getMessage(), ex);
            throw new FaultMessage(ex.getMessage(), null, ex);
        }
        return response;
    }

    public GJaxbUpdateSensorControlerBackupResponse updateSensorControlerBackup(GJaxbUpdateSensorControlerBackup parameters) throws FaultMessage {
        GJaxbUpdateSensorControlerBackupResponse res = new GJaxbUpdateSensorControlerBackupResponse();
        try {
            GJaxbFindGameScenarioById findGS = new GJaxbFindGameScenarioById();
            findGS.setScenarioId(parameters.getGameScenarioId());
            findGS.setCollaborationName(parameters.getCollaborationName());
            findGS.setKnowledgeSpaceName(parameters.getKnowledgeSpaceName());
            GJaxbFindGameScenarioByIdResponse findGSResp = this.findGameScenarioById(findGS);
            GJaxbGameScenario gs = findGSResp.getGameScenario();
            Optional<GJaxbSensorControlerBackup> scb = gs.getSensorControlerBackup().stream().filter(sc -> Neo4JId.cleanId((String)sc.getDataSource().getId()).equals(Neo4JId.cleanId((String)parameters.getSensorControlerBackup().getDataSource().getId()))).findFirst();
            if (scb.isPresent()) {
                scb.get().setSelected(parameters.getSensorControlerBackup().isSelected());
                if (parameters.getSensorControlerBackup().getDatasetInfo() != null) {
                    scb.get().setDatasetInfo(parameters.getSensorControlerBackup().getDatasetInfo());
                }
            } else {
                gs.getSensorControlerBackup().add(parameters.getSensorControlerBackup());
            }
            GJaxbUpdateGameScenario updateGS = new GJaxbUpdateGameScenario();
            updateGS.setGameScenario(gs);
            updateGS.setCollaborationName(parameters.getCollaborationName());
            updateGS.setKnowledgeSpaceName(parameters.getKnowledgeSpaceName());
            this.updateGameScenario(updateGS);
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbUpdateMockEndpointBackupResponse updateMockEndpointBackup(GJaxbUpdateMockEndpointBackup parameters) throws FaultMessage {
        GJaxbUpdateMockEndpointBackupResponse res = new GJaxbUpdateMockEndpointBackupResponse();
        try {
            GJaxbFindGameScenarioById findGS = new GJaxbFindGameScenarioById();
            findGS.setScenarioId(parameters.getGameScenarioId());
            findGS.setCollaborationName(parameters.getCollaborationName());
            findGS.setKnowledgeSpaceName(parameters.getKnowledgeSpaceName());
            GJaxbFindGameScenarioByIdResponse findGSResp = this.findGameScenarioById(findGS);
            GJaxbGameScenario gs = findGSResp.getGameScenario();
            Optional<GJaxbMockEndpointBackup> scb = gs.getMockEndpointBackup().stream().filter(me -> Neo4JId.cleanId((String)me.getMockEndpoint().getId()).equals(Neo4JId.cleanId((String)parameters.getMockEndpointBackup().getMockEndpoint().getId()))).findFirst();
            if (scb.isPresent()) {
                scb.get().setSelected(parameters.getMockEndpointBackup().isSelected());
                if (parameters.getMockEndpointBackup().getMockEndpoint() != null) {
                    scb.get().setMockEndpoint(parameters.getMockEndpointBackup().getMockEndpoint());
                }
            } else {
                gs.getMockEndpointBackup().add(parameters.getMockEndpointBackup());
            }
            GJaxbUpdateGameScenario updateGS = new GJaxbUpdateGameScenario();
            updateGS.setGameScenario(gs);
            updateGS.setCollaborationName(parameters.getCollaborationName());
            updateGS.setKnowledgeSpaceName(parameters.getKnowledgeSpaceName());
            this.updateGameScenario(updateGS);
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }
}

