/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.store.gis.client;

import fr.emac.gind.commons.utils.io.zip.ZipUtil;
import fr.emac.gind.commons.utils.uri.URIHelper;
import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.gis.store_gis.FaultMessage;
import fr.emac.gind.gis.store_gis.GJaxbDeployGeoJSONFile;
import fr.emac.gind.gis.store_gis.GJaxbDeployGeoJSONFileResponse;
import fr.emac.gind.gis.store_gis.GJaxbGetGeoJSONFilesStored;
import fr.emac.gind.gis.store_gis.GJaxbGetGeoJSONFilesStoredResponse;
import fr.emac.gind.gis.store_gis.GJaxbLoadGeoJSONFile;
import fr.emac.gind.gis.store_gis.GJaxbLoadGeoJSONFileResponse;
import fr.emac.gind.gis.store_gis.GJaxbPackage;
import fr.emac.gind.gis.store_gis.GJaxbQuery;
import fr.emac.gind.gis.store_gis.GJaxbQueryResponse;
import fr.emac.gind.gis.store_gis.GJaxbUndeployGeoJSONFile;
import fr.emac.gind.gis.store_gis.GJaxbUndeployGeoJSONFileResponse;
import fr.emac.gind.gis.store_gis.StoreGis;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHandler;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebResult;
import java.io.File;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StoreGisClient
implements StoreGis {
    private static final Logger LOG = LoggerFactory.getLogger((String)StoreGisClient.class.getName());
    private String address = null;
    private SOAPSender sender = null;

    private StoreGisClient(String address) throws Exception {
        this.address = address;
        this.sender = new SOAPSender(new SOAPInterceptor[0]);
    }

    public static StoreGis createClient(String remoteAddress) throws Exception {
        StoreGis client = (StoreGis)LocalRegistry.getInstance().findWSImplementation(StoreGis.class);
        if (client == null) {
            client = new StoreGisClient(remoteAddress);
        }
        return client;
    }

    public String getAddress() {
        return this.address;
    }

    @Override
    @WebMethod(action="http://www.gind.emac.fr/gis/store_gis/query")
    @WebResult(name="queryResponse", targetNamespace="http://www.gind.emac.fr/gis/store_gis/", partName="parameters")
    public GJaxbQueryResponse query(@WebParam(partName="parameters", name="query", targetNamespace="http://www.gind.emac.fr/gis/store_gis/") GJaxbQuery parameters) throws FaultMessage {
        GJaxbQueryResponse result = null;
        try {
            Document request = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document response = this.sender.sendSoapRequest(request, this.address, "http://www.gind.emac.fr/gis/store_gis/query");
            if (SOAPHandler.isSoapFault((Document)response)) {
                throw new Exception("WS ERROR: \n " + XMLPrettyPrinter.print((Node)response));
            }
            result = (GJaxbQueryResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)response), GJaxbQueryResponse.class);
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
        return result;
    }

    @Override
    @WebMethod(action="http://www.gind.emac.fr/gis/store_gis/loadGeoJSONFile")
    @WebResult(name="loadGeoJSONFileResponse", targetNamespace="http://www.gind.emac.fr/gis/store_gis/", partName="parameters")
    public GJaxbLoadGeoJSONFileResponse loadGeoJSONFile(@WebParam(partName="parameters", name="loadGeoJSONFile", targetNamespace="http://www.gind.emac.fr/gis/store_gis/") GJaxbLoadGeoJSONFile parameters) throws FaultMessage {
        GJaxbLoadGeoJSONFileResponse result = null;
        try {
            Document request = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document response = this.sender.sendSoapRequest(request, this.address, "http://www.gind.emac.fr/gis/store_gis/loadGeoJSONFile");
            if (SOAPHandler.isSoapFault((Document)response)) {
                throw new Exception("WS ERROR: \n " + XMLPrettyPrinter.print((Node)response));
            }
            result = (GJaxbLoadGeoJSONFileResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)response), GJaxbLoadGeoJSONFileResponse.class);
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
        return result;
    }

    @Override
    @WebMethod(action="http://www.gind.emac.fr/gis/store_gis/getGeoJSONFilesStored")
    @WebResult(name="getGeoJSONFilesStoredResponse", targetNamespace="http://www.gind.emac.fr/gis/store_gis/", partName="parameters")
    public GJaxbGetGeoJSONFilesStoredResponse getGeoJSONFilesStored(@WebParam(partName="parameters", name="getGeoJSONFilesStored", targetNamespace="http://www.gind.emac.fr/gis/store_gis/") GJaxbGetGeoJSONFilesStored parameters) throws FaultMessage {
        GJaxbGetGeoJSONFilesStoredResponse result = null;
        try {
            Document request = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document response = this.sender.sendSoapRequest(request, this.address, "http://www.gind.emac.fr/gis/store_gis/getGeoJSONFilesStored");
            if (SOAPHandler.isSoapFault((Document)response)) {
                throw new Exception("WS ERROR: \n " + XMLPrettyPrinter.print((Node)response));
            }
            result = (GJaxbGetGeoJSONFilesStoredResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)response), GJaxbGetGeoJSONFilesStoredResponse.class);
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
        return result;
    }

    @Override
    @WebMethod(action="http://www.gind.emac.fr/gis/store_gis/deployGeoJSONFile")
    @WebResult(name="deployGeoJSONFileResponse", targetNamespace="http://www.gind.emac.fr/gis/store_gis/", partName="parameters")
    public GJaxbDeployGeoJSONFileResponse deployGeoJSONFile(@WebParam(partName="parameters", name="deployGeoJSONFile", targetNamespace="http://www.gind.emac.fr/gis/store_gis/") GJaxbDeployGeoJSONFile parameters) throws FaultMessage {
        GJaxbDeployGeoJSONFileResponse result = null;
        try {
            Document request = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document response = this.sender.sendSoapRequest(request, this.address, "http://www.gind.emac.fr/gis/store_gis/deployGeoJSONFile");
            if (SOAPHandler.isSoapFault((Document)response)) {
                throw new Exception("WS ERROR: \n " + XMLPrettyPrinter.print((Node)response));
            }
            result = (GJaxbDeployGeoJSONFileResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)response), GJaxbDeployGeoJSONFileResponse.class);
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
        return result;
    }

    @Override
    @WebMethod(action="http://www.gind.emac.fr/gis/store_gis/undeployGeoJSONFile")
    @WebResult(name="undeployGeoJSONFileResponse", targetNamespace="http://www.gind.emac.fr/gis/store_gis/", partName="parameters")
    public GJaxbUndeployGeoJSONFileResponse undeployGeoJSONFile(@WebParam(partName="parameters", name="undeployGeoJSONFile", targetNamespace="http://www.gind.emac.fr/gis/store_gis/") GJaxbUndeployGeoJSONFile parameters) throws FaultMessage {
        GJaxbUndeployGeoJSONFileResponse result = null;
        try {
            Document request = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document response = this.sender.sendSoapRequest(request, this.address, "http://www.gind.emac.fr/gis/store_gis/undeployGeoJSONFile");
            if (SOAPHandler.isSoapFault((Document)response)) {
                throw new Exception("WS ERROR: \n " + XMLPrettyPrinter.print((Node)response));
            }
            result = (GJaxbUndeployGeoJSONFileResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)response), GJaxbUndeployGeoJSONFileResponse.class);
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
        return result;
    }

    public static GJaxbDeployGeoJSONFileResponse deployGeoJSONFile(StoreGis client, File geoJSONFile) throws Exception {
        if (!geoJSONFile.exists()) {
            throw new Exception("geojsonFile not found!!!");
        }
        String path = geoJSONFile.toURI().toURL().toString().substring(0, geoJSONFile.toURI().toURL().toString().lastIndexOf("/") + "/".length());
        String geoJSONFileName = geoJSONFile.toURI().toURL().toString().replace(path, "");
        String mappingFileName = geoJSONFileName.replace(".geojson", "_mapping.xml");
        File mappingFile = new File(URIHelper.resolve((URI)URI.create(path), (String)mappingFileName));
        if (!mappingFile.exists()) {
            throw new Exception("mappingFile not found!!!");
        }
        String zipFileName = geoJSONFileName.replace(".geojson", ".zip");
        File zipFile = new File(URIHelper.resolve((URI)URI.create(path), (String)zipFileName));
        ZipUtil.zip((File)zipFile, (String)("./" + geoJSONFileName.replace(".geojson", "")), (File[])new File[]{geoJSONFile, mappingFile});
        return StoreGisClient.deployZipFile(client, zipFile);
    }

    public static GJaxbDeployGeoJSONFileResponse deployZipFile(StoreGis client, File zipFile) throws Exception {
        assert (zipFile != null);
        String name = null;
        GJaxbPackage _package = new GJaxbPackage();
        DataHandler bin = null;
        if (!zipFile.toString().endsWith(".zip")) {
            throw new Exception("This resource must be a zip file: " + String.valueOf(zipFile));
        }
        name = zipFile.getName();
        bin = new DataHandler((DataSource)new FileDataSource(zipFile));
        if (bin != null) {
            _package.setZip(bin);
        }
        GJaxbDeployGeoJSONFile request = new GJaxbDeployGeoJSONFile();
        request.setName(name);
        request.setPackage(_package);
        GJaxbDeployGeoJSONFileResponse response = client.deployGeoJSONFile(request);
        return response;
    }
}

