/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.h2gis.gis;

import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.io.zip.ZipUtil;
import jakarta.activation.DataHandler;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)RepositoryManager.class.getName());
    private String repositoryPath = null;

    public void initialize(String repositoryPath) throws Exception {
        this.repositoryPath = repositoryPath;
        if (this.repositoryPath == null) {
            this.repositoryPath = new File("../repoository").toString();
            LOG.info("Repository not defined in property so creation of repository at: " + this.repositoryPath);
        }
        new File(repositoryPath).mkdirs();
    }

    public File getRepository() throws Exception {
        if (this.repositoryPath == null) {
            return null;
        }
        return new File(this.repositoryPath);
    }

    public RepositoryResult getResource(List<String> extensions, String zipName) throws Exception {
        File mainDirectory = new File(this.repositoryPath, zipName.toString().replace(".zip", ""));
        if (mainDirectory.exists()) {
            return new RepositoryResult(this, mainDirectory);
        }
        return null;
    }

    public RepositoryResult addResource(String name, DataHandler dh) throws Exception {
        if (this.repositoryPath == null) {
            throw new Exception("Repository cannot be null!!! you must set this property in config file");
        }
        new File(this.repositoryPath).mkdirs();
        File zipFile = new File(this.repositoryPath, name);
        if (!zipFile.exists()) {
            zipFile.createNewFile();
        }
        LOG.info("Add new resource: " + name);
        File mainDirectory = ZipUtil.unZip((InputStream)dh.getInputStream(), (File)new File(this.repositoryPath));
        FileUtils.forceDelete((File)zipFile);
        return new RepositoryResult(this, mainDirectory);
    }

    public void deleteResource(String mainDirectory) throws Exception {
        File dir;
        if (this.repositoryPath != null && (dir = new File(this.repositoryPath, mainDirectory)).exists()) {
            FileUtil.deleteDirectory((File)dir);
        }
    }

    public void clear() throws Exception {
        if (this.repositoryPath != null) {
            FileUtil.deleteDirectory((File)new File(this.repositoryPath));
            new File(this.repositoryPath).mkdirs();
        }
    }

    public class RepositoryResult {
        File mainDirectory;

        public RepositoryResult(RepositoryManager this$0, File mainDirectory) {
            this.mainDirectory = mainDirectory;
        }

        public File getMainDirectory() {
            return this.mainDirectory;
        }
    }
}

