/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.h2gis.gis.launcher;

import fr.emac.gind.h2gis.gis.H2GisWebService;
import fr.emac.gind.launcher.AbstractLauncher;
import fr.emac.gind.launcher.Configuration;
import java.util.HashMap;
import java.util.Map;

public class H2GISGisLauncher
extends AbstractLauncher {
    private H2GisWebService storage = null;
    private Map<String, Object> map = new HashMap<String, Object>();

    public String getInfo() {
        StringBuffer res = new StringBuffer();
        res.append("Storage Service based on H2GIS.\n");
        res.append("Number of services exposed: " + this.storage.getAllAddresses().size() + "\n");
        res.append("\nList of services:\n");
        for (String string : this.storage.getAllAddresses()) {
            res.append("\t- " + string + "\n");
        }
        if (!this.map.isEmpty()) {
            res.append("\nConfiguration:\n");
            for (Map.Entry entry : this.map.entrySet()) {
                res.append("\t" + (String)entry.getKey() + " = " + String.valueOf(entry.getValue()) + "\n");
            }
        }
        return res.toString();
    }

    public String getName() {
        return "Storage Service based on H2GIS";
    }

    public String getPromptName() {
        return "h2gis";
    }

    public void startRunner(Configuration conf) throws Exception {
        this.storage = new H2GisWebService();
        this.map.clear();
        this.map.putAll(conf.getProperties());
        this.storage.start(this.map);
    }

    public void stopRunner() throws Exception {
        this.storage.stop();
    }
}

