/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.h2gis.gis;

import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.h2gis.gis.H2GisFindGisImpl;
import fr.emac.gind.h2gis.gis.H2GisStoreGisImpl;
import fr.emac.gind.h2gis.gis.RepositoryManager;
import java.util.HashMap;
import java.util.Map;

public class H2GisWebService
extends SPIWebServicePrimitives {
    H2GisStoreGisImpl storeServer = null;
    H2GisFindGisImpl findServer = null;

    public void onInit(Map<String, Object> context) {
        try {
            this.storeServer = new H2GisStoreGisImpl(context);
            this.findServer = new H2GisFindGisImpl(this.storeServer);
            this.registerWSImplementation("store_gis", this.storeServer);
            this.registerWSImplementation("find_gis", this.findServer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RepositoryManager getRepositoryManager() {
        return this.storeServer.getRepositoryManager();
    }

    public void stop() throws Exception {
        super.stop();
        this.storeServer.shutdown();
    }

    public static H2GisWebService createAndStart(final int port) throws Exception {
        H2GisWebService wsStorage = new H2GisWebService();
        wsStorage.start(new HashMap<String, Object>(){
            {
                this.put("host", "localhost");
                this.put("port", port);
                this.put("h2gis-database-url", "jdbc:h2:mem:syntax");
                this.put("h2gis-database-login", "sa");
                this.put("h2gis-database-pwd", "sa");
            }
        });
        return wsStorage;
    }
}

