/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.h2gis.gis;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.lang.UncheckedException;
import fr.emac.gind.commons.utils.uri.URIHelper;
import fr.emac.gind.gis.mappingmodel.GJaxbMappingModel;
import fr.emac.gind.gis.mappingmodel.GJaxbPropertiesMapping;
import fr.emac.gind.gis.mappingmodel.GJaxbSource;
import fr.emac.gind.gis.mappingmodel.GJaxbTable;
import fr.emac.gind.gis.store_gis.FaultMessage;
import fr.emac.gind.gis.store_gis.GJaxbDeployGeoJSONFile;
import fr.emac.gind.gis.store_gis.GJaxbDeployGeoJSONFileResponse;
import fr.emac.gind.gis.store_gis.GJaxbGetGeoJSONFilesStored;
import fr.emac.gind.gis.store_gis.GJaxbGetGeoJSONFilesStoredResponse;
import fr.emac.gind.gis.store_gis.GJaxbLoadGeoJSONFile;
import fr.emac.gind.gis.store_gis.GJaxbLoadGeoJSONFileResponse;
import fr.emac.gind.gis.store_gis.GJaxbQuery;
import fr.emac.gind.gis.store_gis.GJaxbQueryResponse;
import fr.emac.gind.gis.store_gis.GJaxbUndeployGeoJSONFile;
import fr.emac.gind.gis.store_gis.GJaxbUndeployGeoJSONFileResponse;
import fr.emac.gind.gis.store_gis.StoreGis;
import fr.emac.gind.h2gis.gis.RepositoryManager;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbArea;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbPolyline;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.modeler.genericmodel.GJaxbRelationModeType;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import jakarta.activation.DataHandler;
import jakarta.jws.WebService;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.h2gis.ext.H2GISExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(serviceName="store_gis", portName="store_gisSOAP", targetNamespace="http://www.gind.emac.fr/gis/store_gis/", wsdlLocation="wsdl/store-gis.wsdl", endpointInterface="fr.emac.gind.gis.store_gis.StoreGis")
public class H2GisStoreGisImpl
implements StoreGis {
    private static final Logger LOG = LoggerFactory.getLogger((String)H2GisStoreGisImpl.class.getName());
    private String url = null;
    private String login = null;
    private String pwd = null;
    private Connection connection = null;
    private org.h2.Driver driver = null;
    private RepositoryManager repositoryManager;
    private static Map<String, GJaxbTable> TABLES_MAPPING = new HashMap<String, GJaxbTable>();
    protected Map<QName, GJaxbEffectiveMetaModel> allMetaModels = new HashMap<QName, GJaxbEffectiveMetaModel>();
    private boolean indexActivated = false;

    public H2GisStoreGisImpl(Map<String, Object> context) throws Exception {
        if (context.get("h2gis-database-url") == null) {
            throw new UncheckedException("Configuration Error: h2gis-database-url cannot be null!!!");
        }
        if (context.get("h2gis-database-login") == null) {
            throw new UncheckedException("Configuration Error: h2gis-database-login cannot be null!!!");
        }
        if (context.get("h2gis-database-pwd") == null) {
            throw new UncheckedException("Configuration Error: h2gis-database-pwd cannot be null!!!");
        }
        if (context.get("h2gis-indexation") != null) {
            this.indexActivated = Boolean.valueOf(context.get("h2gis-indexation").toString());
        }
        this.url = context.get("h2gis-database-url").toString();
        this.login = context.get("h2gis-database-login").toString();
        this.pwd = context.get("h2gis-database-pwd").toString();
        this.repositoryManager = new RepositoryManager();
        if (context.get("h2gis-database-repository") != null) {
            this.repositoryManager.initialize((String)context.get("h2gis-database-repository"));
        }
        this.allMetaModels = EffectiveMetaModelPluginManager.getInstance().getEffectiveMetaModelFromContainerByQNameMap();
        this.execute("CREATE ALIAS IF NOT EXISTS H2GIS_EXTENSION FOR \"org.h2gis.ext.H2GISExtension.load\";");
        this.execute("CALL H2GIS_EXTENSION();");
        this.execute("CREATE ALIAS IF NOT EXISTS H2GIS_SPATIAL FOR \"org.h2gis.functions.factory.H2GISFunctions.load\";");
        this.execute("CALL H2GIS_SPATIAL();");
    }

    public Map<String, GJaxbTable> getTablesMapping() {
        return TABLES_MAPPING;
    }

    public RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public void shutdown() throws Exception {
        if (this.connection != null) {
            LOG.debug("NUMBER OF TABLE DO DELETE: " + TABLES_MAPPING.size());
            for (Map.Entry<String, GJaxbTable> entry : TABLES_MAPPING.entrySet()) {
                String tableName = entry.getKey();
                LOG.debug("DROP TABLE `" + tableName + "`");
                this.execute("DROP TABLE `" + tableName + "` IF EXISTS");
            }
            this.getTablesMapping().clear();
            this.allMetaModels.clear();
            this.connection.close();
            this.connection = null;
            org.h2.Driver.unload();
            DriverManager.deregisterDriver((Driver)this.driver);
            LOG.debug("*********** DELETE CONNECTION FOR H2GIS *****************");
        }
    }

    public Connection getConnection() throws Exception {
        if (this.connection == null) {
            LOG.debug("Loading custom class loader for H2 driver: " + Thread.currentThread().getContextClassLoader().toString());
            this.driver = (org.h2.Driver)Class.forName("org.h2.Driver", true, Thread.currentThread().getContextClassLoader()).newInstance();
            LOG.debug("Loaded H2 driver: " + this.driver.toString() + " - " + this.driver.getMinorVersion() + " - " + this.driver.getMajorVersion());
            DriverManager.registerDriver((Driver)this.driver);
            this.connection = DriverManager.getConnection(this.url, this.login, this.pwd);
            H2GISExtension.load((Connection)this.connection);
            LOG.debug("*********** CREATE NEW CONNECTION FOR H2GIS *****************");
        }
        return this.connection;
    }

    public List<Map<String, Object>> getResult(ResultSet rs) throws Exception {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnsNumber = rsmd.getColumnCount();
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 1; i <= columnsNumber; ++i) {
                map.put(rsmd.getColumnName(i), rs.getObject(i));
            }
            res.add(map);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean execute(String query) throws Exception {
        try (Statement st = null;){
            st = this.getConnection().createStatement();
            boolean bl = st.execute(query);
            return bl;
        }
    }

    public synchronized ResultSet executeQuery(String query) throws Exception {
        Statement st = this.getConnection().createStatement();
        return st.executeQuery(query);
    }

    public GJaxbLoadGeoJSONFileResponse loadGeoJSONFile(GJaxbLoadGeoJSONFile parameters) throws FaultMessage {
        GJaxbLoadGeoJSONFileResponse response = new GJaxbLoadGeoJSONFileResponse();
        try {
            String path = parameters.getUrl().toString().substring(0, parameters.getUrl().toString().lastIndexOf("/") + "/".length());
            String geoJSONFileName = parameters.getUrl().toString().replace(path, "");
            String mappingFile = geoJSONFileName.replace(".geojson", "_mapping.xml");
            URL mappingFileURL = URIHelper.resolve((URI)URI.create(path), (String)mappingFile).toURL();
            GJaxbMappingModel mappingModel = (GJaxbMappingModel)XMLJAXBContext.getInstance().unmarshallDocument(mappingFileURL, GJaxbMappingModel.class);
            String tableName = ((GJaxbTable)mappingModel.getTable().get(0)).getTableName().toUpperCase();
            this.getTablesMapping().put(tableName, (GJaxbTable)mappingModel.getTable().get(0));
            LOG.debug("ADD TABLE: " + tableName);
            LOG.debug("NUMBER OF TABLE: " + this.getTablesMapping().size());
            LOG.debug("SELECT count(*)>0 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME like '" + tableName + "'");
            ResultSet tableExistsRS = this.executeQuery("SELECT count(*)>0 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME like '" + tableName + "'");
            boolean found = false;
            while (tableExistsRS.next()) {
                found = tableExistsRS.getBoolean(1);
                LOG.debug("found " + found);
            }
            if (found) {
                LOG.warn(tableName + " already exists in database.");
            } else {
                this.execute("CALL GeoJsonRead('" + parameters.getUrl() + "', '" + tableName + "');");
                ResultSet rs = this.executeQuery("SELECT count(*) FROM `" + tableName + "`");
                List<Map<String, Object>> list = this.getResult(rs);
                long count = (Long)list.get(0).get("COUNT(*)");
                response.setCount(count);
            }
            if (this.indexActivated) {
                this.execute("CREATE SPATIAL INDEX  if not exists \"" + tableName + "_sp_idx\" ON `" + tableName + "`(THE_GEOM)");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbQueryResponse query(GJaxbQuery parameters) throws FaultMessage {
        GJaxbQueryResponse response = new GJaxbQueryResponse();
        try {
            ResultSet rs = this.executeQuery(parameters.getQuery());
            List<Map<String, Object>> list = this.getResult(rs);
            GJaxbGenericModel genModel = new GJaxbGenericModel();
            List<String> tables = this.findTables(parameters.getQuery());
            for (Map<String, Object> map : list) {
                GJaxbNode node = this.convertToNode(map, tables);
                genModel.getNode().add(node);
            }
            response.setSingle(new GJaxbQueryResponse.Single());
            response.getSingle().setGenericModel(genModel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public List<String> findTables(String query) throws Exception {
        String ts = query.toLowerCase();
        String res = null;
        if (ts.indexOf(" from ") == -1) {
            throw new Exception("No tables found!!!");
        }
        if (ts.indexOf(" from ") >= 0) {
            res = query.substring(ts.indexOf(" from ") + " from ".length());
            ts = ts.substring(ts.indexOf(" from ") + " from ".length());
        }
        if (ts.lastIndexOf(" where ") >= 0) {
            res = res.substring(0, ts.lastIndexOf(" where "));
            ts = ts.substring(0, ts.lastIndexOf(" where "));
        }
        ArrayList<String> l = new ArrayList<String>();
        for (String table : Arrays.asList(res.split(","))) {
            l.add(table.trim().replace("`", ""));
        }
        return l;
    }

    public GJaxbNode convertToNode(Map<String, Object> row, List<String> tablesNames) throws Exception {
        GJaxbNode node = new GJaxbNode();
        if (tablesNames.size() == 0) {
            throw new Exception("No tables found!!!");
        }
        if (tablesNames.size() > 1) {
            throw new Exception("Several tables found!!! Not supported fro now!!!");
        }
        GJaxbTable table = this.getTablesMapping().get(tablesNames.get(0).toUpperCase());
        node.setId("gis_node_" + String.valueOf(UUID.randomUUID()));
        node.setType(table.getConceptName());
        node.getStatus().add(GJaxbStatusType.ACTIVE);
        GJaxbEffectiveConceptType metaNode = EffectiveMetaModelPluginManager.getInstance().getConceptByType(table.getConceptName());
        if (metaNode == null) {
            throw new Exception("Impossible to find: " + String.valueOf(table.getConceptName()));
        }
        for (GJaxbPropertiesMapping propMapping : table.getPropertiesMapping()) {
            if (propMapping.getSource().size() > 1) {
                throw new Exception("Several columnNames found!!! Not supported for now!!!");
            }
            String propertyName = propMapping.getTarget().getPropertyName();
            String propertyValue = null;
            GJaxbProperty prop = null;
            if (((GJaxbSource)propMapping.getSource().get(0)).getColumnName() != null) {
                propertyValue = row.get(((GJaxbSource)propMapping.getSource().get(0)).getColumnName()) != null ? row.get(((GJaxbSource)propMapping.getSource().get(0)).getColumnName()).toString() : null;
            } else if (((GJaxbSource)propMapping.getSource().get(0)).getConstant() != null) {
                propertyValue = ((GJaxbSource)propMapping.getSource().get(0)).getConstant();
                if (propertyValue.contains("${random}")) {
                    propertyValue = propertyValue.replace("${random}", String.valueOf(Math.random()));
                }
                if (propertyValue.contains("${id}")) {
                    propertyValue = propertyValue.replace("${id}", node.getId());
                }
            }
            prop = GenericModelHelper.createProperty((String)propertyName, propertyValue);
            node.getProperty().add(prop);
        }
        Object geom = row.get("THE_GEOM");
        if (geom instanceof MultiPolygon) {
            MultiPolygon polygon = (MultiPolygon)geom;
            node.setGeolocation(new GJaxbNode.Geolocation());
            node.getGeolocation().getItemView().add(new GJaxbNode.Geolocation.ItemView());
            ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).setArea(new GJaxbArea());
            if (metaNode.getNodeMetaGeolocation().getArea() != null) {
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getArea().setFillColor(metaNode.getNodeMetaGeolocation().getArea().getFillColor());
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getArea().setFillOpacity(metaNode.getNodeMetaGeolocation().getArea().getFillOpacity());
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeColor(metaNode.getNodeMetaGeolocation().getArea().getStrokeColor());
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeDashArray(metaNode.getNodeMetaGeolocation().getArea().getStrokeDashArray());
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeOpacity(metaNode.getNodeMetaGeolocation().getArea().getStrokeOpacity());
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getArea().setStrokeWidth(metaNode.getNodeMetaGeolocation().getArea().getStrokeWidth());
            }
            for (Coordinate coord : polygon.getCoordinates()) {
                GJaxbPointType point = new GJaxbPointType();
                point.setLatitude(Double.valueOf(coord.y));
                point.setLongitude(Double.valueOf(coord.x));
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getArea().getPoint().add(point);
            }
            ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).setRedesign(Boolean.valueOf(false));
        } else if (geom instanceof Point) {
            Point point = (Point)geom;
            node.setGeolocation(new GJaxbNode.Geolocation());
            node.getGeolocation().getItemView().add(new GJaxbNode.Geolocation.ItemView());
            ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).setPoint(new GJaxbPointType());
            ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPoint().setLatitude(Double.valueOf(point.getCoordinate().y));
            ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPoint().setLongitude(Double.valueOf(point.getCoordinate().x));
        } else if (geom instanceof MultiLineString) {
            line = (MultiLineString)geom;
            node.setGeolocation(new GJaxbNode.Geolocation());
            node.getGeolocation().getItemView().add(new GJaxbNode.Geolocation.ItemView());
            ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).setPolyline(new GJaxbPolyline());
            if (metaNode.getNodeMetaGeolocation().getPolyline() != null) {
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setFillColor(metaNode.getNodeMetaGeolocation().getPolyline().getFillColor());
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setFillOpacity(metaNode.getNodeMetaGeolocation().getPolyline().getFillOpacity());
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeColor(metaNode.getNodeMetaGeolocation().getPolyline().getStrokeColor());
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeDashArray(metaNode.getNodeMetaGeolocation().getPolyline().getStrokeDashArray());
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeOpacity(metaNode.getNodeMetaGeolocation().getPolyline().getStrokeOpacity());
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeWidth(metaNode.getNodeMetaGeolocation().getPolyline().getStrokeWidth());
            }
            for (Coordinate coord : line.getCoordinates()) {
                GJaxbPointType point = new GJaxbPointType();
                point.setLatitude(Double.valueOf(coord.y));
                point.setLongitude(Double.valueOf(coord.x));
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPolyline().getPoint().add(point);
            }
            ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).setRedesign(Boolean.valueOf(false));
        } else if (geom instanceof LineString) {
            line = (LineString)geom;
            node.setGeolocation(new GJaxbNode.Geolocation());
            node.getGeolocation().getItemView().add(new GJaxbNode.Geolocation.ItemView());
            ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).setPolyline(new GJaxbPolyline());
            if (metaNode.getNodeMetaGeolocation().getPolyline() != null) {
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setFillColor(metaNode.getNodeMetaGeolocation().getPolyline().getFillColor());
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setFillOpacity(metaNode.getNodeMetaGeolocation().getPolyline().getFillOpacity());
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeColor(metaNode.getNodeMetaGeolocation().getPolyline().getStrokeColor());
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeDashArray(metaNode.getNodeMetaGeolocation().getPolyline().getStrokeDashArray());
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeOpacity(metaNode.getNodeMetaGeolocation().getPolyline().getStrokeOpacity());
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getSpecificGeolocation().getNodeMetaGeolocation().getPolyline().setStrokeWidth(metaNode.getNodeMetaGeolocation().getPolyline().getStrokeWidth());
            }
            for (Coordinate coord : line.getCoordinates()) {
                GJaxbPointType point = new GJaxbPointType();
                point.setLatitude(Double.valueOf(coord.y));
                point.setLongitude(Double.valueOf(coord.x));
                ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).getPolyline().getPoint().add(point);
            }
            ((GJaxbNode.Geolocation.ItemView)node.getGeolocation().getItemView().get(0)).setRedesign(Boolean.valueOf(false));
        } else {
            throw new Exception("Geometry not supported!!!");
        }
        return node;
    }

    public void findParentNode(GJaxbGenericModel genModel) {
        TreeMap<Float, GJaxbNode> orderByArea = new TreeMap<Float, GJaxbNode>();
        for (GJaxbNode node : genModel.getNode()) {
            orderByArea.put(Float.valueOf(Float.parseFloat(GenericModelHelper.findProperty((String)"area", (List)node.getProperty()).getValue())), node);
        }
        GJaxbNode parentNode = null;
        ArrayList croissantOrder = new ArrayList(orderByArea.values());
        Collections.reverse(croissantOrder);
        for (GJaxbNode node : croissantOrder) {
            if (parentNode != null) {
                GJaxbEdge containsEdge = GenericModelHelper.createEdgeBetweenNodes((GJaxbNode)node, (GJaxbNode)parentNode, (QName)new QName("http://fr.emac.gind/uml-model", "Compose"), (GJaxbRelationModeType)GJaxbRelationModeType.COMPOSITION);
                genModel.getEdge().add(containsEdge);
            }
            parentNode = node;
        }
    }

    public GJaxbDeployGeoJSONFileResponse deployGeoJSONFile(GJaxbDeployGeoJSONFile parameters) throws FaultMessage {
        GJaxbDeployGeoJSONFileResponse response = new GJaxbDeployGeoJSONFileResponse();
        try {
            DataHandler zip = parameters.getPackage().getZip();
            RepositoryManager.RepositoryResult repoResult = this.repositoryManager.addResource(parameters.getName(), zip);
            File dir = repoResult.getMainDirectory();
            File geoJSON = null;
            for (File f : FileUtil.getAllFiles((File)dir)) {
                if (!"geojson".equals(FileUtil.getExtension((String)f.getName().trim()))) continue;
                geoJSON = f;
                break;
            }
            if (geoJSON == null) {
                throw new Exception("geoJSONFile cannot be null (.geojson) !!!");
            }
            String osName = System.getProperty("os.name");
            LOG.debug("OS NAME " + osName);
            String tableName = "";
            tableName = osName.toLowerCase().contains("windows") ? geoJSON.toString().substring(geoJSON.toString().lastIndexOf("\\") + "\\".length(), geoJSON.toString().lastIndexOf(".")) : geoJSON.toString().substring(geoJSON.toString().lastIndexOf("/") + "/".length(), geoJSON.toString().lastIndexOf("."));
            LOG.debug("table name " + tableName);
            GJaxbLoadGeoJSONFile request = new GJaxbLoadGeoJSONFile();
            request.setUrl(geoJSON.toURI().toURL().toString());
            GJaxbLoadGeoJSONFileResponse resp = this.loadGeoJSONFile(request);
            response.setCount(resp.getCount());
            response.setTableName(tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return response;
    }

    public GJaxbUndeployGeoJSONFileResponse undeployGeoJSONFile(GJaxbUndeployGeoJSONFile parameters) throws FaultMessage {
        GJaxbUndeployGeoJSONFileResponse res = new GJaxbUndeployGeoJSONFileResponse();
        try {
            String tableName = parameters.getTableName();
            this.execute("DROP TABLE `" + tableName + "`");
            this.repositoryManager.deleteResource(tableName);
            this.getTablesMapping().remove(tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbGetGeoJSONFilesStoredResponse getGeoJSONFilesStored(GJaxbGetGeoJSONFilesStored parameters) throws FaultMessage {
        GJaxbGetGeoJSONFilesStoredResponse res = new GJaxbGetGeoJSONFilesStoredResponse();
        for (GJaxbTable table : this.getTablesMapping().values()) {
            GJaxbGetGeoJSONFilesStoredResponse.GeoJSONFiles jsons = new GJaxbGetGeoJSONFilesStoredResponse.GeoJSONFiles();
            jsons.setName(table.getName());
            jsons.setClassifier(table.getClassifier());
            jsons.setTableName(table.getTableName());
            res.getGeoJSONFiles().add(jsons);
        }
        return res;
    }
}

