/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.gis.mappingmodel;

import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.io.zip.ZipUtil;
import fr.emac.gind.commons.utils.uri.URIHelper;
import fr.emac.gind.gis.mappingmodel.GJaxbMappingModel;
import fr.emac.gind.gis.mappingmodel.GJaxbPropertiesMapping;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Optional;

public abstract class AbstractMappingModel {
    private URL geoJSONUrl = null;
    private GJaxbMappingModel mappingModel = null;

    public void init() throws Exception {
        String userHomeDirectoryName = System.getProperty("user.home");
        File userHomeDirectory = new File(userHomeDirectoryName);
        URL mappingFileURL = this.getEmbeddedMappingFile();
        if (userHomeDirectory.isDirectory()) {
            File[] geojsons;
            File localZipRepository = new File(userHomeDirectory, "/gindRepository/geoJSONZipFiles/");
            localZipRepository.mkdirs();
            String path = this.getGeoJSONZipFile().toString().substring(0, this.getGeoJSONZipFile().toString().lastIndexOf("/") + "/".length());
            String zipFileName = this.getGeoJSONZipFile().toString().replace(path, "");
            File geoJSONRepository = new File(localZipRepository, zipFileName);
            File installDir = new File(localZipRepository, zipFileName.replace(".zip", ""));
            if (!installDir.exists()) {
                installDir.mkdirs();
                InputStream zipF = this.getGeoJSONZipFile().openStream();
                ZipUtil.unZip((InputStream)zipF, (File)installDir);
                zipF.close();
            }
            if ((geojsons = installDir.listFiles(new FileFilter(this){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".geojson");
                }
            })).length > 0) {
                this.geoJSONUrl = geojsons[0].toURI().toURL();
            }
            assert (this.geoJSONUrl != null) : "No geojson file found in !!!";
            if (mappingFileURL == null) {
                File[] mappings = installDir.listFiles(new FileFilter(this){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && pathname.getName().endsWith("_mapping.xml");
                    }
                });
                if (mappings.length > 0) {
                    mappingFileURL = mappings[0].toURI().toURL();
                }
            } else {
                String shpFileName = this.geoJSONUrl.toString().replace(geoJSONRepository.toString(), "");
                String mappingFile = shpFileName.replace(".geojson", "_mapping.xml");
                URL newMappingFileURL = URIHelper.resolve((URI)installDir.toURI(), (String)mappingFile).toURL();
                FileUtil.copy((InputStream)mappingFileURL.openStream(), (OutputStream)new FileOutputStream(new File(newMappingFileURL.toURI())));
            }
        }
        this.mappingModel = (GJaxbMappingModel)XMLJAXBContext.getInstance().unmarshallDocument(mappingFileURL, GJaxbMappingModel.class);
        this.mappingModel.table.stream().forEach(table -> {
            Optional<GJaxbPropertiesMapping> opt = table.getPropertiesMapping().stream().filter(prop -> prop.getTarget().getPropertyName().equals("shpId")).findFirst();
            if (!opt.isPresent()) {
                throw new RuntimeException("missing shpId target property in table " + table.getName() + ".");
            }
        });
    }

    public String getName() {
        return this.mappingModel.getTable().get(0).getName();
    }

    public String getClassifier() {
        return this.mappingModel.getTable().get(0).getClassifier();
    }

    public URL getGeoJSONFile() {
        return this.geoJSONUrl;
    }

    public abstract URL getGeoJSONZipFile() throws MalformedURLException;

    public abstract URL getEmbeddedMappingFile() throws MalformedURLException;
}

