/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.osm.gis;

import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.find.gis.client.FindGisCallbackClient;
import fr.emac.gind.gis.find_gis.FaultMessage;
import fr.emac.gind.gis.find_gis.FindGis;
import fr.emac.gind.gis.find_gis.FindGisCallback;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsFromLatLng;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsFromLatLngResponse;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsInsideBBox;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsInsideBBoxResponse;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsInsidePolygon;
import fr.emac.gind.gis.find_gis.GJaxbFindConceptsInsidePolygonResponse;
import fr.emac.gind.gis.find_gis.GJaxbReceiveConceptContainedInBBox;
import fr.emac.gind.gis.find_gis.GJaxbSelectedKnowledgeSpace;
import fr.emac.gind.gis.mappingmodel.GJaxbMappingModel;
import fr.emac.gind.gis.mappingmodel.GJaxbPropertiesMapping;
import fr.emac.gind.gis.mappingmodel.GJaxbSource;
import fr.emac.gind.gis.mappingmodel.GJaxbTable;
import fr.emac.gind.gov.meta_core.client.MetaCoreGovClient;
import fr.emac.gind.gov.meta_core_gov.GJaxbAddConcept;
import fr.emac.gind.gov.meta_core_gov.GJaxbAddConnexionRule;
import fr.emac.gind.gov.meta_core_gov.MetaCoreGov;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.modeler.metamodel.GJaxbConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbConnectionRule;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaGeolocation;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaModeling;
import fr.emac.gind.modeler.metamodel.GJaxbRelationModeType;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import fr.emac.gind.osm.gis.TagHelper;
import fr.emac.gind.osm.gis.amenity.Amenity;
import fr.emac.gind.osm.gis.amenity.AmenityManager;
import jakarta.jws.WebService;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.namespace.QName;
import org.openstreetmap.osm._0.GJaxbOsm;
import org.openstreetmap.osm._0.GJaxbTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@WebService(serviceName="find_gis", portName="find_gisSOAP", targetNamespace="http://www.gind.emac.fr/gis/find_gis/", wsdlLocation="wsdl/find-gis.wsdl", endpointInterface="fr.emac.gind.gis.find_gis.FindGis")
public class OsmFindGisImpl
implements FindGis {
    private static final String OSM_ADDRESS = "https://www.openstreetmap.org";
    private static final Logger LOG = LoggerFactory.getLogger((String)OsmFindGisImpl.class.getName());
    private GJaxbMappingModel model = null;
    private MetaCoreGov metaClient = null;
    private List<QName> conceptsAlreadyAdd = new ArrayList<QName>();

    public OsmFindGisImpl(Map<String, Object> context) throws Exception {
        this.model = (GJaxbMappingModel)XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("osm_mapping.xml"), GJaxbMappingModel.class);
        if (context.get("governance") != null) {
            String governanceAddress = context.get("governance").toString().replace("/gov", "/GovMetaCore");
            this.metaClient = MetaCoreGovClient.createClient((String)governanceAddress);
        }
        AmenityManager.getInstance();
    }

    public GJaxbFindConceptsInsidePolygonResponse findConceptsInsidePolygon(GJaxbFindConceptsInsidePolygon parameters) throws FaultMessage {
        LOG.debug("Executing operation findConceptsInsidePolygon");
        try {
            GJaxbFindConceptsInsidePolygonResponse _return = null;
            return _return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public GJaxbFindConceptsFromLatLngResponse findConceptsFromLatLng(GJaxbFindConceptsFromLatLng parameters) throws FaultMessage {
        LOG.debug("Executing operation findConceptsFromLatLng");
        try {
            GJaxbFindConceptsFromLatLngResponse _return = null;
            return _return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    public GJaxbFindConceptsInsideBBoxResponse findConceptsInsideBBox(final GJaxbFindConceptsInsideBBox parameters) throws FaultMessage {
        LOG.info("Executing operation findConceptsInsideBBox");
        LOG.debug(String.valueOf(parameters));
        try {
            Client client = ClientBuilder.newClient();
            String osmURL = "https://www.openstreetmap.org/api/0.6/map?bbox=" + parameters.getLeftBottom().getPoint().getLongitude() + "," + parameters.getLeftBottom().getPoint().getLatitude() + "," + parameters.getRightTop().getPoint().getLongitude() + "," + parameters.getRightTop().getPoint().getLatitude();
            LOG.debug("osm address " + osmURL);
            WebTarget webResource = client.target(osmURL);
            Response response = webResource.request().header("Accept", (Object)"text/xml").get();
            if (response.getStatus() != 200) {
                String error = (String)response.readEntity(String.class);
                LOG.error("Error from Server .... \n");
                LOG.error(error);
                throw new FaultMessage("Failed on OSM Server (HTTP error code : " + response.getStatus() + ") : " + error, null);
            }
            String output = (String)response.readEntity(String.class);
            output = output.replace("<osm", "<osm xmlns=\"http://openstreetmap.org/osm/0.6\" ");
            Document doc = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(output.getBytes("UTF-8")));
            GJaxbOsm data = (GJaxbOsm)XMLJAXBContext.getInstance().unmarshallDocument(doc, GJaxbOsm.class);
            final FindGisCallback findclient = FindGisCallbackClient.createClient((String)parameters.getCallbackAddress());
            final GJaxbReceiveConceptContainedInBBox.Statistic stat = new GJaxbReceiveConceptContainedInBBox.Statistic();
            stat.setNumberNodesFound(0);
            stat.setNumberNodesReceived(0);
            final String queryId = UUID.randomUUID().toString();
            final boolean generateSubClass = Boolean.valueOf(GenericModelHelper.findProperty((String)"generateSubClass", (List)parameters.getProperty()).getValue());
            for (final org.openstreetmap.osm._0.GJaxbNode node : data.getNode()) {
                for (GJaxbTag tag : node.getTag()) {
                    for (final GJaxbTable table : this.model.getTable()) {
                        if (!tag.getK().equals(table.getTableName())) continue;
                        stat.setNumberNodesFound(stat.getNumberNodesFound() + 1);
                        ExecutorService service = Executors.newSingleThreadExecutor();
                        service.execute(new Runnable(){
                            final /* synthetic */ OsmFindGisImpl this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public void run() {
                                try {
                                    String collaborationName = null;
                                    String knowledgeSpaceName = null;
                                    if (parameters.getSelectedKnowledgeSpace() != null) {
                                        collaborationName = parameters.getSelectedKnowledgeSpace().getCollaborationName();
                                        knowledgeSpaceName = parameters.getSelectedKnowledgeSpace().getKnowledgeName();
                                    }
                                    GJaxbNode modelNode = this.this$0.createModelNode(node, table, generateSubClass, collaborationName, knowledgeSpaceName);
                                    GJaxbGenericModel genModel = new GJaxbGenericModel();
                                    genModel.getNode().add(modelNode);
                                    GJaxbReceiveConceptContainedInBBox respCpt = new GJaxbReceiveConceptContainedInBBox();
                                    respCpt.getProperty().addAll(parameters.getProperty());
                                    respCpt.setGenericModel(genModel);
                                    respCpt.setStatistic(stat);
                                    respCpt.setQueryId(queryId);
                                    respCpt.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                                    respCpt.setSelectedKnowledgeSpace(parameters.getSelectedKnowledgeSpace());
                                    findclient.receiveConceptContainedInBBox(respCpt);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    LOG.error(e.getMessage(), (Throwable)e);
                                }
                            }
                        });
                    }
                }
            }
            GJaxbFindConceptsInsideBBoxResponse _return = new GJaxbFindConceptsInsideBBoxResponse();
            return _return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new FaultMessage(ex.getMessage(), null, (Throwable)ex);
        }
    }

    private GJaxbNode createModelNode(org.openstreetmap.osm._0.GJaxbNode node, GJaxbTable table, boolean generateSubClass, String collaborationName, String knowledgeSpaceName) throws Exception {
        System.out.println("node: \n" + XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)node)));
        GJaxbNode newInstanceNode = new GJaxbNode();
        newInstanceNode.setId("node_osm_" + UUID.randomUUID().toString());
        newInstanceNode.setType(table.getConceptName());
        newInstanceNode.getStatus().add(GJaxbStatusType.ACTIVE);
        GJaxbEffectiveConceptType metaNode = EffectiveMetaModelPluginManager.getInstance().getConceptByType(table.getConceptName());
        if (metaNode == null) {
            throw new Exception("Impossible to find : " + String.valueOf(table.getConceptName()));
        }
        String image = metaNode.getNodeMetaGeolocation().getPoint().getImage();
        for (GJaxbPropertiesMapping propMapping : table.getPropertiesMapping()) {
            String value;
            if (propMapping.getSource().size() > 1) {
                throw new Exception("Several columnNames found!!! Not supported for now!!!");
            }
            if (((GJaxbSource)propMapping.getSource().get(0)).getColumnName() != null) {
                value = TagHelper.findTagName(((GJaxbSource)propMapping.getSource().get(0)).getColumnName(), node.getTag());
                Amenity amenity = null;
                if (((GJaxbSource)propMapping.getSource().get(0)).getColumnName().equals("amenity")) {
                    amenity = AmenityManager.getInstance().getAmenities().get(value.toString());
                    image = amenity.getSvgIconUrl();
                }
                if (propMapping.getTarget().getPropertyName().equals("type")) {
                    GJaxbProperty typeProp;
                    if (generateSubClass) {
                        QName newConceptType = new QName(metaNode.getType().getNamespaceURI(), RegExpHelper.toRegexFriendlyName((String)value.toString()));
                        newInstanceNode.setType(newConceptType);
                        if (!this.conceptsAlreadyAdd.contains(newConceptType) && this.metaClient != null) {
                            GJaxbAddConcept req = new GJaxbAddConcept();
                            req.setSelectedKnowledgeSpace(new fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace());
                            req.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                            req.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
                            GJaxbEffectiveConceptType newConcept = new GJaxbEffectiveConceptType();
                            newConcept.setAbstract(Boolean.valueOf(false));
                            newConcept.setType(newConceptType);
                            newConcept.setReadonly(Boolean.valueOf(false));
                            newConcept.getExtends().add(metaNode.getType());
                            newConcept.setEvents((GJaxbConceptType.Events)GenericModelHelper.clone((AbstractJaxbObject)metaNode.getEvents(), GJaxbConceptType.Events.class));
                            newConcept.setNodeMetaModeling((GJaxbNodeMetaModeling)GenericModelHelper.clone((AbstractJaxbObject)metaNode.getNodeMetaModeling(), GJaxbNodeMetaModeling.class));
                            newConcept.setNodeMetaGeolocation((GJaxbNodeMetaGeolocation)GenericModelHelper.clone((AbstractJaxbObject)metaNode.getNodeMetaGeolocation(), GJaxbNodeMetaGeolocation.class));
                            if (amenity != null) {
                                newConcept.getNodeMetaModeling().getModelingViewDefinition().getView().setUrl(image);
                                if (metaNode.getNodeMetaGeolocation().isSetPoint()) {
                                    newConcept.getNodeMetaGeolocation().setPoint(new GJaxbNodeMetaGeolocation.Point());
                                    newConcept.getNodeMetaGeolocation().getPoint().setImage(image);
                                } else {
                                    throw new RuntimeException("Not implemented !!!");
                                }
                            }
                            req.setEffectiveConcept(newConcept);
                            this.metaClient.addConcept(req);
                            this.conceptsAlreadyAdd.add(newConceptType);
                            GJaxbAddConnexionRule addConRule = new GJaxbAddConnexionRule();
                            addConRule.setConnectionRule(new GJaxbConnectionRule());
                            addConRule.getConnectionRule().setRelationType(GenericModelHelper.uml((String)"Inherit"));
                            addConRule.getConnectionRule().setMode(GJaxbRelationModeType.INHERITANCE);
                            addConRule.getConnectionRule().setFrom(newConcept.getType());
                            addConRule.getConnectionRule().setTo(metaNode.getType());
                            addConRule.setSelectedKnowledgeSpace(new fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace());
                            addConRule.getSelectedKnowledgeSpace().setCollaborationName(collaborationName);
                            addConRule.getSelectedKnowledgeSpace().setKnowledgeName(knowledgeSpaceName);
                            this.metaClient.addConnexionRule(addConRule);
                        }
                    }
                    if ((typeProp = GenericModelHelper.findProperty((String)"type", (List)newInstanceNode.getProperty(), (boolean)true)).getValue() == null) {
                        typeProp.setValue(value != null ? value.toString() : null);
                    } else {
                        typeProp.setValue(typeProp.getValue() + " " + (value != null ? value.toString() : ""));
                    }
                    if (amenity == null) continue;
                    GJaxbProperty pictureProp = GenericModelHelper.findProperty((String)"picture", (List)newInstanceNode.getProperty(), (boolean)true);
                    pictureProp.setValue(image);
                    continue;
                }
                GJaxbProperty prop = GenericModelHelper.findProperty((String)propMapping.getTarget().getPropertyName(), (List)newInstanceNode.getProperty(), (boolean)true);
                if (prop.getValue() == null) {
                    prop.setValue(value != null ? value.toString() : null);
                    continue;
                }
                prop.setValue(prop.getValue() + " " + (value != null ? value.toString() : ""));
                continue;
            }
            if (((GJaxbSource)propMapping.getSource().get(0)).getConstant() == null) continue;
            value = ((GJaxbSource)propMapping.getSource().get(0)).getConstant();
            GJaxbProperty prop = GenericModelHelper.findProperty((String)propMapping.getTarget().getPropertyName(), (List)newInstanceNode.getProperty(), (boolean)true);
            if (prop.getValue() == null) {
                prop.setValue(value != null ? value.toString() : null);
                continue;
            }
            prop.setValue(prop.getValue() + " " + (value != null ? value.toString() : ""));
        }
        GenericModelHelper.findProperty((String)"osmId", (List)newInstanceNode.getProperty(), (boolean)true).setValue(node.getId().toString());
        GenericModelHelper.findProperty((String)"description", (List)newInstanceNode.getProperty(), (boolean)true).setValue(JSONJAXBContext.getInstance().marshallAnyElement((Object)node));
        newInstanceNode.setGeolocation(new GJaxbNode.Geolocation());
        newInstanceNode.getGeolocation().getItemView().add(new GJaxbNode.Geolocation.ItemView());
        ((GJaxbNode.Geolocation.ItemView)newInstanceNode.getGeolocation().getItemView().get(0)).setPoint(new GJaxbPointType());
        ((GJaxbNode.Geolocation.ItemView)newInstanceNode.getGeolocation().getItemView().get(0)).getPoint().setLatitude(Double.valueOf(node.getLat()));
        ((GJaxbNode.Geolocation.ItemView)newInstanceNode.getGeolocation().getItemView().get(0)).getPoint().setLongitude(Double.valueOf(node.getLon()));
        return newInstanceNode;
    }
}

