/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.osm.gis;

import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.io.zip.ZipUtil;
import jakarta.activation.DataHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class RepositoryManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)RepositoryManager.class.getName());
    private String repositoryPath = null;

    public void initialize(String repositoryPath) throws IOException, FileNotFoundException, SAXException, ParserConfigurationException {
        this.repositoryPath = repositoryPath;
        if (this.repositoryPath == null) {
            this.repositoryPath = new File("../repoository").toString();
            LOG.info("Repository not defined in property so creation of repository at: " + this.repositoryPath);
        }
        new File(repositoryPath).mkdirs();
    }

    public File getRepository() throws Exception {
        if (this.repositoryPath == null) {
            return null;
        }
        return new File(this.repositoryPath);
    }

    public RepositoryResult getResource(List<String> extensions, String zipName) throws Exception {
        File mainDirectory = new File(this.repositoryPath, zipName.toString().replace(".zip", ""));
        if (mainDirectory.exists()) {
            return new RepositoryResult(this, mainDirectory);
        }
        return null;
    }

    public RepositoryResult addResource(String name, DataHandler dh) throws Exception {
        if (this.repositoryPath == null) {
            throw new Exception("Repository cannot be null!!! you must set this property in config file");
        }
        new File(this.repositoryPath).mkdirs();
        File zipFile = new File(this.repositoryPath, name);
        if (!zipFile.exists()) {
            zipFile.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(zipFile);
        dh.writeTo((OutputStream)out);
        ((OutputStream)out).close();
        LOG.info("Add new resource: " + name);
        File mainDirectory = ZipUtil.unZip((ZipFile)new ZipFile(zipFile), (File)new File(this.repositoryPath));
        zipFile.delete();
        return new RepositoryResult(this, mainDirectory);
    }

    public void deleteResource(String mainDirectory) throws Exception {
        File dir;
        if (this.repositoryPath != null && (dir = new File(this.repositoryPath, mainDirectory)).exists()) {
            FileUtil.deleteDirectory((File)dir);
        }
    }

    public void clear() throws Exception {
        if (this.repositoryPath != null) {
            FileUtil.deleteDirectory((File)new File(this.repositoryPath));
            new File(this.repositoryPath).mkdirs();
        }
    }

    public class RepositoryResult {
        File mainDirectory;

        public RepositoryResult(RepositoryManager this$0, File mainDirectory) {
            this.mainDirectory = mainDirectory;
        }

        public File getMainDirectory() {
            return this.mainDirectory;
        }
    }
}

