/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.osm.gis.amenity;

import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.osm.gis.amenity.AmenityManager;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Amenity {
    private static final Logger LOG = LoggerFactory.getLogger((String)Amenity.class.getName());
    private String name;
    private String description;
    private String svgIconPage;
    private String svgIconUrl;
    private String imageUrl;

    public Amenity(String name, String description, String svgIconPage, String imageUrl) {
        this.name = name;
        this.description = description;
        this.svgIconPage = svgIconPage;
        this.imageUrl = imageUrl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getSvgIconUrl() throws Exception {
        if (this.svgIconUrl == null && this.svgIconPage != null) {
            String osmWikiSvgUrl = this.getAmenitySvgUrlOnHtmlPage(this.svgIconPage);
            try {
                if (osmWikiSvgUrl != null) {
                    URL svgUrl = URI.create(osmWikiSvgUrl).toURL();
                    InputStream is = svgUrl.openConnection().getInputStream();
                    String fileName = osmWikiSvgUrl.substring(osmWikiSvgUrl.lastIndexOf("/") + "/".length());
                    File rootDirectory = new File(RIOConstant.RESOURCES_FOLDER);
                    rootDirectory = new File(rootDirectory, "share");
                    rootDirectory = new File(rootDirectory, "external_resources");
                    Object url = "/r-ioplay" + RIOConstant.WEBJARS_RESOURCES_FOLDER + "/share/external_resources/" + fileName;
                    url = ((String)url).replace("//", "/");
                    rootDirectory.getCanonicalFile().mkdirs();
                    File rsc = new File(rootDirectory.getCanonicalFile(), fileName);
                    rsc.createNewFile();
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)rsc);
                    this.svgIconUrl = url;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.warn("Impossible to download: " + osmWikiSvgUrl);
            }
        }
        return this.svgIconUrl;
    }

    private String getAmenitySvgUrlOnHtmlPage(String amenitySvgHtmlPage) throws RuntimeException {
        Object amenitySvgUrl = null;
        if (amenitySvgHtmlPage != null) {
            try {
                StringBuffer svgUrl = new StringBuffer();
                Document doc = Jsoup.connect((String)amenitySvgHtmlPage).get();
                Element table = doc.select("table.wikitable").first();
                table.select("tr").forEach(tr -> {
                    Elements as = tr.select("td").select("a");
                    if (!as.isEmpty()) {
                        as.forEach(a -> {
                            if (svgUrl.isEmpty() && a.attr("href").endsWith(".svg")) {
                                svgUrl.append(a.attr("href"));
                            }
                        });
                    }
                });
                if (!svgUrl.isEmpty() && !((String)(amenitySvgUrl = svgUrl.toString())).startsWith("http://")) {
                    amenitySvgUrl = AmenityManager.htmlWikiAddress + (String)amenitySvgUrl;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return amenitySvgUrl;
    }
}

