/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.humantask.client;

import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.humantask.FaultMessage;
import fr.emac.gind.humantask.GJaxbAddTaskASync;
import fr.emac.gind.humantask.GJaxbAddTaskASyncResponse;
import fr.emac.gind.humantask.GJaxbAddTaskSync;
import fr.emac.gind.humantask.GJaxbAddTaskSyncResponse;
import fr.emac.gind.humantask.GJaxbFindTask;
import fr.emac.gind.humantask.GJaxbFindTaskResponse;
import fr.emac.gind.humantask.GJaxbFindTasksByProcessInstanceId;
import fr.emac.gind.humantask.GJaxbFindTasksByProcessInstanceIdResponse;
import fr.emac.gind.humantask.GJaxbGetTask;
import fr.emac.gind.humantask.GJaxbGetTaskResponse;
import fr.emac.gind.humantask.GJaxbGetTodoList;
import fr.emac.gind.humantask.GJaxbGetTodoListResponse;
import fr.emac.gind.humantask.GJaxbRemoveTask;
import fr.emac.gind.humantask.GJaxbRemoveTaskResponse;
import fr.emac.gind.humantask.GJaxbSubscribeTasksByAssignedToResource;
import fr.emac.gind.humantask.GJaxbSubscribeTasksByAssignedToResourceResponse;
import fr.emac.gind.humantask.GJaxbUnSubscribeTasksByAssignedToResource;
import fr.emac.gind.humantask.GJaxbUnSubscribeTasksByAssignedToResourceResponse;
import fr.emac.gind.humantask.GJaxbUpdateTask;
import fr.emac.gind.humantask.GJaxbUpdateTaskResponse;
import fr.emac.gind.humantask.Humantask;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHandler;
import fr.emac.gind.transport.protocols.soap.handler.SOAPSender;
import fr.emac.gind.transport.protocols.soap.handler.interceptor.SOAPInterceptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HumanTaskClient
implements Humantask {
    private SOAPSender sender = null;
    private String serverAddress = null;

    private HumanTaskClient(String serverAddress) throws Exception {
        assert (serverAddress != null);
        this.serverAddress = serverAddress;
        this.sender = new SOAPSender(new SOAPInterceptor[0]);
    }

    public static Humantask createClient(String remoteAddress) throws Exception {
        Humantask client = (Humantask)LocalRegistry.getInstance().findWSImplementation(Humantask.class);
        if (client == null) {
            client = new HumanTaskClient(remoteAddress);
        }
        return client;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public GJaxbAddTaskASyncResponse addTaskASync(GJaxbAddTaskASync parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/humantask/addTaskASync\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbAddTaskASyncResponse response = (GJaxbAddTaskASyncResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbAddTaskASyncResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbGetTaskResponse getTask(GJaxbGetTask parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/humantask/getTask\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbGetTaskResponse response = (GJaxbGetTaskResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbGetTaskResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbGetTodoListResponse getTodoList(GJaxbGetTodoList parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/humantask/getTodoList\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbGetTodoListResponse response = (GJaxbGetTodoListResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbGetTodoListResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbRemoveTaskResponse removeTask(GJaxbRemoveTask parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/humantask/removeTask\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbRemoveTaskResponse response = (GJaxbRemoveTaskResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbRemoveTaskResponse.class);
            return response;
        }
        catch (Exception e) {
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbAddTaskSyncResponse addTaskSync(GJaxbAddTaskSync parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/humantask/addTaskSync\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbAddTaskSyncResponse response = (GJaxbAddTaskSyncResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbAddTaskSyncResponse.class);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbUpdateTaskResponse updateTask(GJaxbUpdateTask parameters) throws FaultMessage {
        try {
            assert (parameters.getDeployedTaskId() != null);
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/humantask/updateTask\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbUpdateTaskResponse response = (GJaxbUpdateTaskResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbUpdateTaskResponse.class);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbFindTaskResponse findTask(GJaxbFindTask parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/humantask/findTask\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbFindTaskResponse response = (GJaxbFindTaskResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbFindTaskResponse.class);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbSubscribeTasksByAssignedToResourceResponse subscribeTasksByAssignedToResource(GJaxbSubscribeTasksByAssignedToResource parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/humantask/subscribeTasksByAssignedToResource\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbSubscribeTasksByAssignedToResourceResponse response = (GJaxbSubscribeTasksByAssignedToResourceResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbSubscribeTasksByAssignedToResourceResponse.class);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbUnSubscribeTasksByAssignedToResourceResponse unSubscribeTasksByAssignedToResource(GJaxbUnSubscribeTasksByAssignedToResource parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/humantask/unSubscribeTasksByAssignedToResource\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbUnSubscribeTasksByAssignedToResourceResponse response = (GJaxbUnSubscribeTasksByAssignedToResourceResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbUnSubscribeTasksByAssignedToResourceResponse.class);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }

    @Override
    public GJaxbFindTasksByProcessInstanceIdResponse findTasksByProcessInstanceId(GJaxbFindTasksByProcessInstanceId parameters) throws FaultMessage {
        try {
            Document requestDOM = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)parameters);
            Document responseDOM = this.sender.sendSoapRequest(requestDOM, this.serverAddress, "\"http://www.gind.emac.fr/humantask/findTasksByProcessInstanceId\"");
            if (SOAPHandler.isSoapFault((Document)responseDOM)) {
                throw new Exception("Ws Error:\n" + XMLPrettyPrinter.print((Node)responseDOM));
            }
            GJaxbFindTasksByProcessInstanceIdResponse response = (GJaxbFindTasksByProcessInstanceIdResponse)XMLJAXBContext.getInstance().unmarshallDocument(SOAPHandler.extractPayload((Document)responseDOM), GJaxbFindTasksByProcessInstanceIdResponse.class);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FaultMessage(e.getMessage(), null, e);
        }
    }
}

