/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.humantask;

import fr.emac.gind.commons.utils.lang.UncheckedException;
import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.commons.utils.ws.StaticJettyServer;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.event.producer.ResourcesManager;
import fr.emac.gind.humantask.service.HumantaskCallBackSOAPImpl;
import fr.emac.gind.humantask.service.HumantaskNotifier;
import fr.emac.gind.humantask.service.HumantaskSOAPImpl;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import gind.org.oasis_open.docs.wsn.t_1.GJaxbTopicSetType;
import jakarta.xml.ws.Endpoint;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumantaskWebService
extends SPIWebServicePrimitives {
    private static final Logger LOG = LoggerFactory.getLogger((String)HumantaskWebService.class.getName());
    private String storageAddress = null;
    private HumantaskSOAPImpl ht = null;
    private HumantaskCallBackSOAPImpl htcallback = null;
    private Endpoint notifierClientServer = null;
    private NotificationManagerImpl producer = null;

    public void onInit(Map<String, Object> context) {
        try {
            this.storageAddress = (String)context.get("storage");
            String clientAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)context.get("host").toString(), (int)Integer.parseInt(context.get("notification-port").toString()), (int)this.proxyPort, (String)"/HumanTaskNotifier");
            HumantaskNotifier notifierClient = new HumantaskNotifier(clientAddress);
            String clientAddress2 = "http://0.0.0.0:" + context.get("notification-port").toString() + "/HumanTaskNotifier";
            this.notifierClientServer = StaticJettyServer.getInstance().publishJAXWSEndpoint(clientAddress2, (Object)notifierClient);
            String serviceName = "HumanTask";
            this.producer = new NotificationManagerImpl(HumantaskWebService.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)this.getHost(), (int)this.getPort(), (int)this.proxyPort, (String)(serviceName + "Subscriber")), this.storageAddress, serviceName + "Subscriber_" + RegExpHelper.toRegexFriendlyName((String)this.getHost().replace(".", "_").toString()), new HashMap(), (GJaxbTopicSetType)XMLJAXBContext.getInstance().unmarshallDocument(Thread.currentThread().getContextClassLoader().getResource("wsdl/humanNS.xml"), GJaxbTopicSetType.class), null, new ResourcesManager[0]);
            this.registerWSImplementation(serviceName + "Subscriber", this.producer);
            this.ht = new HumantaskSOAPImpl(context, notifierClient, this.producer);
            this.htcallback = new HumantaskCallBackSOAPImpl(context);
            this.registerWSImplementation(serviceName, this.ht);
            this.registerWSImplementation(serviceName + "CallBack", this.htcallback);
        }
        catch (Exception e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    public void start() throws Exception {
        super.start();
    }

    public void stop() throws Exception {
        super.stop();
        StaticJettyServer.getInstance().unPublishJAXWSEndpoint(this.notifierClientServer);
        this.notifierClientServer.stop();
    }
}

