/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.io.interpretation.engine;

import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLCompactPrinter;
import fr.emac.gind.commons.utils.xml.XMLGregorianCalendarHelper;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.event.consumer.AbstractNotifierClient;
import fr.emac.gind.event.consumer.Consumer;
import fr.emac.gind.event.helper.WSNHelper;
import fr.emac.gind.event.producer.Notifier;
import fr.emac.gind.eventtype.GJaxbAddEdgeEvent;
import fr.emac.gind.eventtype.GJaxbAddNodeEvent;
import fr.emac.gind.eventtype.GJaxbPublishModelEvent;
import fr.emac.gind.eventtype.GJaxbReflexEvent;
import fr.emac.gind.eventtype.GJaxbRemoveEdgeEvent;
import fr.emac.gind.eventtype.GJaxbRemoveNodeEvent;
import fr.emac.gind.eventtype.GJaxbUnpublishModelEvent;
import fr.emac.gind.eventtype.GJaxbUpdateEdgeEvent;
import fr.emac.gind.eventtype.GJaxbUpdateNodeEvent;
import fr.emac.gind.io.interpretation.engine.HighLevelInterpretationEngine;
import fr.emac.gind.io.interpretation.engine.interpretor.InterpretationManager;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.storage.GJaxbPut;
import fr.emac.gind.storage.GJaxbPutResponse;
import fr.emac.gind.storage.GJaxbUpdate;
import fr.emac.gind.storage.Storage;
import fr.emac.gind.storage.client.StorageClient;
import gind.org.oasis_open.docs.wsn.b_2.GJaxbNotify;
import gind.org.w3._2005._08.addressing.GJaxbAttributedURIType;
import gind.org.w3._2005._08.addressing.GJaxbEndpointReferenceType;
import jakarta.jws.WebService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.namespace.QName;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@WebService(serviceName="NotifierClientService", portName="NotifierClientEndpoint", targetNamespace="http://www.gind.emac.fr/notifier", wsdlLocation="wsdl/notifier.wsdl", endpointInterface="fr.emac.gind.notifier.NotifierClient")
public class HighLevelInterpretationNotifier
extends AbstractNotifierClient {
    private static Logger LOG = LoggerFactory.getLogger((String)HighLevelInterpretationNotifier.class.getName());
    private InterpretationManager interpretationManager = null;
    private HighLevelInterpretationEngine producer = null;
    private Map<String, Object> context = null;
    private GJaxbEndpointReferenceType eprBroker = null;
    private Boolean historize = false;
    private Storage storageClient = null;

    public HighLevelInterpretationNotifier(String address, String governanceAddress, HighLevelInterpretationEngine producer, Map<String, Object> context) throws Exception {
        super(address);
        this.context = context;
        this.interpretationManager = new InterpretationManager(this, governanceAddress, context);
        this.producer = producer;
        this.producer.getNotifier().setName("highLevelIE");
        this.eprBroker = new GJaxbEndpointReferenceType();
        this.eprBroker.setAddress(new GJaxbAttributedURIType());
        if (context.get("storage") != null) {
            this.storageClient = StorageClient.createClient((String)context.get("storage").toString());
        }
        if (context.get("historize") != null) {
            this.historize = Boolean.parseBoolean(context.get("historize").toString());
        }
        String eventBrokerAddress = ((String)context.get("event-broker")).replace("/BrokerSubscriber", "/BrokerNotifier");
        URI eventBrokerURI = URI.create(eventBrokerAddress);
        LOG.debug("--- EVENT BROKER: host = " + ((String)context.get("host")).trim());
        LOG.debug("--- EVENT BROKER: eventBrokerURI.getHost() = " + eventBrokerURI.getHost().trim());
        LOG.debug("--- EVENT BROKER: test = " + eventBrokerURI.getHost().trim().equals(((String)context.get("host")).trim()));
        if (context.get("host") != null && context.get("proxy-port") != null && eventBrokerURI.getHost().trim().equals(((String)context.get("host")).trim())) {
            String localBrokerAddress;
            eventBrokerAddress = localBrokerAddress = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)context.get("host").toString(), (int)eventBrokerURI.getPort(), (int)Integer.parseInt(context.get("proxy-port").toString()), (String)eventBrokerURI.getPath());
            LOG.debug("--- EVENT BROKER: use local adress:  " + eventBrokerAddress);
        } else {
            LOG.debug("--- EVENT BROKER: use remote adress:  " + eventBrokerAddress);
        }
        this.eprBroker.getAddress().setValue(eventBrokerAddress);
    }

    public synchronized void notify(GJaxbNotify notify) {
        Document msg = null;
        try {
            msg = WSNHelper.getInstance().getFirstMessageInNotification(notify);
            LOG.debug("message receive: " + XMLPrettyPrinter.print((Node)msg));
            ArrayList<QName> topics = new ArrayList<QName>();
            topics.add(new QName("http://www.gind.emac.fr/EventType", "allInterpretationEngineTopic"));
            AbstractJaxbObject payload = null;
            GJaxbNode node = null;
            if (msg.getDocumentElement().getLocalName().equals("addNodeEvent")) {
                payload = XMLJAXBContext.getInstance().unmarshallDocument(msg, GJaxbAddNodeEvent.class);
                node = ((GJaxbAddNodeEvent)payload).getNode();
                topics.add(new QName("http://www.gind.emac.fr/EventType", "addNodeTopic"));
            } else if (msg.getDocumentElement().getLocalName().equals("updateNodeEvent")) {
                payload = XMLJAXBContext.getInstance().unmarshallDocument(msg, GJaxbUpdateNodeEvent.class);
                node = ((GJaxbUpdateNodeEvent)payload).getNode();
                topics.add(new QName("http://www.gind.emac.fr/EventType", "updateNodeTopic"));
            } else if (msg.getDocumentElement().getLocalName().equals("removeNodeEvent")) {
                payload = XMLJAXBContext.getInstance().unmarshallDocument(msg, GJaxbRemoveNodeEvent.class);
                node = ((GJaxbRemoveNodeEvent)payload).getNode();
                topics.add(new QName("http://www.gind.emac.fr/EventType", "removeNodeTopic"));
            }
            if (msg.getDocumentElement().getLocalName().equals("addEdgeEvent")) {
                payload = XMLJAXBContext.getInstance().unmarshallDocument(msg, GJaxbAddEdgeEvent.class);
                topics.add(new QName("http://www.gind.emac.fr/EventType", "addEdgeTopic"));
            } else if (msg.getDocumentElement().getLocalName().equals("updateEdgeEvent")) {
                payload = XMLJAXBContext.getInstance().unmarshallDocument(msg, GJaxbUpdateEdgeEvent.class);
                topics.add(new QName("http://www.gind.emac.fr/EventType", "updateEdgeTopic"));
            } else if (msg.getDocumentElement().getLocalName().equals("removeEdgeEvent")) {
                payload = XMLJAXBContext.getInstance().unmarshallDocument(msg, GJaxbRemoveEdgeEvent.class);
                topics.add(new QName("http://www.gind.emac.fr/EventType", "removeEdgeTopic"));
            }
            if (msg.getDocumentElement().getLocalName().equals("publishModelEvent")) {
                payload = XMLJAXBContext.getInstance().unmarshallDocument(msg, GJaxbPublishModelEvent.class);
                topics.add(new QName("http://www.gind.emac.fr/EventType", "publishModelTopic"));
            } else if (msg.getDocumentElement().getLocalName().equals("unpublishModelEvent")) {
                payload = XMLJAXBContext.getInstance().unmarshallDocument(msg, GJaxbUnpublishModelEvent.class);
                topics.add(new QName("http://www.gind.emac.fr/EventType", "unpublishModelTopic"));
            }
            if (payload != null) {
                HashMap<QName, String> context = new HashMap<QName, String>();
                for (Object obj : notify.getAny()) {
                    Element elmt = (Element)obj;
                    if (!elmt.getLocalName().equals("context") || !elmt.getNamespaceURI().equals("http://www.gind.emac.fr")) continue;
                    List childs = DOMUtil.getInstance().getElements(elmt);
                    childs.forEach(e -> {
                        QName qname = new QName(e.getNamespaceURI(), e.getLocalName());
                        String value = e.getTextContent();
                        context.put(qname, value);
                    });
                }
                this.interpretationManager.interpret(payload, context);
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            LOG.error("Impossible to handle: " + XMLCompactPrinter.print((Node)msg), e2);
        }
    }

    public void notifyReflexEvent(final GJaxbReflexEvent event) {
        ExecutorService runner = Executors.newSingleThreadExecutor();
        runner.execute(new Runnable(){
            final /* synthetic */ HighLevelInterpretationNotifier this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Notifier notifier = this.this$0.producer.getNotifier();
                    synchronized (notifier) {
                        LOG.debug("notif send: \n" + XMLPrettyPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)event)));
                        QName topic = new QName("http://www.gind.emac.fr/EventType", "reflexTopic");
                        LOG.debug("Sending on topic " + String.valueOf(topic) + "producer " + this.this$0.producer.getNotifier().getName());
                        ArrayList<Consumer> eprs = new ArrayList<Consumer>(this.this$0.producer.getNotifier().findClientsForTopic(topic, (Object)event, Boolean.valueOf(false)));
                        eprs.add(new Consumer(this.this$0.eprBroker));
                        this.this$0.producer.getNotifier().sendNotificationOnTopic((Object)event, topic, eprs, null, Boolean.valueOf(false));
                        this.this$0.historize(event, event.getCollaborationName(), event.getKnowledgeSpaceName());
                    }
                }
                catch (Exception e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private void historize(GJaxbReflexEvent event, String collaborationName, String knowledgeSpaceName) throws Exception {
        if (this.historize.booleanValue()) {
            JSONObject json = new JSONObject();
            json.put("date", (Object)XMLGregorianCalendarHelper.getInstance().getNewCalendar());
            ArrayList<String> statuss = new ArrayList<String>();
            statuss.add(GJaxbStatusType.ACTIVE.toString());
            json.put("status", statuss);
            json.put("content", (Object)new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)event)));
            json.put("collaborationName", (Object)RegExpHelper.toRegexFriendlyName((String)collaborationName));
            json.put("knowledgeSpaceName", (Object)RegExpHelper.toRegexFriendlyName((String)knowledgeSpaceName));
            GJaxbPut request = new GJaxbPut();
            String document = "<gind:json xmlns:gind=\"http://www.gind.emac.fr/json\"><![CDATA[" + String.valueOf(json) + "]]></gind:json>";
            request.setAny((Object)DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(document.getBytes())).getDocumentElement());
            request.setCollection("KnowledgeHistory");
            GJaxbPutResponse resp = this.storageClient.put(request);
            event.setMongoId(resp.getId());
            json.put("content", (Object)new JSONObject(JSONJAXBContext.getInstance().marshallAnyElement((Object)event)));
            document = "<gind:json xmlns:gind=\"http://www.gind.emac.fr/json\"><![CDATA[" + String.valueOf(json) + "]]></gind:json>";
            GJaxbUpdate updateReq = new GJaxbUpdate();
            updateReq.setId(event.getMongoId());
            updateReq.setAny((Object)DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(document.getBytes())).getDocumentElement());
            updateReq.setCollection("KnowledgeHistory");
            this.storageClient.update(updateReq);
        }
    }
}

