/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.io.interpretation.engine;

import fr.emac.gind.commons.utils.xml.XMLCompactPrinter;
import fr.emac.gind.event.cep.manager.CepRulesManagerCommand;
import fr.emac.gind.event.interpretation.config.InterpretationConfigDeployHelper;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.interpretationconfigs.DeployFault;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.model.interpretation.config.GJaxbDeploy;
import fr.emac.gind.model.interpretation.config.GJaxbDeployResponse;
import fr.emac.gind.model.interpretation.config.GJaxbEventAction;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfig;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfigs;
import gind.org.oasis_open.docs.wsn.t_1.GJaxbTopicSetType;
import gind.org.oasis_open.docs.wsn.t_1.ObjectFactory;
import java.io.File;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LowLevelInterpretationCEPEngineCommand
extends CepRulesManagerCommand {
    private GJaxbTopicSetType topicset = null;
    private ObjectFactory factory = new ObjectFactory();
    private String highLevelInterpretationEngineAddress = null;

    public LowLevelInterpretationCEPEngineCommand(String producerAddress, GJaxbTopicSetType topicset, String highLevelInterpretationEngineAddress, NotificationManagerImpl subscriber, Map<String, Object> context) throws Exception {
        super(producerAddress, subscriber, context);
        this.topicset = topicset;
        this.highLevelInterpretationEngineAddress = highLevelInterpretationEngineAddress;
    }

    public GJaxbDeployResponse deploy(GJaxbDeploy request) throws DeployFault {
        GJaxbInterpretationConfigs configs = new GJaxbInterpretationConfigs();
        try {
            configs = InterpretationConfigDeployHelper.extractInterpretationConfig((GJaxbDeploy)request);
            for (GJaxbInterpretationConfig grule : configs.getInterpretationConfig()) {
                for (GJaxbEventAction action : grule.getEventAction()) {
                    boolean findTopic = false;
                    QName topic = action.getTopic();
                    for (Object obj : this.topicset.getAny()) {
                        Element elmt = (Element)obj;
                        if (!topic.equals(new QName(elmt.getNamespaceURI(), elmt.getLocalName()))) continue;
                        findTopic = true;
                        break;
                    }
                    if (!findTopic) {
                        try {
                            throw new DeployFault("the event action of rule must provide an output event using a topic included in this topicSet: " + XMLCompactPrinter.print((Node)XMLJAXBContext.getInstance().marshallAnyElement(this.factory.createTopicSet(this.topicset))), null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    boolean findPublisher = false;
                    for (String publisher : action.getPublishDestination()) {
                        if (!publisher.equals(this.highLevelInterpretationEngineAddress)) continue;
                        findPublisher = true;
                    }
                    if (findPublisher) continue;
                    action.getPublishDestination().add(this.highLevelInterpretationEngineAddress);
                }
            }
            return super.deploy(InterpretationConfigDeployHelper.buildRequest((GJaxbInterpretationConfigs)configs, (String)request.getCollaborationName(), (String)request.getKnowledgeSpaceName(), (File[])new File[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeployFault(e.getMessage(), null, (Throwable)e);
        }
    }
}

