/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.io.interpretation.engine;

import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.event.interpretation.config.InterpretationConfigDeployHelper;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.interpretationconfigs.DeployFault;
import fr.emac.gind.interpretationconfigs.GetInterpretationConfigFault;
import fr.emac.gind.interpretationconfigs.GetInterpretationConfigsFault;
import fr.emac.gind.interpretationconfigs.InterpretationCommand;
import fr.emac.gind.interpretationconfigs.PredictCommand;
import fr.emac.gind.interpretationconfigs.PredictFault;
import fr.emac.gind.interpretationconfigs.UndeployFault;
import fr.emac.gind.interpretationconfigs.UpdateInterpretationConfigFault;
import fr.emac.gind.io.interpretation.engine.LowLevelInterpretationCEPEngineCommand;
import fr.emac.gind.io.interpretation.engine.LowLevelInterpretationMLEngineCommand;
import fr.emac.gind.model.interpretation.config.GJaxbDeploy;
import fr.emac.gind.model.interpretation.config.GJaxbDeployResponse;
import fr.emac.gind.model.interpretation.config.GJaxbDeployResult;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfig;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfigResponse;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfigs;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfigsResponse;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfig;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfigs;
import fr.emac.gind.model.interpretation.config.GJaxbPredict;
import fr.emac.gind.model.interpretation.config.GJaxbPredictResponse;
import fr.emac.gind.model.interpretation.config.GJaxbUndeploy;
import fr.emac.gind.model.interpretation.config.GJaxbUndeployResponse;
import fr.emac.gind.model.interpretation.config.GJaxbUpdateInterpretationConfig;
import fr.emac.gind.model.interpretation.config.GJaxbUpdateInterpretationConfigResponse;
import gind.org.oasis_open.docs.wsn.t_1.GJaxbTopicSetType;
import gind.org.oasis_open.docs.wsn.t_1.ObjectFactory;
import jakarta.jws.WebService;
import jakarta.xml.ws.BindingType;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="InterpretationConfigsCommandSOAP", serviceName="InterpretationConfigsCommandService", targetNamespace="http://www.gind.emac.fr/InterpretationConfigs", wsdlLocation="wsdl/InterpretationApi.wsdl", endpointInterface="fr.emac.gind.interpretationconfigs.InterpretationCommand")
@BindingType(value="http://schemas.xmlsoap.org/wsdl/soap/http")
public class LowLevelInterpretationDispatcherEngineCommand
implements InterpretationCommand,
PredictCommand {
    private static final Logger LOG = LoggerFactory.getLogger((String)LowLevelInterpretationDispatcherEngineCommand.class.getName());
    private GJaxbTopicSetType topicset = null;
    private ObjectFactory factory = new ObjectFactory();
    private String highLevelInterpretationEngineAddress = null;
    private LowLevelInterpretationCEPEngineCommand cepEngine = null;
    private LowLevelInterpretationMLEngineCommand mlEngine = null;

    public LowLevelInterpretationDispatcherEngineCommand(String producerAddress, GJaxbTopicSetType topicset, String highLevelInterpretationEngineAddress, NotificationManagerImpl subscriber, Map<String, Object> context) throws Exception {
        this.topicset = topicset;
        this.highLevelInterpretationEngineAddress = highLevelInterpretationEngineAddress;
        this.cepEngine = new LowLevelInterpretationCEPEngineCommand(producerAddress, topicset, highLevelInterpretationEngineAddress, subscriber, context);
        this.mlEngine = new LowLevelInterpretationMLEngineCommand(producerAddress, topicset, highLevelInterpretationEngineAddress, subscriber, context);
    }

    public GJaxbDeployResponse deploy(GJaxbDeploy request) throws DeployFault {
        GJaxbDeployResponse response = new GJaxbDeployResponse();
        response.setResult(new GJaxbDeployResult());
        try {
            LOG.debug("dispatcher rule deployment");
            GJaxbInterpretationConfigs intConfigs = InterpretationConfigDeployHelper.extractInterpretationConfig((GJaxbDeploy)request);
            for (GJaxbInterpretationConfig intConfig : intConfigs.getInterpretationConfig()) {
                GJaxbDeployResponse resp;
                GJaxbDeploy req1;
                GJaxbInterpretationConfigs configs;
                if (intConfig.getCepRule() != null && intConfig.getCepRule().getRule() != null) {
                    LOG.debug("cep rule deployment");
                    configs = new GJaxbInterpretationConfigs();
                    configs.getInterpretationConfig().add(intConfig);
                    req1 = InterpretationConfigDeployHelper.buildRequest((GJaxbInterpretationConfigs)configs, (String)request.getCollaborationName(), (String)request.getKnowledgeSpaceName(), (File[])new File[0]);
                    req1.setResourcesFolderBaseDir(new File(RIOConstant.RESOURCES_FOLDER).getCanonicalFile().toString());
                    resp = this.cepEngine.deploy(req1);
                    response.getResult().getRuleId().addAll(resp.getResult().getRuleId());
                    continue;
                }
                if (intConfig.getMlConfig() != null && intConfig.getMlConfig().getModule() != null) {
                    LOG.debug("ml rule deployment");
                    try {
                        configs = new GJaxbInterpretationConfigs();
                        configs.getInterpretationConfig().add(intConfig);
                        req1 = InterpretationConfigDeployHelper.buildRequest((GJaxbInterpretationConfigs)configs, (String)request.getCollaborationName(), (String)request.getKnowledgeSpaceName(), (File[])new File[0]);
                        req1.setResourcesFolderBaseDir(new File(RIOConstant.RESOURCES_FOLDER).getCanonicalFile().toString());
                        resp = this.mlEngine.deploy(req1);
                        response.getResult().getRuleId().addAll(resp.getResult().getRuleId());
                        continue;
                    }
                    catch (Exception e) {
                        String error = "Impossible to deploy rule '" + request.getRuleId() + "' on machine learning engine !!! (Verify if Python is activated in configuration file)";
                        throw new Exception(error, e);
                    }
                }
                throw new DeployFault("No cep rule or ml config defined !!!", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeployFault(e.getLocalizedMessage(), null);
        }
        return response;
    }

    public GJaxbGetInterpretationConfigResponse getInterpretationConfig(GJaxbGetInterpretationConfig parameters) throws GetInterpretationConfigFault {
        GJaxbGetInterpretationConfigResponse response = new GJaxbGetInterpretationConfigResponse();
        try {
            response = this.cepEngine.getInterpretationConfig(parameters);
            if (!response.isSetInterpretationConfig()) {
                response = this.mlEngine.getInterpretationConfig(parameters);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new GetInterpretationConfigFault(e.getMessage(), null, e);
        }
        return response;
    }

    public GJaxbUndeployResponse undeploy(GJaxbUndeploy parameters) throws UndeployFault {
        GJaxbUndeployResponse response = new GJaxbUndeployResponse();
        this.cepEngine.undeploy(parameters);
        this.mlEngine.undeploy(parameters);
        return response;
    }

    public GJaxbGetInterpretationConfigsResponse getInterpretationConfigs(GJaxbGetInterpretationConfigs parameters) throws GetInterpretationConfigsFault {
        GJaxbGetInterpretationConfigsResponse response = new GJaxbGetInterpretationConfigsResponse();
        response.getInterpretationConfig().addAll(this.cepEngine.getInterpretationConfigs(parameters).getInterpretationConfig());
        response.getInterpretationConfig().addAll(this.mlEngine.getInterpretationConfigs(parameters).getInterpretationConfig());
        return response;
    }

    public LowLevelInterpretationCEPEngineCommand getCepEngine() {
        return this.cepEngine;
    }

    public LowLevelInterpretationMLEngineCommand getMlEngine() {
        return this.mlEngine;
    }

    public GJaxbUpdateInterpretationConfigResponse updateInterpretationConfig(GJaxbUpdateInterpretationConfig parameters) throws UpdateInterpretationConfigFault {
        return null;
    }

    public GJaxbPredictResponse predict(GJaxbPredict parameters) throws PredictFault {
        return this.mlEngine.predict(parameters);
    }
}

