/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.ml.manager;

import fr.emac.gind.commons.utils.lang.UncheckedException;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.event.ml.manager.MLConfigManagerCommand;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class MLConfigManagerWebService
extends SPIWebServicePrimitives {
    private String storageAddress = null;
    private Map<QName, Class<?>> jaxbMapper = new HashMap();

    public void onInit(Map<String, Object> context) {
        try {
            if (context.get("storage") == null) {
                throw new UncheckedException("Configuration Error: storage cannot be null!!!");
            }
            this.storageAddress = (String)context.get("storage");
            MLConfigManagerCommand command = new MLConfigManagerCommand(context);
            this.registerWSImplementation("mlConfigsManager", command);
        }
        catch (Exception e) {
            throw new UncheckedException(e.getMessage(), (Throwable)e);
        }
    }

    public static MLConfigManagerWebService createAndStart(final int port, final String eventStorageAddr, final String govAddr) throws Exception {
        MLConfigManagerWebService cepRulesServer = new MLConfigManagerWebService();
        cepRulesServer.start(new HashMap<String, Object>(){
            {
                this.put("host", "localhost");
                this.put("port", port);
                this.put("storage", eventStorageAddr);
                this.put("governance", govAddr);
            }
        });
        return cepRulesServer;
    }
}

