/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.ml.manager;

import fr.emac.gind.commons.utils.RIOConstant;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.event.broker.EventBrokerWebService;
import fr.emac.gind.event.broker.SubscriberBrokerManagerImpl;
import fr.emac.gind.event.interpretation.config.InterpretationConfigDeployHelper;
import fr.emac.gind.event.interpretation.predict.SPIAbstractPredictModule;
import fr.emac.gind.event.interpretation.predict.SPIPredictModuleService;
import fr.emac.gind.event.ml.manager.MLManagerNotifier;
import fr.emac.gind.event.producer.NotificationManagerImpl;
import fr.emac.gind.interpretationconfigs.DeployFault;
import fr.emac.gind.interpretationconfigs.GetInterpretationConfigFault;
import fr.emac.gind.interpretationconfigs.GetInterpretationConfigsFault;
import fr.emac.gind.interpretationconfigs.InterpretationCommand;
import fr.emac.gind.interpretationconfigs.PredictCommand;
import fr.emac.gind.interpretationconfigs.PredictFault;
import fr.emac.gind.interpretationconfigs.UndeployFault;
import fr.emac.gind.interpretationconfigs.UpdateInterpretationConfigFault;
import fr.emac.gind.model.interpretation.config.GJaxbDeploy;
import fr.emac.gind.model.interpretation.config.GJaxbDeployResponse;
import fr.emac.gind.model.interpretation.config.GJaxbDeployResult;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfig;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfigResponse;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfigs;
import fr.emac.gind.model.interpretation.config.GJaxbGetInterpretationConfigsResponse;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfig;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfigs;
import fr.emac.gind.model.interpretation.config.GJaxbPredict;
import fr.emac.gind.model.interpretation.config.GJaxbPredictResponse;
import fr.emac.gind.model.interpretation.config.GJaxbSubscriptionRequiredType;
import fr.emac.gind.model.interpretation.config.GJaxbUndeploy;
import fr.emac.gind.model.interpretation.config.GJaxbUndeployResponse;
import fr.emac.gind.model.interpretation.config.GJaxbUpdateInterpretationConfig;
import fr.emac.gind.model.interpretation.config.GJaxbUpdateInterpretationConfigResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLConfigManagerCommand
implements InterpretationCommand,
PredictCommand {
    private static final Logger LOG = LoggerFactory.getLogger((String)MLConfigManagerCommand.class.getName());
    private SPIPredictModuleService predictor = null;
    private MLManagerNotifier notifier = null;
    private Map<String, Map<QName, List<GJaxbInterpretationConfig>>> mapExecRuntime = Collections.synchronizedMap(new HashMap());
    private Map<String, Map<String, GJaxbInterpretationConfig>> mapRules = new HashMap<String, Map<String, GJaxbInterpretationConfig>>();
    private Map<String, Object> context = null;

    public MLConfigManagerCommand(Map<String, Object> context) throws Exception {
        this.context = context;
        this.predictor = new SPIPredictModuleService(context);
    }

    public void setNotifier(MLManagerNotifier notifier) {
        this.notifier = notifier;
    }

    public Map<String, Map<QName, List<GJaxbInterpretationConfig>>> getMapExecRuntime() {
        return this.mapExecRuntime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GJaxbDeployResponse deploy(GJaxbDeploy request) throws DeployFault {
        GJaxbDeployResponse response = new GJaxbDeployResponse();
        response.setResult(new GJaxbDeployResult());
        LOG.debug("deploy ml config");
        try {
            GJaxbInterpretationConfigs configs = InterpretationConfigDeployHelper.extractInterpretationConfig((GJaxbDeploy)request);
            for (GJaxbInterpretationConfig config : configs.getInterpretationConfig()) {
                String knowledgeSpaceName;
                String collaborationName = request.getCollaborationName();
                String collabKnownKey = "_c__" + collaborationName + "_k__" + (knowledgeSpaceName = request.getKnowledgeSpaceName());
                if (this.mapRules.get(collabKnownKey) == null) {
                    this.mapRules.put(collabKnownKey, new HashMap());
                }
                this.mapRules.get(collabKnownKey).put(config.getId(), config);
                config.getContext().setResourcesFolderDir(new File(RIOConstant.RESOURCES_FOLDER).getCanonicalFile().toString());
                if (!config.getMlConfig().isActivateRequiredSubscriptions()) continue;
                if (this.mapExecRuntime.get(collabKnownKey) == null) {
                    this.mapExecRuntime.put(collabKnownKey, new HashMap());
                }
                for (GJaxbSubscriptionRequiredType entry : config.getContext().getSubscriptionsRequired().getEntry()) {
                    try {
                        QName topicUsed = entry.getTopic();
                        LOG.debug("topicUsed: " + String.valueOf(topicUsed));
                        String subscriptionAddress = entry.getEndpointAddressToSubscribe();
                        LOG.debug("ML SUBSCRIBE ON " + String.valueOf(topicUsed) + " => OK");
                        if (subscriptionAddress.endsWith("/BrokerSubscriber") && LocalRegistry.getInstance().findWS(EventBrokerWebService.class) != null) {
                            EventBrokerWebService localEventBroker = (EventBrokerWebService)LocalRegistry.getInstance().findWS(EventBrokerWebService.class);
                            SubscriberBrokerManagerImpl localEventBrokerNotifier = (SubscriberBrokerManagerImpl)localEventBroker.getImplementation(SubscriberBrokerManagerImpl.class);
                            this.notifier.subscribeOn((NotificationManagerImpl)localEventBrokerNotifier, topicUsed);
                        } else {
                            this.notifier.subscribeOn(subscriptionAddress, topicUsed);
                        }
                        if (this.mapExecRuntime.get(collabKnownKey) == null) {
                            this.mapExecRuntime.put(collabKnownKey, new HashMap());
                        }
                        if (this.mapExecRuntime.get(collabKnownKey).get(entry.getCorrespondingEvent()) == null) {
                            this.mapExecRuntime.get(collabKnownKey).put(entry.getCorrespondingEvent(), new ArrayList());
                        }
                        this.mapExecRuntime.get(collabKnownKey).get(entry.getCorrespondingEvent()).add(config);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw e;
                    }
                }
                continue;
                return response;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeployFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbUndeployResponse undeploy(GJaxbUndeploy parameters) throws UndeployFault {
        GJaxbUndeployResponse res = new GJaxbUndeployResponse();
        try {
            if (!parameters.getRequest().getRuleId().isEmpty()) {
                String collab = "";
                if (parameters.getCollaborationName() != null) {
                    collab = parameters.getCollaborationName();
                }
                String knowledge = "";
                if (parameters.getKnowledgeSpaceName() != null) {
                    knowledge = parameters.getKnowledgeSpaceName();
                }
                String collabKnownKey = "_c__" + collab + "_k__" + knowledge;
                if (this.mapRules != null && !this.mapRules.isEmpty()) {
                    for (String ruleName : parameters.getRequest().getRuleId()) {
                        if (this.mapRules.get(collabKnownKey) == null) continue;
                        GJaxbInterpretationConfig gJaxbInterpretationConfig = this.mapRules.get(collabKnownKey).remove(ruleName);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UndeployFault(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbGetInterpretationConfigResponse getInterpretationConfig(GJaxbGetInterpretationConfig parameters) throws GetInterpretationConfigFault {
        GJaxbInterpretationConfig rule;
        String collabKnownKey;
        GJaxbGetInterpretationConfigResponse res = new GJaxbGetInterpretationConfigResponse();
        String collaborationName = parameters.getCollaborationName();
        String knowledgespaceName = parameters.getKnowledgeSpaceName();
        String collab = "";
        if (parameters.getCollaborationName() != null) {
            collab = RegExpHelper.toRegexFriendlyName((String)parameters.getCollaborationName());
        }
        String knowledge = "";
        if (parameters.getKnowledgeSpaceName() != null) {
            knowledge = RegExpHelper.toRegexFriendlyName((String)parameters.getKnowledgeSpaceName());
        }
        if (this.mapRules.get(collabKnownKey = "_c__" + collab + "_k__" + knowledge) != null && (rule = this.mapRules.get(collabKnownKey).get(parameters.getRuleId())) != null) {
            res.setInterpretationConfig(rule);
        }
        return res;
    }

    public GJaxbGetInterpretationConfigsResponse getInterpretationConfigs(GJaxbGetInterpretationConfigs parameters) throws GetInterpretationConfigsFault {
        GJaxbGetInterpretationConfigsResponse res = new GJaxbGetInterpretationConfigsResponse();
        try {
            String collabKnownKey;
            String collab = "";
            if (parameters.getCollaborationName() != null) {
                collab = RegExpHelper.toRegexFriendlyName((String)parameters.getCollaborationName());
            }
            String knowledge = "";
            if (parameters.getKnowledgeSpaceName() != null) {
                knowledge = RegExpHelper.toRegexFriendlyName((String)parameters.getKnowledgeSpaceName());
            }
            if (this.mapRules.get(collabKnownKey = "_c__" + collab + "_k__" + knowledge) != null) {
                for (Map.Entry<String, GJaxbInterpretationConfig> entry_rules : this.mapRules.get(collabKnownKey).entrySet()) {
                    GJaxbInterpretationConfig rule = entry_rules.getValue();
                    res.getInterpretationConfig().add(rule);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GetInterpretationConfigsFault(e.getMessage(), null, (Throwable)e);
        }
        return res;
    }

    public GJaxbPredictResponse predict(GJaxbPredict parameters) throws PredictFault {
        try {
            SPIAbstractPredictModule predictModule = (SPIAbstractPredictModule)this.predictor.getPredictModules().get(parameters.getPluginName());
            if (predictModule != null) {
                return predictModule.predict(parameters);
            }
            throw new Exception("Impossible to find predict module: " + parameters.getPluginName());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PredictFault(e.getMessage(), null, (Throwable)e);
        }
    }

    public GJaxbUpdateInterpretationConfigResponse updateInterpretationConfig(GJaxbUpdateInterpretationConfig parameters) throws UpdateInterpretationConfigFault {
        return null;
    }
}

