/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.mock.endpoints.manager.protocol;

import fr.emac.gind.gov.core_gov.GJaxbGetNode;
import fr.emac.gind.gov.core_gov.GJaxbGetNodeResponse;
import fr.emac.gind.gov.core_gov.GJaxbUpdateNode;
import fr.emac.gind.mock.endpoints.manager.MockEndpointManagerWebService;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbEndpointStatusType;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbMockEndpoint;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import fr.emac.gind.sharedOptions.GJaxbSelectedKnowledgeSpace;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMockEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractMockEndpoint.class.getName());
    protected GJaxbMockEndpoint mockEndpointModel = null;
    protected List<GJaxbProperty> context = null;
    protected String collaborationName = null;
    protected String knowledgeSpaceName = null;
    protected MockEndpointManagerWebService mockEndpointsWebService = null;

    public AbstractMockEndpoint(GJaxbMockEndpoint mockEndpointModel, MockEndpointManagerWebService mockEndpointsWebService, String collaborationName, String knowledgeSpaceName, List<GJaxbProperty> context) throws Exception {
        this.collaborationName = collaborationName;
        this.knowledgeSpaceName = knowledgeSpaceName;
        this.mockEndpointsWebService = mockEndpointsWebService;
        this.setMockEndpointModel(mockEndpointModel);
        this.mockEndpointModel.setId("mock_ep_" + mockEndpointModel.getGoodId());
        this.mockEndpointModel.setStatus(GJaxbEndpointStatusType.CREATED);
        this.setContext(context);
    }

    protected abstract String createAddress(MockEndpointManagerWebService var1, GJaxbMockEndpoint var2, String var3, String var4);

    public GJaxbMockEndpoint getMockEndpointModel() {
        return this.mockEndpointModel;
    }

    public void setMockEndpointModel(GJaxbMockEndpoint mockEndpointModel) {
        this.mockEndpointModel = mockEndpointModel;
        this.mockEndpointModel.setAddress(this.createAddress(this.mockEndpointsWebService, mockEndpointModel, this.collaborationName, this.knowledgeSpaceName));
    }

    public String getAddress() {
        return this.mockEndpointModel.getAddress();
    }

    public List<GJaxbProperty> getContext() {
        return this.context;
    }

    public void setContext(List<GJaxbProperty> context) {
        this.context = context;
    }

    public boolean isStarted() {
        return this.mockEndpointModel.getStatus().equals((Object)GJaxbEndpointStatusType.STARTED);
    }

    public void start() throws Exception {
        if (!this.isStarted()) {
            this.onStart();
            this.mockEndpointModel.setStatus(GJaxbEndpointStatusType.STARTED);
            if (this.mockEndpointsWebService.getMockEndpointsManager().getCoreGovClient() != null) {
                GJaxbGetNode getNodeReq = new GJaxbGetNode();
                getNodeReq.setId(this.getMockEndpointModel().getGoodId());
                getNodeReq.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                getNodeReq.getSelectedKnowledgeSpace().setCollaborationName(this.collaborationName);
                getNodeReq.getSelectedKnowledgeSpace().setKnowledgeName(this.knowledgeSpaceName);
                GJaxbGetNodeResponse getNodeResp = this.mockEndpointsWebService.getMockEndpointsManager().getCoreGovClient().getNode(getNodeReq);
                GJaxbNode good = getNodeResp.getNode();
                GenericModelHelper.findProperty((String)"endpoint address", (List)good.getProperty(), (boolean)true).setValue(this.getAddress());
                GJaxbUpdateNode upNodeReq = new GJaxbUpdateNode();
                upNodeReq.setNode(good);
                upNodeReq.setSelectedKnowledgeSpace(new GJaxbSelectedKnowledgeSpace());
                upNodeReq.getSelectedKnowledgeSpace().setCollaborationName(this.collaborationName);
                upNodeReq.getSelectedKnowledgeSpace().setKnowledgeName(this.knowledgeSpaceName);
                this.mockEndpointsWebService.getMockEndpointsManager().getCoreGovClient().updateNode(upNodeReq);
                getNodeResp.getNode();
            }
        } else {
            LOG.info("Mock endpoint was already started at: " + this.getAddress());
        }
    }

    protected abstract void onStart() throws Exception;

    public void stop() throws Exception {
        if (this.isStarted()) {
            this.onStop();
            this.mockEndpointModel.setStatus(GJaxbEndpointStatusType.STOPPED);
        }
    }

    protected abstract void onStop() throws Exception;
}

