/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.mock.endpoints.manager.protocol.http_soap;

import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.commons.utils.ws.SPIWebServicePrimitives;
import fr.emac.gind.commons.utils.ws.StaticJettyServer;
import fr.emac.gind.mock.endpoints.manager.MockEndpointManagerWebService;
import fr.emac.gind.mock.endpoints.manager.data.GJaxbMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.protocol.AbstractMockEndpoint;
import fr.emac.gind.mock.endpoints.manager.protocol.http_soap.SoapMockEndpointReceiver;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.servlet.soap.impl.servlet.SoapHandler;
import fr.emac.gind.servlet.soap.impl.servlet.SoapReceiver;
import java.net.URI;
import java.util.List;
import org.eclipse.jetty.server.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOAPMockEndpoint
extends AbstractMockEndpoint {
    private static Logger LOG = LoggerFactory.getLogger(SOAPMockEndpoint.class);

    public SOAPMockEndpoint(GJaxbMockEndpoint mockEndpointModel, MockEndpointManagerWebService mockEndpointsWebService, String collaborationName, String knowledgeSpaceName, List<GJaxbProperty> context) throws Exception {
        super(mockEndpointModel, mockEndpointsWebService, collaborationName, knowledgeSpaceName, context);
    }

    @Override
    protected String createAddress(MockEndpointManagerWebService eventSensorWebService, GJaxbMockEndpoint mockEndpointModel, String collaborationName, String knowledgeSpaceName) {
        String producerEndpointName = "mockEndpoint/" + collaborationName.hashCode() + "/" + knowledgeSpaceName.hashCode() + "/" + RegExpHelper.toRegexFriendlyName((String)mockEndpointModel.getName());
        String producerAgentUrl = SPIWebServicePrimitives.createAddress((IPUtil.TRANSPORT_PROTOCOL)IPUtil.TRANSPORT_PROTOCOL.HTTP, (String)eventSensorWebService.getHost(), (int)mockEndpointModel.getPort(), (int)eventSensorWebService.getProxyPort(), (String)producerEndpointName);
        return producerAgentUrl;
    }

    @Override
    protected void onStart() throws Exception {
        SoapMockEndpointReceiver mockSoapReceiver = new SoapMockEndpointReceiver(this.getMockEndpointModel(), this.mockEndpointsWebService.getContext());
        SoapHandler sp = new SoapHandler((SoapReceiver)mockSoapReceiver, null, this.getMockEndpointModel().getName(), null);
        sp.setURL(URI.create(this.getAddress()).toURL());
        StaticJettyServer.getInstance().addHandler(sp.getURL().getPath(), (Handler.Abstract)sp);
        StaticJettyServer.getInstance().addConnector(this.getMockEndpointModel().getPort().intValue());
        LOG.info("Mock endpoint started at: " + this.getAddress());
    }

    @Override
    protected void onStop() throws Exception {
        this.mockEndpointsWebService.stop(this);
    }
}

