/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.models.generic.modeler.generic_model;

import fr.emac.gind.commons.utils.date.LocalDateTimeHelper;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPointType;
import fr.emac.gind.modeler.genericmodel.GJaxbPosition;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.modeler.genericmodel.GJaxbRelationModeType;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.modeler.metamodel.GJaxbConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbFixedValues;
import fr.emac.gind.modeler.metamodel.GJaxbMetaProperty;
import fr.emac.gind.modeler.metamodel.GJaxbRelation;
import fr.emac.gind.models.generic.modeler.plugins.EffectiveMetaModelPluginManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericModelHelper {
    private static final Logger LOG = LoggerFactory.getLogger((String)GenericModelHelper.class.getName());
    private static int cpt = 0;

    public static QName collab(String name) {
        return new QName("http://fr.emac.gind/collaborative-model", name);
    }

    public static QName core(String name) {
        return new QName("http://fr.emac.gind/core-model", name);
    }

    public static QName system(String name) {
        return new QName("http://fr.emac.gind/system", name);
    }

    public static QName project(String name) {
        return new QName("http://fr.emac.gind/iosuite/project", name);
    }

    public static QName uml(String name) {
        return new QName("http://fr.emac.gind/uml-model", name);
    }

    public static GJaxbProperty findProperty(String name, List<GJaxbProperty> properties) {
        Optional<GJaxbProperty> res = properties.stream().filter(p -> p != null && name.equals(p.getName())).findFirst();
        if (res.isPresent()) {
            return res.get();
        }
        return null;
    }

    public static GJaxbProperty findProperty(String name, List<GJaxbProperty> properties, boolean createIfNotExist) {
        GJaxbProperty prop = GenericModelHelper.findProperty(name, properties);
        if (prop == null && createIfNotExist) {
            prop = new GJaxbProperty();
            prop.setName(name);
            properties.add(prop);
        }
        return prop;
    }

    public static GJaxbProperty createProperty(String name, String value) {
        GJaxbProperty prop = new GJaxbProperty();
        prop.setName(name);
        prop.setValue(value);
        return prop;
    }

    public static GJaxbNode createNodeFromMetaModel(GJaxbConceptType metaModel, boolean setDefaultValue) throws Exception {
        GJaxbNode node = new GJaxbNode();
        node.setId("node_" + metaModel.getType().getLocalPart().toLowerCase() + "_" + UUID.randomUUID().toString());
        node.setType(metaModel.getType());
        node.getStatus().add(GJaxbStatusType.ACTIVE);
        List<GJaxbEffectiveConceptType> inheritConcepts = EffectiveMetaModelPluginManager.getInstance().getInherits(metaModel.getType());
        inheritConcepts.forEach(ic -> {
            if (!node.getExtends().contains(ic.getType())) {
                node.getExtends().add(ic.getType());
            }
        });
        for (GJaxbMetaProperty metaProp : metaModel.getMetaProperty()) {
            node.getProperty().add(GenericModelHelper.createPropertyFromMetaModel(metaProp, setDefaultValue, metaModel.getType()));
        }
        return node;
    }

    public static GJaxbEdge createEdgeFromMetaModel(GJaxbRelation edgetMetaModel, boolean setDefaultValue) throws Exception {
        GJaxbEdge edge = new GJaxbEdge();
        edge.setId("edge_" + edgetMetaModel.getType().getLocalPart().toLowerCase() + "_" + UUID.randomUUID().toString());
        edge.setType(edgetMetaModel.getType());
        for (GJaxbMetaProperty metaProp : edgetMetaModel.getMetaProperty()) {
            edge.getProperty().add(GenericModelHelper.createPropertyFromMetaModel(metaProp, setDefaultValue, edgetMetaModel.getType()));
        }
        return edge;
    }

    public static GJaxbProperty createPropertyFromMetaModel(GJaxbMetaProperty metaModel, boolean setDefaultValue, QName parentType) throws Exception {
        GJaxbProperty prop = new GJaxbProperty();
        prop.setName(metaModel.getName());
        JSONObject val = new JSONObject();
        if (metaModel.getDefaultValue() != null) {
            if (setDefaultValue) {
                String defaultVal = metaModel.getDefaultValue();
                if (defaultVal.contains("${node.type}")) {
                    defaultVal = defaultVal.replace("${node.type}", parentType.getLocalPart());
                }
                if (defaultVal.contains("${cpt}")) {
                    defaultVal = defaultVal.replace("${cpt}", String.valueOf(++cpt));
                }
                if (defaultVal.contains("${now}")) {
                    defaultVal = defaultVal.replace("${now}", String.valueOf(LocalDateTimeHelper.isoString((LocalDateTime)LocalDateTime.now())));
                }
                prop.setValue(defaultVal);
            }
        } else {
            switch (metaModel.getType()) {
                case TABLE: {
                    prop.setValue("[]");
                    break;
                }
                case CHECKBOX: {
                    for (GJaxbFixedValues.Value fixedValue : metaModel.getValues().getFixedValues().getValue()) {
                        JSONObject checkBoxes = new JSONObject();
                        checkBoxes.put("checked", false);
                        checkBoxes.put("disabled", false);
                        checkBoxes.put("icon", (Object)fixedValue.getIcon());
                        val.put(fixedValue.getContent(), (Object)checkBoxes);
                    }
                    prop.setValue(val.toString());
                    break;
                }
                case BUTTON: {
                    val.put("buttons", (Object)"[]");
                    prop.setValue(val.toString());
                    break;
                }
                default: {
                    prop.setValue(null);
                }
            }
        }
        return prop;
    }

    public static String getName(GJaxbNode node) {
        if (node != null) {
            GJaxbProperty propName = GenericModelHelper.findProperty("name", node.getProperty());
            if (propName != null) {
                return propName.getValue();
            }
            propName = GenericModelHelper.findProperty("NAME", node.getProperty());
            if (propName != null) {
                return propName.getValue();
            }
            propName = GenericModelHelper.findProperty("Name", node.getProperty());
            if (propName != null) {
                return propName.getValue();
            }
        }
        return null;
    }

    public static void setName(GJaxbNode node, String newName) {
        if (node != null) {
            GJaxbProperty propName = GenericModelHelper.findProperty("name", node.getProperty());
            if (propName != null) {
                propName.setValue(newName);
            } else {
                propName = GenericModelHelper.findProperty("NAME", node.getProperty());
                if (propName != null) {
                    propName.setValue(newName);
                } else {
                    propName = GenericModelHelper.findProperty("Name", node.getProperty());
                    if (propName != null) {
                        propName.setValue(newName);
                    }
                }
            }
        }
    }

    public static String getName(GJaxbEdge node) {
        if (node != null) {
            GJaxbProperty propName = GenericModelHelper.findProperty("name", node.getProperty());
            if (propName != null) {
                return propName.getValue();
            }
            propName = GenericModelHelper.findProperty("NAME", node.getProperty());
            if (propName != null) {
                return propName.getValue();
            }
            propName = GenericModelHelper.findProperty("Name", node.getProperty());
            if (propName != null) {
                return propName.getValue();
            }
        }
        return null;
    }

    public static void setName(GJaxbEdge node, String newName) {
        if (node != null) {
            GJaxbProperty propName = GenericModelHelper.findProperty("name", node.getProperty());
            if (propName != null) {
                propName.setValue(newName);
            } else {
                propName = GenericModelHelper.findProperty("NAME", node.getProperty());
                if (propName != null) {
                    propName.setValue(newName);
                } else {
                    propName = GenericModelHelper.findProperty("Name", node.getProperty());
                    if (propName != null) {
                        propName.setValue(newName);
                    }
                }
            }
        }
    }

    public static GJaxbNode findNodeById(String id, List<GJaxbNode> nodes) {
        for (GJaxbNode node : nodes) {
            if (!node.getId().equals(id)) continue;
            return node;
        }
        return null;
    }

    public static List<GJaxbNode> findNodesByType(QName type, List<GJaxbNode> nodes) {
        return nodes.stream().filter(n -> n.getType().equals(type) || n.getExtends() != null && n.getExtends().contains(type)).collect(Collectors.toList());
    }

    public static List<GJaxbNode> findNodesByName(String id, List<GJaxbNode> nodes) {
        return nodes.stream().filter(n -> id.contentEquals(GenericModelHelper.getName(n))).collect(Collectors.toList());
    }

    public static GJaxbEdge findEdgeById(String id, List<GJaxbEdge> edges) {
        for (GJaxbEdge edge : edges) {
            if (!edge.getId().equals(id)) continue;
            return edge;
        }
        return null;
    }

    public static List<GJaxbEdge> findEdgesByType(QName type, List<GJaxbEdge> edges) {
        return edges.stream().filter(e -> e.getType().equals(type)).collect(Collectors.toList());
    }

    public static boolean equalsNode(GJaxbNode node1, GJaxbNode node2) {
        block0: for (GJaxbProperty propE : node1.getProperty()) {
            for (GJaxbProperty propF : node2.getProperty()) {
                if (!propE.getName().equals(propF.getName())) continue;
                if (propE.getValue() == null || propE.getValue().equals(propF.getValue())) continue block0;
                return false;
            }
        }
        return true;
    }

    public static JSONArray parsePropertyValueAsJSONArray(GJaxbNode node, String propertyName) {
        GJaxbProperty prop = GenericModelHelper.findProperty(propertyName, node.getProperty());
        if (prop == null || prop.getValue() == null || prop.getValue().length() == 0) {
            return null;
        }
        return new JSONArray(prop.getValue());
    }

    public static String getAttributeValueFromArrayProperty(GJaxbNode node, String propertyName, String attributeName) {
        JSONArray temp = GenericModelHelper.parsePropertyValueAsJSONArray(node, propertyName);
        if (temp != null && temp.toString().isBlank() && !temp.toString().equals("[]") && !temp.toString().equals("[{}]")) {
            JSONArray array = temp.getJSONArray(0);
            return GenericModelHelper.getAttributeValueFromArrayProperty(array, attributeName);
        }
        return null;
    }

    public static void setAttributeValueFromArrayProperty(GJaxbNode node, String name, String key, Object object) {
        JSONArray array = GenericModelHelper.parsePropertyValueAsJSONArray(node, name).getJSONArray(0);
        for (int i = 0; i < array.length(); ++i) {
            if (!array.getJSONObject(i).getString("name").equals(key)) continue;
            array.getJSONObject(i).put("value", object);
            break;
        }
        GenericModelHelper.findProperty(name, node.getProperty()).setValue(new JSONArray().put((Object)new JSONArray(array.toString())).toString());
    }

    public static String getAttributeValueFromArrayProperty(JSONArray array, String attributeName) {
        String attributeValue = "";
        for (int i = 0; i < array.length(); ++i) {
            if (!array.getJSONObject(i).getString("name").equals(attributeName)) continue;
            attributeValue = array.getJSONObject(i).getString("value");
            break;
        }
        return attributeValue;
    }

    public static GJaxbNode.Modeling.ItemView findItemViewFromPackage(GJaxbNode node, String viewName, boolean createIfNotExist) {
        GJaxbNode.Modeling.ItemView res = null;
        if (node.isSetModeling()) {
            for (GJaxbNode.Modeling.ItemView cat : node.getModeling().getItemView()) {
                if (!cat.getPackageName().equals(viewName)) continue;
                res = cat;
                break;
            }
        }
        if (res == null && createIfNotExist) {
            res = new GJaxbNode.Modeling.ItemView();
            res.setViewId("view_" + String.valueOf(UUID.randomUUID()));
            res.setPackageName(viewName);
            res.setPosition(new GJaxbPosition());
            res.getPosition().setX(0.0f);
            res.getPosition().setY(0.0f);
            node.getModeling().getItemView().add(res);
        }
        return res;
    }

    public static GJaxbEdge.Modeling.ItemView findItemViewFromPackage(GJaxbEdge edge, String viewName, boolean createIfNotExist) {
        GJaxbEdge.Modeling.ItemView res = null;
        if (edge.getModeling() == null) {
            edge.setModeling(new GJaxbEdge.Modeling());
        }
        for (GJaxbEdge.Modeling.ItemView cat : edge.getModeling().getItemView()) {
            if (!cat.getPackageName().equals(viewName)) continue;
            res = cat;
            break;
        }
        if (res == null && createIfNotExist) {
            res = new GJaxbEdge.Modeling.ItemView();
            res.setPackageName(viewName);
            edge.getModeling().getItemView().add(res);
        }
        return res;
    }

    public static GJaxbNode cloneNode(GJaxbNode node) {
        GJaxbNode res = new GJaxbNode();
        res.setId(node.getId());
        res.setModeling(node.getModeling());
        res.setGeolocation(node.getGeolocation());
        res.setType(node.getType());
        node.getProperty().forEach(p -> {
            GJaxbProperty newP = new GJaxbProperty();
            newP.setName(p.getName());
            newP.setValue(p.getValue());
            res.getProperty().add(newP);
        });
        if (node.isSetBrokenEdges()) {
            res.setBrokenEdges(new GJaxbNode.BrokenEdges());
            if (!node.getBrokenEdges().getBrokenEdge().isEmpty()) {
                node.getBrokenEdges().getBrokenEdge().forEach(be -> res.getBrokenEdges().getBrokenEdge().add(GenericModelHelper.cloneBrokenEdge(be)));
            }
        }
        res.setBrokenEdges(node.getBrokenEdges());
        return res;
    }

    private static GJaxbNode.BrokenEdges.BrokenEdge cloneBrokenEdge(GJaxbNode.BrokenEdges.BrokenEdge be) {
        GJaxbNode.BrokenEdges.BrokenEdge cbe = new GJaxbNode.BrokenEdges.BrokenEdge();
        cbe.setSourceId(be.getSourceId());
        cbe.setTargetId(be.getTargetId());
        cbe.setEdge(GenericModelHelper.cloneEdge(be.getEdge()));
        return cbe;
    }

    public static GJaxbEdge cloneEdge(GJaxbEdge edge) {
        GJaxbEdge ce = new GJaxbEdge();
        ce.setId(edge.getId());
        ce.setMode(edge.getMode());
        ce.setModeling(edge.getModeling());
        ce.setType(edge.getType());
        edge.getProperty().forEach(p -> {
            GJaxbProperty newP = new GJaxbProperty();
            newP.setName(p.getName());
            newP.setValue(p.getValue());
            ce.getProperty().add(newP);
        });
        ce.setSource(null);
        ce.setTarget(null);
        return ce;
    }

    public static GJaxbNode findTopParentNode(GJaxbNode node, GJaxbGenericModel model) throws Exception {
        GJaxbNode res = null;
        GJaxbNode parent = GenericModelHelper.findFirstParent(node, model);
        while (parent != null) {
            res = parent;
            LOG.debug("parent type: " + String.valueOf(parent.getType()));
            parent = GenericModelHelper.findFirstParent(parent, model);
        }
        return res;
    }

    public static GJaxbNode findFirstParent(GJaxbNode node, GJaxbGenericModel model) throws Exception {
        GJaxbNode parent = null;
        List<GJaxbNode> parents = GenericModelHelper.findParents(node, model);
        if (parents != null && !parents.isEmpty()) {
            parent = parents.get(0);
        }
        return parent;
    }

    public static List<GJaxbNode> findParents(GJaxbNode node, GJaxbGenericModel model) throws Exception {
        ArrayList<GJaxbNode> parentNodes = new ArrayList<GJaxbNode>();
        try {
            ArrayList<GJaxbEdge> parentEdges = new ArrayList<GJaxbEdge>();
            for (GJaxbEdge e : model.getEdge()) {
                if (e.getSource() == null) {
                    throw new Exception("Source cannot be null !!!");
                }
                if (e.getMode() == null || !e.getMode().equals((Object)GJaxbRelationModeType.AGREGATION) && !e.getMode().equals((Object)GJaxbRelationModeType.COMPOSITION) || !e.getSource().getId().equals(node.getId())) continue;
                parentEdges.add(e);
            }
            for (GJaxbEdge edge : parentEdges) {
                parentNodes.add(edge.getTarget());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        return parentNodes;
    }

    public static List<GJaxbProperty> convertJSONArrayToPropertyList(JSONArray array) {
        ArrayList<GJaxbProperty> properties = new ArrayList<GJaxbProperty>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject param = array.getJSONObject(i);
            properties.add(GenericModelHelper.createProperty(param.get("name").toString(), param.get("value").toString()));
        }
        return properties;
    }

    public static JSONArray convertGJaxbPropertyListToJSONArray(List<GJaxbProperty> properties) {
        JSONArray jsonArray = new JSONArray();
        for (GJaxbProperty prop : properties) {
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)prop.getName());
            obj.put("value", (Object)prop.getValue());
            jsonArray.put((Object)obj);
        }
        return jsonArray;
    }

    public static JSONArray convertGJaxbPropertyToJSONArray(GJaxbProperty prop) {
        JSONArray jsonArray = new JSONArray();
        JSONObject obj = new JSONObject();
        obj.put("name", (Object)prop.getName());
        obj.put("value", (Object)prop.getValue());
        jsonArray.put((Object)obj);
        return jsonArray;
    }

    public static GJaxbGenericModel cloneGenericModel(GJaxbGenericModel process) throws Exception {
        return GenericModelHelper.clone(process, GJaxbGenericModel.class);
    }

    public static synchronized <T> T clone(AbstractJaxbObject obj, Class<T> clazz) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(obj);
        byte[] bytes = baos.toByteArray();
        out.flush();
        out.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Object copy = in.readObject();
        return (T)copy;
    }

    public static String printModel(GJaxbGenericModel model) {
        StringBuffer res = new StringBuffer();
        res.append("\nNodes: \n");
        res.append(GenericModelHelper.printNodes(model.getNode()));
        res.append("\n");
        res.append("\nEdges: \n");
        res.append(GenericModelHelper.printEdges(model.getEdge()));
        return res.toString();
    }

    public static String printNodes(List<GJaxbNode> node) {
        StringBuffer res = new StringBuffer();
        node.forEach(n -> res.append(GenericModelHelper.printNode(n) + "\n"));
        return res.toString();
    }

    public static String printNode(GJaxbNode node) {
        String res = GenericModelHelper.getName(node) + " - " + node.getId() + " - " + node.getType().getLocalPart();
        return res;
    }

    public static String printEdges(List<GJaxbEdge> edges) {
        StringBuffer res = new StringBuffer();
        edges.forEach(e -> res.append(GenericModelHelper.printEdge(e) + "\n"));
        return res.toString();
    }

    public static String printEdge(GJaxbEdge edge) {
        String target;
        String source = GenericModelHelper.getName(edge.getSource());
        if (source.isBlank()) {
            source = edge.getType().getLocalPart();
        }
        if ((target = GenericModelHelper.getName(edge.getTarget())).isBlank()) {
            target = edge.getType().getLocalPart();
        }
        return source + "(" + edge.getSource().getId() + ") -" + edge.getType().getLocalPart() + "-> " + target + "(" + edge.getTarget().getId() + ")\tid: " + edge.getId();
    }

    public static void deleteDuplicateNodes(List<GJaxbNode> nodes) {
        ArrayList<GJaxbNode> newNodes = new ArrayList<GJaxbNode>();
        for (GJaxbNode node : nodes) {
            if (GenericModelHelper.contains(node, newNodes)) continue;
            newNodes.add(node);
        }
        nodes.clear();
        nodes.addAll(newNodes);
    }

    public static void deleteDuplicateEdges(List<GJaxbEdge> edges) {
        ArrayList<GJaxbEdge> newEdges = new ArrayList<GJaxbEdge>();
        for (GJaxbEdge edge : edges) {
            if (GenericModelHelper.contains(edge, newEdges)) continue;
            newEdges.add(edge);
        }
        edges.clear();
        edges.addAll(newEdges);
    }

    public static boolean contains(GJaxbNode node, List<GJaxbNode> nodes) {
        for (GJaxbNode n : nodes) {
            if (n == null || n.getId() == null || node == null || !n.getId().equals(node.getId())) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(GJaxbEdge jaxbEdge, List<GJaxbEdge> edges) {
        for (GJaxbEdge e : edges) {
            if (e == null || !e.getId().equals(jaxbEdge.getId())) continue;
            return true;
        }
        return false;
    }

    public static GJaxbGenericModel mergeModels(GJaxbGenericModel ... models) {
        GJaxbGenericModel mergedModel = new GJaxbGenericModel();
        for (GJaxbGenericModel model : models) {
            for (GJaxbNode node : model.getNode()) {
                if (GenericModelHelper.contains(node, mergedModel.getNode())) continue;
                mergedModel.getNode().add(node);
            }
            for (GJaxbEdge edge : model.getEdge()) {
                if (GenericModelHelper.contains(edge, mergedModel.getEdge())) continue;
                mergedModel.getEdge().add(edge);
            }
        }
        return mergedModel;
    }

    public static GJaxbEdge createEdgeBetweenNodes(GJaxbNode source, GJaxbNode target, QName type, GJaxbRelationModeType relType) {
        GJaxbEdge edge = new GJaxbEdge();
        edge.setId("edge_" + RegExpHelper.toRegexFriendlyName((String)type.getLocalPart()) + UUID.randomUUID().toString());
        edge.setType(type);
        edge.setMode(relType);
        edge.setSource(source);
        edge.setTarget(target);
        return edge;
    }

    public static JSONArray convertTableToJSONArray(List<List<GJaxbProperty>> table) {
        JSONArray array = new JSONArray();
        table.forEach(row -> {
            JSONArray rowArray = new JSONArray();
            row.forEach(p -> {
                JSONObject pJ = new JSONObject();
                pJ.put("name", (Object)p.getName());
                pJ.put("value", (Object)p.getValue());
                rowArray.put((Object)pJ);
            });
            array.put((Object)rowArray);
        });
        return array;
    }

    public static List<List<GJaxbProperty>> convertJSONArrayToTable(JSONArray jsonArray) {
        ArrayList<List<GJaxbProperty>> array = new ArrayList<List<GJaxbProperty>>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONArray jsonRow = jsonArray.getJSONArray(i);
            ArrayList<GJaxbProperty> row = new ArrayList<GJaxbProperty>();
            for (int j = 0; j < jsonRow.length(); ++j) {
                JSONObject jsonProp = jsonRow.getJSONObject(j);
                GJaxbProperty prop = new GJaxbProperty();
                prop.setName(jsonProp.getString("name"));
                if (jsonProp.has("value")) {
                    prop.setValue(jsonProp.getString("value"));
                } else {
                    LOG.debug("no value");
                }
                row.add(prop);
            }
            array.add(row);
        }
        return array;
    }

    public static List<GJaxbNode.BrokenEdges.BrokenEdge> findBrokenEdgesByType(QName type, List<GJaxbNode.BrokenEdges.BrokenEdge> brokenEdges) {
        ArrayList<GJaxbNode.BrokenEdges.BrokenEdge> res = new ArrayList<GJaxbNode.BrokenEdges.BrokenEdge>();
        for (GJaxbNode.BrokenEdges.BrokenEdge be : brokenEdges) {
            if (be.getEdge() == null || !be.getEdge().getType().equals(type)) continue;
            res.add(be);
        }
        return res;
    }

    public static GJaxbNode.BrokenEdges.BrokenEdge findFirstBrokenEdgeOfType(QName type, List<GJaxbNode.BrokenEdges.BrokenEdge> brokenEdges) {
        List<GJaxbNode.BrokenEdges.BrokenEdge> res = GenericModelHelper.findBrokenEdgesByType(type, brokenEdges);
        if (res != null && !res.isEmpty()) {
            return res.get(0);
        }
        return null;
    }

    public static GJaxbNode.Geolocation.ItemView getItemViewPoint(GJaxbNode gpsSensor, boolean createIfNotExist) {
        GJaxbNode.Geolocation.ItemView iv = null;
        if (gpsSensor.isSetGeolocation() && !gpsSensor.getGeolocation().getItemView().isEmpty()) {
            iv = gpsSensor.getGeolocation().getItemView().get(0);
        }
        if (iv == null && createIfNotExist) {
            if (!gpsSensor.isSetGeolocation()) {
                gpsSensor.setGeolocation(new GJaxbNode.Geolocation());
            }
            if (gpsSensor.getGeolocation().getItemView().isEmpty()) {
                iv = new GJaxbNode.Geolocation.ItemView();
                iv.setPoint(new GJaxbPointType());
                gpsSensor.getGeolocation().getItemView().add(iv);
            }
        }
        return iv;
    }

    public static GJaxbGenericModel pushInModel(GJaxbGenericModel model, GJaxbGenericModel modelToAdd) {
        if (modelToAdd.isSetNode() && !modelToAdd.getNode().isEmpty()) {
            model.getNode().addAll(modelToAdd.getNode());
        }
        if (modelToAdd.isSetEdge() && !modelToAdd.getEdge().isEmpty()) {
            model.getEdge().addAll(modelToAdd.getEdge());
        }
        GenericModelHelper.deleteDuplicateNodes(model.getNode());
        GenericModelHelper.deleteDuplicateEdges(model.getEdge());
        return model;
    }
}

