/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.models.generic.modeler.utils;

import fr.emac.gind.commons.utils.list.ListUtil;
import fr.emac.gind.commons.utils.regexp.RegExpHelper;
import fr.emac.gind.marshaller.json.JSONJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbEdge;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.modeler.genericmodel.GJaxbNode;
import fr.emac.gind.modeler.genericmodel.GJaxbPosition;
import fr.emac.gind.modeler.genericmodel.GJaxbProperty;
import fr.emac.gind.modeler.genericmodel.GJaxbStatusType;
import fr.emac.gind.modeler.metamodel.GJaxbCardinalityRule;
import fr.emac.gind.modeler.metamodel.GJaxbConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbConnectionRule;
import fr.emac.gind.modeler.metamodel.GJaxbConnectionRules;
import fr.emac.gind.modeler.metamodel.GJaxbConnectorViewType;
import fr.emac.gind.modeler.metamodel.GJaxbContainmentRule;
import fr.emac.gind.modeler.metamodel.GJaxbDimension;
import fr.emac.gind.modeler.metamodel.GJaxbEdgeMetaModeling;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveDomain;
import fr.emac.gind.modeler.metamodel.GJaxbEffectiveMetaModel;
import fr.emac.gind.modeler.metamodel.GJaxbEffectivePackage;
import fr.emac.gind.modeler.metamodel.GJaxbFixedValues;
import fr.emac.gind.modeler.metamodel.GJaxbFormtypeType;
import fr.emac.gind.modeler.metamodel.GJaxbImportedNode;
import fr.emac.gind.modeler.metamodel.GJaxbMagnets;
import fr.emac.gind.modeler.metamodel.GJaxbManagedPositionType;
import fr.emac.gind.modeler.metamodel.GJaxbMetaProperty;
import fr.emac.gind.modeler.metamodel.GJaxbModelingEdgeViewDefinition;
import fr.emac.gind.modeler.metamodel.GJaxbModelingType;
import fr.emac.gind.modeler.metamodel.GJaxbModelingViewDefinition;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaGeolocation;
import fr.emac.gind.modeler.metamodel.GJaxbNodeMetaModeling;
import fr.emac.gind.modeler.metamodel.GJaxbPathEdgeType;
import fr.emac.gind.modeler.metamodel.GJaxbRelation;
import fr.emac.gind.modeler.metamodel.GJaxbRelationModeType;
import fr.emac.gind.modeler.metamodel.GJaxbRules;
import fr.emac.gind.modeler.metamodel.GJaxbShapeType;
import fr.emac.gind.modeler.metamodel.GJaxbValues;
import fr.emac.gind.models.generic.modeler.effective_meta_model.EffectiveMetaModelHelper;
import fr.emac.gind.models.generic.modeler.generic_model.GenericModelHelper;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;

public class M2MMConverter {
    private static M2MMConverter INSTANCE = null;

    private M2MMConverter() {
    }

    public static M2MMConverter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new M2MMConverter();
        }
        return INSTANCE;
    }

    public GJaxbNode convertConceptToNode(GJaxbEffectiveConceptType concept) throws Exception {
        GJaxbNode nodeC = new GJaxbNode();
        nodeC.setId("CLASS_" + concept.getType().getNamespaceURI().hashCode() + "_" + concept.getType().getLocalPart());
        nodeC.setType(new QName("http://fr.emac.gind/uml-model", "Class"));
        nodeC.getStatus().add(GJaxbStatusType.ACTIVE);
        GenericModelHelper.findProperty("name", nodeC.getProperty(), true).setValue(concept.getType().getLocalPart());
        GenericModelHelper.findProperty("type", nodeC.getProperty(), true).setValue(concept.isSetAbstract() && concept.isAbstract() != false ? "Abstract" : "Concrete");
        GenericModelHelper.findProperty("readonly", nodeC.getProperty(), true).setValue(concept.isSetReadonly() ? concept.isReadonly().toString() : "false");
        nodeC.setModeling(new GJaxbNode.Modeling());
        GJaxbNode.Modeling.ItemView iv = new GJaxbNode.Modeling.ItemView();
        iv.setPackageName("Class");
        iv.setSpecificModeling(new GJaxbNode.Modeling.ItemView.SpecificModeling());
        iv.getSpecificModeling().setNodeMetaModeling(new GJaxbNodeMetaModeling());
        iv.getSpecificModeling().getNodeMetaModeling().setModelingViewDefinition(new GJaxbModelingViewDefinition());
        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().setView(new GJaxbModelingViewDefinition.View());
        iv.setViewId("classview_" + UUID.randomUUID().toString());
        if (concept.isSetAbstract() && concept.isAbstract().booleanValue() && (!concept.isSetReadonly() || concept.isSetReadonly() && !concept.isReadonly().booleanValue())) {
            iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setUrl("/##application_name##/webjars/gind/rio/uml_model/images/model/nodes/class_abstract.png");
        } else if (concept.isSetAbstract() && concept.isAbstract().booleanValue() && concept.isSetReadonly() && concept.isReadonly().booleanValue()) {
            iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setUrl("/##application_name##/webjars/gind/rio/uml_model/images/model/nodes/class_abstract_readonly.png");
        } else if ((!concept.isSetAbstract() || concept.isSetAbstract() && !concept.isAbstract().booleanValue()) && (!concept.isSetReadonly() || concept.isSetReadonly() && !concept.isReadonly().booleanValue())) {
            iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setUrl("/##application_name##/webjars/gind/rio/uml_model/images/model/nodes/class.png");
        } else if ((!concept.isSetAbstract() || concept.isSetAbstract() && !concept.isAbstract().booleanValue()) && concept.isSetReadonly() && concept.isReadonly().booleanValue()) {
            iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setUrl("/##application_name##/webjars/gind/rio/uml_model/images/model/nodes/class_readonly.png");
        }
        GJaxbMagnets magnets = new GJaxbMagnets();
        magnets.setManagedPosition(GJaxbManagedPositionType.CROSS);
        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().setMagnets(magnets);
        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().setDimension(new GJaxbDimension());
        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setWidth(60.0f);
        iv.getSpecificModeling().getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setHeight(65.0f);
        iv.setPosition(new GJaxbPosition());
        nodeC.getModeling().getItemView().add(iv);
        GenericModelHelper.findProperty("meta_ns", nodeC.getProperty(), true).setValue(concept.getType().getNamespaceURI());
        GenericModelHelper.findProperty("meta_type", nodeC.getProperty(), true).setValue("CLASS");
        GenericModelHelper.findProperty("Domains", nodeC.getProperty(), true).setValue(StringUtils.join(concept.getDomains().iterator(), (String)","));
        ArrayList<List<GJaxbProperty>> packages_array = new ArrayList<List<GJaxbProperty>>();
        for (String packageName : concept.getPackages()) {
            ArrayList<GJaxbProperty> _package_row = new ArrayList<GJaxbProperty>();
            _package_row.add(GenericModelHelper.createProperty("package", packageName.toLowerCase()));
            packages_array.add(_package_row);
        }
        GenericModelHelper.findProperty("packages", nodeC.getProperty(), true).setValue(GenericModelHelper.convertTableToJSONArray(packages_array).toString());
        GenericModelHelper.findProperty(GJaxbEffectiveConceptType.BrokenRelations.class.getSimpleName(), nodeC.getProperty(), true).setValue(JSONJAXBContext.getInstance().marshallAnyElement((Object)concept.getBrokenRelations()));
        GenericModelHelper.findProperty("Description", nodeC.getProperty(), true).setValue(concept.getDescription());
        GenericModelHelper.findProperty("Extends", nodeC.getProperty(), true).setValue(StringUtils.join(concept.getExtends().iterator(), (String)","));
        ArrayList<List<GJaxbProperty>> attributes_array = new ArrayList<List<GJaxbProperty>>();
        ArrayList<List<GJaxbProperty>> inherit_attributes_array = new ArrayList<List<GJaxbProperty>>();
        for (GJaxbMetaProperty metaProp : concept.getMetaProperty()) {
            ArrayList<GJaxbProperty> attribute_row = new ArrayList<GJaxbProperty>();
            attribute_row.add(GenericModelHelper.createProperty("name", metaProp.getName()));
            attribute_row.add(GenericModelHelper.createProperty("type", metaProp.getType().toString().toLowerCase()));
            attribute_row.add(GenericModelHelper.createProperty("json_value", JSONJAXBContext.getInstance().marshallAnyElement((Object)metaProp).toString()));
            if (!metaProp.isSetInheritFromConcept() || metaProp.getInheritFromConcept().equals(concept.getType())) {
                attributes_array.add(attribute_row);
                continue;
            }
            attribute_row.add(GenericModelHelper.createProperty("from", metaProp.getInheritFromConcept().toString()));
            inherit_attributes_array.add(attribute_row);
        }
        GenericModelHelper.findProperty("attributes", nodeC.getProperty(), true).setValue(GenericModelHelper.convertTableToJSONArray(attributes_array).toString());
        GenericModelHelper.findProperty("inherited attributes", nodeC.getProperty(), true).setValue(GenericModelHelper.convertTableToJSONArray(inherit_attributes_array).toString());
        GenericModelHelper.findProperty(GJaxbNode.Modeling.class.getSimpleName(), nodeC.getProperty(), true).setValue(JSONJAXBContext.getInstance().marshallAnyElement((Object)concept.getNodeMetaModeling()));
        if (concept.getNodeMetaModeling() != null && concept.getNodeMetaModeling().getModelingViewDefinition() != null) {
            if (concept.getNodeMetaModeling().getModelingViewDefinition().getView() != null) {
                GenericModelHelper.findProperty("modeling png file", nodeC.getProperty(), true).setValue(concept.getNodeMetaModeling().getModelingViewDefinition().getView().getUrl());
                if (concept.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension() != null) {
                    GenericModelHelper.findProperty("default width", nodeC.getProperty(), true).setValue(String.valueOf(concept.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().getWidth()));
                    GenericModelHelper.findProperty("default height", nodeC.getProperty(), true).setValue(String.valueOf(concept.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().getHeight()));
                }
            }
            GenericModelHelper.findProperty("magnets position", nodeC.getProperty(), true).setValue(String.valueOf(concept.getNodeMetaModeling().getModelingViewDefinition().getMagnets().getManagedPosition().toString()));
        }
        GenericModelHelper.findProperty(GJaxbNode.Geolocation.class.getSimpleName(), nodeC.getProperty(), true).setValue(JSONJAXBContext.getInstance().marshallAnyElement((Object)concept.getNodeMetaGeolocation()));
        if (concept.getNodeMetaGeolocation() != null && concept.getNodeMetaGeolocation().isSetPoint()) {
            GenericModelHelper.findProperty("marker type", nodeC.getProperty(), true).setValue("point");
            GenericModelHelper.findProperty("marker png file", nodeC.getProperty(), true).setValue(concept.getNodeMetaGeolocation().getPoint().getImage());
        }
        return nodeC;
    }

    public GJaxbEffectiveConceptType convertNodeToConcept(GJaxbNode nodeC) throws Exception {
        if (!new QName("http://fr.emac.gind/uml-model", "Class").equals(nodeC.getType())) {
            throw new Exception("Impossible to convert this node into concept");
        }
        GJaxbEffectiveConceptType concept = new GJaxbEffectiveConceptType();
        concept.setType(new QName(GenericModelHelper.findProperty("meta_ns", nodeC.getProperty(), true).getValue(), GenericModelHelper.findProperty("name", nodeC.getProperty(), true).getValue()));
        concept.setAbstract(GenericModelHelper.findProperty("type", nodeC.getProperty(), true).getValue().equals("Abstract"));
        concept.setReadonly(GenericModelHelper.findProperty("readonly", nodeC.getProperty(), true).getValue().equals("true"));
        concept.setBrokenRelations((GJaxbEffectiveConceptType.BrokenRelations)((Object)JSONJAXBContext.getInstance().unmarshall("{ \"BrokenRelations\": " + GenericModelHelper.findProperty(GJaxbEffectiveConceptType.BrokenRelations.class.getSimpleName(), nodeC.getProperty(), true).getValue() + " }", GJaxbEffectiveConceptType.BrokenRelations.class)));
        concept.setDescription(GenericModelHelper.findProperty("Description", nodeC.getProperty(), true).getValue());
        if (GenericModelHelper.findProperty("Extends", nodeC.getProperty(), true).getValue() != null) {
            concept.getExtends().addAll(Arrays.asList(GenericModelHelper.findProperty("Extends", nodeC.getProperty(), true).getValue().split(",")).stream().map(e -> QName.valueOf(e)).collect(Collectors.toList()));
        }
        if (GenericModelHelper.findProperty("Domains", nodeC.getProperty(), true).getValue() != null) {
            concept.getDomains().addAll(Arrays.asList(GenericModelHelper.findProperty("Domains", nodeC.getProperty(), true).getValue().split(",")).stream().map(e -> e).collect(Collectors.toList()));
        }
        List<List<GJaxbProperty>> packages_array = GenericModelHelper.convertJSONArrayToTable(new JSONArray(GenericModelHelper.findProperty("packages", nodeC.getProperty(), true).getValue()));
        for (List<GJaxbProperty> list : packages_array) {
            concept.getPackages().add(GenericModelHelper.findProperty("package", list).getValue());
        }
        List<List<GJaxbProperty>> attributes_array = GenericModelHelper.convertJSONArrayToTable(new JSONArray(GenericModelHelper.findProperty("attributes", nodeC.getProperty(), true).getValue()));
        for (List<GJaxbProperty> list : attributes_array) {
            GJaxbProperty valuesProp;
            String json_value = GenericModelHelper.findProperty("json_value", list, true).getValue();
            GJaxbMetaProperty metaProp = null;
            metaProp = json_value != null ? (GJaxbMetaProperty)((Object)JSONJAXBContext.getInstance().unmarshall(json_value.replaceAll("/r", ""), GJaxbMetaProperty.class)) : new GJaxbMetaProperty();
            metaProp.setName(GenericModelHelper.findProperty("name", list, true).getValue());
            metaProp.setType(GJaxbFormtypeType.fromValue(GenericModelHelper.findProperty("type", list, true).getValue()));
            if (GJaxbFormtypeType.COMBOBOX.equals((Object)metaProp.getType()) && (valuesProp = GenericModelHelper.findProperty("values", list)) != null) {
                metaProp.setValues(new GJaxbValues());
                List<List<GJaxbProperty>> tableValuesProp = GenericModelHelper.convertJSONArrayToTable(new JSONArray(valuesProp.getValue()));
                List<GJaxbProperty> rowValueProp = tableValuesProp.get(0);
                GJaxbProperty valueType = GenericModelHelper.findProperty("valueType", rowValueProp);
                if (valueType.getValue().equals("fixedValues")) {
                    metaProp.getValues().setFixedValues(new GJaxbFixedValues());
                    GJaxbProperty fixedValues = GenericModelHelper.findProperty("fixedValues", rowValueProp);
                    List<List<GJaxbProperty>> tableFixedValuesProp = GenericModelHelper.convertJSONArrayToTable(new JSONArray(fixedValues.getValue()));
                    for (List<GJaxbProperty> rowFixedValuesProp : tableFixedValuesProp) {
                        String value = GenericModelHelper.findProperty("value", rowFixedValuesProp).getValue();
                        GJaxbFixedValues.Value v = new GJaxbFixedValues.Value();
                        v.setContent(value);
                        metaProp.getValues().getFixedValues().getValue().add(v);
                    }
                }
            }
            concept.getMetaProperty().add(metaProp);
        }
        List<List<GJaxbProperty>> list = GenericModelHelper.convertJSONArrayToTable(new JSONArray(GenericModelHelper.findProperty("inherited attributes", nodeC.getProperty(), true).getValue()));
        for (List<GJaxbProperty> attribute_row : list) {
            String json_value = GenericModelHelper.findProperty("json_value", attribute_row).getValue();
            GJaxbMetaProperty metaProp = null;
            metaProp = json_value != null ? (GJaxbMetaProperty)((Object)JSONJAXBContext.getInstance().unmarshall(json_value.replaceAll("/r", ""), GJaxbMetaProperty.class)) : new GJaxbMetaProperty();
            metaProp.setName(GenericModelHelper.findProperty("name", attribute_row, true).getValue());
            metaProp.setType(GJaxbFormtypeType.fromValue(GenericModelHelper.findProperty("type", attribute_row, true).getValue()));
            metaProp.setInheritFromConcept(QName.valueOf(GenericModelHelper.findProperty("from", attribute_row, true).getValue()));
            concept.getMetaProperty().add(metaProp);
        }
        concept.setEvents((GJaxbConceptType.Events)((Object)JSONJAXBContext.getInstance().unmarshall("{ \"events\": " + GenericModelHelper.findProperty(GJaxbConceptType.Events.class.getSimpleName(), nodeC.getProperty(), true).getValue() + " }", GJaxbConceptType.Events.class)));
        concept.setNodeMetaModeling((GJaxbNodeMetaModeling)((Object)JSONJAXBContext.getInstance().unmarshall("{ \"modeling\": " + GenericModelHelper.findProperty(GJaxbNode.Modeling.class.getSimpleName(), nodeC.getProperty(), true).getValue() + " }", GJaxbNodeMetaModeling.class)));
        if (GenericModelHelper.findProperty("modeling png file", nodeC.getProperty(), true) != null) {
            if (!concept.isSetNodeMetaModeling()) {
                concept.setNodeMetaModeling(new GJaxbNodeMetaModeling());
            }
            if (!concept.getNodeMetaModeling().isSetModelingViewDefinition()) {
                concept.getNodeMetaModeling().setModelingViewDefinition(new GJaxbModelingViewDefinition());
            }
            if (!concept.getNodeMetaModeling().getModelingViewDefinition().isSetView()) {
                concept.getNodeMetaModeling().getModelingViewDefinition().setView(new GJaxbModelingViewDefinition.View());
            }
            concept.getNodeMetaModeling().getModelingViewDefinition().getView().setUrl(GenericModelHelper.findProperty("modeling png file", nodeC.getProperty(), true).getValue());
        }
        if (GenericModelHelper.findProperty("default width", nodeC.getProperty(), true).getValue() != null) {
            if (!concept.getNodeMetaModeling().getModelingViewDefinition().getView().isSetDimension()) {
                concept.getNodeMetaModeling().getModelingViewDefinition().getView().setDimension(new GJaxbDimension());
            }
            concept.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setWidth((float)Double.parseDouble(GenericModelHelper.findProperty("default width", nodeC.getProperty(), true).getValue()));
        }
        if (GenericModelHelper.findProperty("default height", nodeC.getProperty(), true).getValue() != null) {
            if (!concept.getNodeMetaModeling().getModelingViewDefinition().getView().isSetDimension()) {
                concept.getNodeMetaModeling().getModelingViewDefinition().getView().setDimension(new GJaxbDimension());
            }
            concept.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setHeight((float)Double.parseDouble(GenericModelHelper.findProperty("default height", nodeC.getProperty(), true).getValue()));
        }
        if (GenericModelHelper.findProperty("magnets position", nodeC.getProperty(), true).getValue() != null) {
            if (!concept.getNodeMetaModeling().getModelingViewDefinition().isSetMagnets()) {
                concept.getNodeMetaModeling().getModelingViewDefinition().setMagnets(new GJaxbMagnets());
            }
            concept.getNodeMetaModeling().getModelingViewDefinition().getMagnets().setManagedPosition(GJaxbManagedPositionType.fromValue(GenericModelHelper.findProperty("magnets position", nodeC.getProperty(), true).getValue()));
        }
        concept.setNodeMetaGeolocation((GJaxbNodeMetaGeolocation)((Object)JSONJAXBContext.getInstance().unmarshall(GenericModelHelper.findProperty(GJaxbNode.Geolocation.class.getSimpleName(), nodeC.getProperty(), true).getValue(), GJaxbNodeMetaGeolocation.class)));
        if (GenericModelHelper.findProperty("marker type", nodeC.getProperty(), true).getValue() != null && GenericModelHelper.findProperty("marker type", nodeC.getProperty(), true).getValue().equals("point")) {
            if (!concept.isSetNodeMetaGeolocation()) {
                concept.setNodeMetaGeolocation(new GJaxbNodeMetaGeolocation());
            }
            if (!concept.getNodeMetaGeolocation().isSetPoint()) {
                concept.getNodeMetaGeolocation().setPoint(new GJaxbNodeMetaGeolocation.Point());
            }
            concept.getNodeMetaGeolocation().getPoint().setImage(GenericModelHelper.findProperty("marker png file", nodeC.getProperty(), true).getValue());
        }
        return concept;
    }

    public GJaxbNode convertRelationToNode(GJaxbRelation relation) throws Exception {
        GJaxbNode nodeR = new GJaxbNode();
        nodeR.setId("ASSOCIATION_" + String.valueOf(relation.getType()));
        nodeR.setType(new QName("http://fr.emac.gind/uml-model", "Association"));
        nodeR.getStatus().add(GJaxbStatusType.ACTIVE);
        GenericModelHelper.findProperty("name", nodeR.getProperty(), true).setValue(relation.getType().getLocalPart());
        GenericModelHelper.findProperty("meta_ns", nodeR.getProperty(), true).setValue(relation.getType().getNamespaceURI());
        GenericModelHelper.findProperty("meta_type", nodeR.getProperty(), true).setValue("ASSOCIATION");
        GenericModelHelper.findProperty("Description", nodeR.getProperty(), true).setValue(relation.getDescription());
        ArrayList<List<GJaxbProperty>> attributes_array = new ArrayList<List<GJaxbProperty>>();
        for (GJaxbMetaProperty metaProp : relation.getMetaProperty()) {
            ArrayList<GJaxbProperty> attribute_row = new ArrayList<GJaxbProperty>();
            attribute_row.add(GenericModelHelper.createProperty("name", metaProp.getName()));
            attribute_row.add(GenericModelHelper.createProperty("type", metaProp.getType().toString().toLowerCase()));
            attribute_row.add(GenericModelHelper.createProperty("json_value", JSONJAXBContext.getInstance().marshallAnyElement((Object)metaProp).toString()));
            attributes_array.add(attribute_row);
        }
        GenericModelHelper.findProperty("attributes", nodeR.getProperty(), true).setValue(GenericModelHelper.convertTableToJSONArray(attributes_array).toString());
        GenericModelHelper.findProperty(GJaxbEdgeMetaModeling.class.getSimpleName(), nodeR.getProperty(), true).setValue(JSONJAXBContext.getInstance().marshallAnyElement((Object)relation.getEdgeMetaModeling()));
        if (relation.getEdgeMetaModeling() != null && relation.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null) {
            if (relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getPathType() != null) {
                GenericModelHelper.findProperty("pathType", nodeR.getProperty(), true).setValue(relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getPathType().toString());
            }
            GenericModelHelper.findProperty("strokeColor", nodeR.getProperty(), true).setValue(String.valueOf(relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStrokeColor()));
            GenericModelHelper.findProperty("strokeWidth", nodeR.getProperty(), true).setValue(String.valueOf(relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStrokeWidth()));
            GenericModelHelper.findProperty("strokeDashArray", nodeR.getProperty(), true).setValue(String.valueOf(relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStrokeDashArray()));
            if (relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView() != null && relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().getShape() != null) {
                GenericModelHelper.findProperty("start connector shape", nodeR.getProperty(), true).setValue(String.valueOf(relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().getShape().toString()));
                GenericModelHelper.findProperty("start connector size", nodeR.getProperty(), true).setValue(String.valueOf(relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().getSize()));
                GenericModelHelper.findProperty("start connector background color", nodeR.getProperty(), true).setValue(String.valueOf(relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().getBackgroundColor()));
            }
            if (relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView() != null && relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView().getShape() != null) {
                GenericModelHelper.findProperty("end connector shape", nodeR.getProperty(), true).setValue(String.valueOf(relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView().getShape().toString()));
                GenericModelHelper.findProperty("end connector size", nodeR.getProperty(), true).setValue(String.valueOf(relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView().getSize()));
                GenericModelHelper.findProperty("end connector background color", nodeR.getProperty(), true).setValue(String.valueOf(relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView().getBackgroundColor()));
            }
        }
        return nodeR;
    }

    public GJaxbRelation convertNodeToRelation(GJaxbNode nodeR) throws Exception {
        if (!new QName("http://fr.emac.gind/uml-model", "Association").equals(nodeR.getType())) {
            throw new Exception("Impossible to convert this node into relation");
        }
        GJaxbRelation relation = new GJaxbRelation();
        relation.setType(new QName(GenericModelHelper.findProperty("meta_ns", nodeR.getProperty(), true).getValue(), GenericModelHelper.findProperty("name", nodeR.getProperty(), true).getValue()));
        relation.setDescription(GenericModelHelper.findProperty("Description", nodeR.getProperty(), true).getValue());
        List<List<GJaxbProperty>> attributes_array = GenericModelHelper.convertJSONArrayToTable(new JSONArray(GenericModelHelper.findProperty("attributes", nodeR.getProperty(), true).getValue()));
        for (List<GJaxbProperty> attribute_row : attributes_array) {
            String json_value = GenericModelHelper.findProperty("json_value", attribute_row).getValue();
            if (json_value == null) continue;
            relation.getMetaProperty().add((GJaxbMetaProperty)((Object)JSONJAXBContext.getInstance().unmarshall(json_value.replaceAll("/r", ""), GJaxbMetaProperty.class)));
        }
        relation.setEdgeMetaModeling((GJaxbEdgeMetaModeling)((Object)JSONJAXBContext.getInstance().unmarshall("{ \"modeling\": " + GenericModelHelper.findProperty(GJaxbEdgeMetaModeling.class.getSimpleName(), nodeR.getProperty(), true).getValue() + " }", GJaxbEdgeMetaModeling.class)));
        if (GenericModelHelper.findProperty("pathType", nodeR.getProperty(), true).getValue() != null) {
            if (!relation.isSetEdgeMetaModeling()) {
                relation.setEdgeMetaModeling(new GJaxbEdgeMetaModeling());
            }
            if (!relation.getEdgeMetaModeling().isSetModelingEdgeViewDefinition()) {
                relation.getEdgeMetaModeling().setModelingEdgeViewDefinition(new GJaxbModelingEdgeViewDefinition());
            }
            relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().setPathType(GJaxbPathEdgeType.fromValue(GenericModelHelper.findProperty("pathType", nodeR.getProperty(), true).getValue()));
        }
        if (GenericModelHelper.findProperty("strokeColor", nodeR.getProperty(), true).getValue() != null) {
            if (!relation.getEdgeMetaModeling().isSetModelingEdgeViewDefinition()) {
                relation.getEdgeMetaModeling().setModelingEdgeViewDefinition(new GJaxbModelingEdgeViewDefinition());
            }
            relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().setStrokeColor(GenericModelHelper.findProperty("strokeColor", nodeR.getProperty(), true).getValue());
        }
        if (GenericModelHelper.findProperty("strokeWidth", nodeR.getProperty(), true).getValue() != null) {
            String strokeWidthValueString;
            if (!relation.getEdgeMetaModeling().isSetModelingEdgeViewDefinition()) {
                relation.getEdgeMetaModeling().setModelingEdgeViewDefinition(new GJaxbModelingEdgeViewDefinition());
            }
            if ((strokeWidthValueString = GenericModelHelper.findProperty("strokeWidth", nodeR.getProperty(), true).getValue()) != null && !strokeWidthValueString.isBlank() && !strokeWidthValueString.equals("null")) {
                relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().setStrokeWidth(BigInteger.valueOf(Long.parseLong(strokeWidthValueString)));
            }
        }
        if (GenericModelHelper.findProperty("strokeDashArray", nodeR.getProperty(), true).getValue() != null) {
            if (!relation.getEdgeMetaModeling().isSetModelingEdgeViewDefinition()) {
                relation.getEdgeMetaModeling().setModelingEdgeViewDefinition(new GJaxbModelingEdgeViewDefinition());
            }
            relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().setStrokeDashArray(GenericModelHelper.findProperty("strokeDashArray", nodeR.getProperty(), true).getValue());
        }
        if (GenericModelHelper.findProperty("start connector shape", nodeR.getProperty(), true).getValue() != null) {
            if (!relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().isSetStartConnectorView()) {
                relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().setStartConnectorView(new GJaxbConnectorViewType());
            }
            relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().setShape(GJaxbShapeType.fromValue(GenericModelHelper.findProperty("start connector shape", nodeR.getProperty(), true).getValue()));
        }
        if (GenericModelHelper.findProperty("start connector size", nodeR.getProperty(), true).getValue() != null) {
            relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().setSize(Integer.parseInt(GenericModelHelper.findProperty("start connector size", nodeR.getProperty(), true).getValue()));
        }
        if (GenericModelHelper.findProperty("start connector background color", nodeR.getProperty(), true).getValue() != null) {
            relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().setBackgroundColor(GenericModelHelper.findProperty("start connector background color", nodeR.getProperty(), true).getValue());
        }
        if (GenericModelHelper.findProperty("end connector shape", nodeR.getProperty(), true).getValue() != null) {
            if (!relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().isSetEndConnectorView()) {
                relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().setEndConnectorView(new GJaxbConnectorViewType());
            }
            relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView().setShape(GJaxbShapeType.fromValue(GenericModelHelper.findProperty("end connector shape", nodeR.getProperty(), true).getValue()));
        }
        if (GenericModelHelper.findProperty("end connector size", nodeR.getProperty(), true).getValue() != null) {
            relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView().setSize(Integer.parseInt(GenericModelHelper.findProperty("end connector size", nodeR.getProperty(), true).getValue()));
        }
        if (GenericModelHelper.findProperty("end connector background color", nodeR.getProperty(), true).getValue() != null) {
            relation.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView().setBackgroundColor(GenericModelHelper.findProperty("end connector background color", nodeR.getProperty(), true).getValue());
        }
        return relation;
    }

    public GJaxbEdge convertConnexionRuleToEdge(GJaxbConnectionRule rule) throws Exception {
        GJaxbEdge edge = new GJaxbEdge();
        edge.setId("RULE_" + String.valueOf(rule.getRelationType()) + "_" + String.valueOf(rule.getFrom()) + "_" + String.valueOf(rule.getTo()));
        if (GJaxbRelationModeType.ASSOCIATION.equals((Object)rule.getMode())) {
            edge.setType(new QName("http://fr.emac.gind/uml-model", "Association"));
            GenericModelHelper.findProperty("association type", edge.getProperty(), true).setValue(rule.getRelationType().getLocalPart().toString());
        } else if (GJaxbRelationModeType.COMPOSITION.equals((Object)rule.getMode())) {
            edge.setType(new QName("http://fr.emac.gind/uml-model", "Compose"));
            GenericModelHelper.findProperty("association type", edge.getProperty(), true).setValue(edge.getType().toString());
        } else if (GJaxbRelationModeType.INHERITANCE.equals((Object)rule.getMode())) {
            edge.setType(new QName("http://fr.emac.gind/uml-model", "Inherit"));
            GenericModelHelper.findProperty("association type", edge.getProperty(), true).setValue(edge.getType().toString());
        } else {
            throw new Exception("Relation type not implemented !!!");
        }
        GenericModelHelper.findProperty("meta_type", edge.getProperty(), true).setValue("RULE");
        GenericModelHelper.findProperty("meta_ns", edge.getProperty(), true).setValue(rule.getRelationType().getNamespaceURI());
        GenericModelHelper.findProperty("CardinalityRule", edge.getProperty(), true).setValue(JSONJAXBContext.getInstance().marshallAnyElement((Object)rule.getCardinalityRule()));
        GenericModelHelper.findProperty("ExcludeOnFrom", edge.getProperty(), true).setValue(StringUtils.join(rule.getExcludeOnFrom().iterator(), (String)","));
        GenericModelHelper.findProperty("ExcludeOnTo", edge.getProperty(), true).setValue(StringUtils.join(rule.getExcludeOnTo().iterator(), (String)","));
        GenericModelHelper.findProperty("from", edge.getProperty(), true).setValue(rule.getFrom().toString());
        GenericModelHelper.findProperty("to", edge.getProperty(), true).setValue(rule.getTo().toString());
        GenericModelHelper.findProperty("mode", edge.getProperty(), true).setValue(rule.getMode().toString());
        GenericModelHelper.findProperty(GJaxbConnectionRule.Modeling.class.getSimpleName(), edge.getProperty(), true).setValue(JSONJAXBContext.getInstance().marshallAnyElement((Object)rule.getModeling()));
        edge.setSource(new GJaxbNode());
        edge.getSource().setId("CLASS_" + rule.getFrom().getNamespaceURI().hashCode() + "_" + rule.getFrom().getLocalPart());
        edge.setTarget(new GJaxbNode());
        edge.getTarget().setId("CLASS_" + rule.getTo().getNamespaceURI().hashCode() + "_" + rule.getTo().getLocalPart());
        return edge;
    }

    public GJaxbConnectionRule convertEdgeToConnexionRule(GJaxbEdge edge) throws Exception {
        GJaxbConnectionRule rule = new GJaxbConnectionRule();
        rule.setRelationType(new QName(GenericModelHelper.findProperty("meta_ns", edge.getProperty(), true).getValue(), GenericModelHelper.findProperty("association type", edge.getProperty(), true).getValue()));
        rule.setCardinalityRule((GJaxbCardinalityRule)((Object)JSONJAXBContext.getInstance().unmarshall("{ \"CardinalityRule\": " + GenericModelHelper.findProperty("CardinalityRule", edge.getProperty(), true).getValue() + " }", GJaxbCardinalityRule.class)));
        if (GenericModelHelper.findProperty("ExcludeOnFrom", edge.getProperty(), true).getValue() != null) {
            rule.getExcludeOnFrom().addAll(Arrays.asList(GenericModelHelper.findProperty("ExcludeOnFrom", edge.getProperty(), true).getValue().split(",")).stream().map(e -> QName.valueOf(e)).collect(Collectors.toList()));
        }
        if (GenericModelHelper.findProperty("ExcludeOnTo", edge.getProperty(), true).getValue() != null) {
            rule.getExcludeOnTo().addAll(Arrays.asList(GenericModelHelper.findProperty("ExcludeOnTo", edge.getProperty(), true).getValue().split(",")).stream().map(e -> QName.valueOf(e)).collect(Collectors.toList()));
        }
        if (GenericModelHelper.findProperty("from", edge.getProperty(), true).getValue() != null) {
            rule.setFrom(QName.valueOf(GenericModelHelper.findProperty("from", edge.getProperty(), true).getValue()));
        }
        if (GenericModelHelper.findProperty("to", edge.getProperty(), true).getValue() != null) {
            rule.setTo(QName.valueOf(GenericModelHelper.findProperty("to", edge.getProperty(), true).getValue()));
        }
        rule.setMode(GJaxbRelationModeType.fromValue(GenericModelHelper.findProperty("mode", edge.getProperty(), true).getValue()));
        rule.setModeling((GJaxbConnectionRule.Modeling)((Object)JSONJAXBContext.getInstance().unmarshall("{ \"modeling\": " + GenericModelHelper.findProperty(GJaxbConnectionRule.Modeling.class.getSimpleName(), edge.getProperty(), true).getValue() + " }", GJaxbConnectionRule.Modeling.class)));
        return rule;
    }

    public GJaxbNode convertEffectivePackageToNode(GJaxbEffectivePackage _package, String domain) throws Exception {
        GJaxbNode nodeP = new GJaxbNode();
        nodeP.setId("PACKAGE_" + _package.getName());
        nodeP.setType(new QName("http://fr.emac.gind/uml-model", "Package"));
        nodeP.getStatus().add(GJaxbStatusType.ACTIVE);
        GenericModelHelper.findProperty("name", nodeP.getProperty(), true).setValue(_package.getName());
        GenericModelHelper.findProperty("meta_type", nodeP.getProperty(), true).setValue("PACKAGE");
        GenericModelHelper.findProperty("Domains", nodeP.getProperty(), true).setValue(domain);
        GenericModelHelper.findProperty(GJaxbGenericModel.GlobalProperties.class.getSimpleName(), nodeP.getProperty(), true).setValue(JSONJAXBContext.getInstance().marshallAnyElement((Object)_package.getGlobalProperties()));
        ArrayList<List<GJaxbProperty>> packages_array = new ArrayList<List<GJaxbProperty>>();
        for (QName qName : _package.getPackagesQName()) {
            ArrayList<GJaxbProperty> _package_row = new ArrayList<GJaxbProperty>();
            _package_row.add(GenericModelHelper.createProperty("package", qName.toString()));
            packages_array.add(_package_row);
        }
        GenericModelHelper.findProperty("packages", nodeP.getProperty(), true).setValue(GenericModelHelper.convertTableToJSONArray(packages_array).toString());
        GenericModelHelper.findProperty(GJaxbModelingType.class.getSimpleName(), nodeP.getProperty(), true).setValue(JSONJAXBContext.getInstance().marshallAnyElement((Object)_package.getModeling()));
        ArrayList<List<GJaxbProperty>> contained_classes_array = new ArrayList<List<GJaxbProperty>>();
        if (_package.getRules() != null && _package.getRules().getContainmentRule() != null) {
            for (GJaxbContainmentRule.Contain _contain : _package.getRules().getContainmentRule().getContain()) {
                ArrayList<GJaxbProperty> contained_classes_row = new ArrayList<GJaxbProperty>();
                if (_contain.getType() != null) {
                    contained_classes_row.add(GenericModelHelper.createProperty("name", _contain.getType().toString()));
                }
                if (_contain.getId() != null) {
                    contained_classes_row.add(GenericModelHelper.createProperty("id", _contain.getId()));
                }
                contained_classes_array.add(contained_classes_row);
            }
        }
        GenericModelHelper.findProperty("contained classes", nodeP.getProperty(), true).setValue(GenericModelHelper.convertTableToJSONArray(contained_classes_array).toString());
        JSONArray jSONArray = new JSONArray();
        for (GJaxbImportedNode imptNode : _package.getImportedNode()) {
            jSONArray.put((Object)JSONJAXBContext.getInstance().marshallAnyElement((Object)imptNode));
        }
        GenericModelHelper.findProperty(GJaxbImportedNode.class.getSimpleName(), nodeP.getProperty(), true).setValue(jSONArray.toString());
        return nodeP;
    }

    public GJaxbEffectivePackage convertNodeToEffectivePackage(GJaxbNode nodeP) throws Exception {
        if (!new QName("http://fr.emac.gind/uml-model", "Package").equals(nodeP.getType())) {
            throw new Exception("Impossible to convert this node into package");
        }
        GJaxbEffectivePackage _package = new GJaxbEffectivePackage();
        _package.setName(GenericModelHelper.findProperty("name", nodeP.getProperty(), true).getValue());
        _package.setGlobalProperties((GJaxbEffectivePackage.GlobalProperties)((Object)JSONJAXBContext.getInstance().unmarshall("{ \"GlobalProperties\": " + GenericModelHelper.findProperty(GJaxbGenericModel.GlobalProperties.class.getSimpleName(), nodeP.getProperty(), true).getValue() + " }", GJaxbEffectivePackage.GlobalProperties.class)));
        _package.getPackagesQName().addAll(Arrays.asList(GenericModelHelper.findProperty("packages", nodeP.getProperty(), true).getValue().split(",")).stream().map(e -> QName.valueOf(e)).collect(Collectors.toList()));
        List<List<GJaxbProperty>> packages_array = GenericModelHelper.convertJSONArrayToTable(new JSONArray(GenericModelHelper.findProperty("packages", nodeP.getProperty(), true).getValue()));
        for (List<GJaxbProperty> package_row : packages_array) {
            _package.getPackagesQName().add(QName.valueOf(GenericModelHelper.findProperty("package", package_row).getValue()));
        }
        _package.setModeling((GJaxbModelingType)((Object)JSONJAXBContext.getInstance().unmarshall("{ \"modeling\": " + GenericModelHelper.findProperty(GJaxbModelingType.class.getSimpleName(), nodeP.getProperty(), true).getValue() + " }", GJaxbModelingType.class)));
        _package.setRules(new GJaxbEffectivePackage.Rules());
        GJaxbContainmentRule cr = new GJaxbContainmentRule();
        _package.getRules().setContainmentRule(cr);
        List<List<GJaxbProperty>> contained_classes_array = GenericModelHelper.convertJSONArrayToTable(new JSONArray(GenericModelHelper.findProperty("contained classes", nodeP.getProperty(), true).getValue()));
        for (List<GJaxbProperty> attribute_row : contained_classes_array) {
            GJaxbContainmentRule.Contain _contain = new GJaxbContainmentRule.Contain();
            if (GenericModelHelper.findProperty("name", attribute_row) != null) {
                String qname = GenericModelHelper.findProperty("name", attribute_row).getValue();
                _contain.setType(QName.valueOf(qname));
            }
            if (GenericModelHelper.findProperty("id", attribute_row) != null) {
                String id = GenericModelHelper.findProperty("id", attribute_row).getValue();
                _contain.setId(id);
            }
            cr.getContain().add(_contain);
        }
        JSONArray imptNodeArray = new JSONArray(GenericModelHelper.findProperty(GJaxbImportedNode.class.getSimpleName(), nodeP.getProperty(), true).getValue());
        for (int i = 0; i < imptNodeArray.length(); ++i) {
            _package.getImportedNode().add((GJaxbImportedNode)((Object)JSONJAXBContext.getInstance().unmarshall(imptNodeArray.getString(i).trim().replace("/r", ""), GJaxbImportedNode.class)));
        }
        return _package;
    }

    public GJaxbGenericModel convertEffectiveMetaModelToGenericModel(GJaxbEffectiveMetaModel effMetaModel) throws Exception {
        GJaxbGenericModel model = new GJaxbGenericModel();
        for (GJaxbEffectiveConceptType concept : effMetaModel.getEffectiveConcept()) {
            model.getNode().add(this.convertConceptToNode(concept));
        }
        for (GJaxbRelation relation : effMetaModel.getRelation()) {
            model.getNode().add(this.convertRelationToNode(relation));
        }
        for (GJaxbConnectionRule rule : effMetaModel.getRules().getConnectionRules().getConnectionRule()) {
            model.getEdge().add(this.convertConnexionRuleToEdge(rule));
        }
        return model;
    }

    public GJaxbEffectiveMetaModel convertGenericModelToEffectiveMetaModel(GJaxbGenericModel model) throws Exception {
        GJaxbEffectiveMetaModel effMetaModel = new GJaxbEffectiveMetaModel();
        for (GJaxbNode node : model.getNode()) {
            if (new QName("http://fr.emac.gind/uml-model", "Class").equals(node.getType())) {
                GJaxbEffectiveConceptType c = this.convertNodeToConcept(node);
                effMetaModel.getEffectiveConcept().add(c);
                continue;
            }
            if (!new QName("http://fr.emac.gind/uml-model", "Association").equals(node.getType())) continue;
            GJaxbRelation r = this.convertNodeToRelation(node);
            effMetaModel.getRelation().add(r);
        }
        effMetaModel.setRules(new GJaxbRules());
        effMetaModel.getRules().setConnectionRules(new GJaxbConnectionRules());
        for (GJaxbEdge edge : model.getEdge()) {
            effMetaModel.getRules().getConnectionRules().getConnectionRule().add(this.convertEdgeToConnexionRule(edge));
        }
        return effMetaModel;
    }

    public GJaxbGenericModel convertEffectiveDomainToGenericModel(GJaxbEffectiveDomain effDomain) throws Exception {
        GJaxbGenericModel model = new GJaxbGenericModel();
        String domainName = effDomain.getName();
        for (GJaxbEffectivePackage effPackage : effDomain.getEffectivePackage()) {
            String effPackageName = effPackage.getName();
            GJaxbNode _package = this.convertEffectivePackageToNode(effPackage, domainName);
            model.getNode().add(_package);
            GJaxbEffectiveMetaModel effMM = effPackage.getEffectiveMetaModelOfPackage().getEffectiveMetaModel();
            effMM.getEffectiveConcept().forEach(ec -> {
                if (!ec.getDomains().contains(domainName)) {
                    ec.getDomains().add(domainName);
                }
                if (!ec.getPackages().contains(effPackageName)) {
                    ec.getPackages().add(effPackageName);
                }
                ListUtil.deleteDuplicate(ec.getDomains());
                ListUtil.deleteDuplicate(ec.getPackages());
            });
            effMM.getRelation().forEach(r -> {
                if (!r.getDomains().contains(domainName)) {
                    r.getDomains().add(domainName);
                }
                if (!r.getPackages().contains(effPackageName)) {
                    r.getPackages().add(effPackageName);
                }
                ListUtil.deleteDuplicate(r.getDomains());
                ListUtil.deleteDuplicate(r.getPackages());
            });
            effMM.getRules().getConnectionRules().getConnectionRule().forEach(r -> {
                if (!r.getDomains().contains(domainName)) {
                    r.getDomains().add(domainName);
                }
                if (!r.getPackages().contains(effPackageName)) {
                    r.getPackages().add(effPackageName);
                }
                ListUtil.deleteDuplicate(r.getDomains());
                ListUtil.deleteDuplicate(r.getPackages());
            });
            GJaxbGenericModel modelPackage = this.convertEffectiveMetaModelToGenericModel(effMM);
            for (GJaxbNode node : modelPackage.getNode()) {
                GJaxbNode existingNode = GenericModelHelper.findNodeById(node.getId(), model.getNode());
                if (existingNode == null) {
                    model.getNode().add(node);
                    continue;
                }
                GJaxbProperty packagesProp = GenericModelHelper.findProperty("packages", existingNode.getProperty(), true);
                if (packagesProp.getValue() != null && RegExpHelper.toRegexFriendlyName((String)packagesProp.getValue()).contains(RegExpHelper.toRegexFriendlyName((String)effPackageName))) continue;
                ArrayList<List<GJaxbProperty>> packages_array = new ArrayList<List<GJaxbProperty>>();
                if (packagesProp.getValue() != null) {
                    GenericModelHelper.convertJSONArrayToTable(new JSONArray(GenericModelHelper.findProperty("packages", existingNode.getProperty(), true).getValue()));
                }
                ArrayList<GJaxbProperty> _package_row = new ArrayList<GJaxbProperty>();
                _package_row.add(GenericModelHelper.createProperty("package", effPackageName));
                packages_array.add(_package_row);
                GenericModelHelper.findProperty("packages", existingNode.getProperty(), true).setValue(GenericModelHelper.convertTableToJSONArray(packages_array).toString());
            }
            for (GJaxbEdge edge : modelPackage.getEdge()) {
                GJaxbEdge existingEdge = GenericModelHelper.findEdgeById(edge.getId(), model.getEdge());
                if (existingEdge != null) continue;
                model.getEdge().add(edge);
            }
        }
        return model;
    }

    public GJaxbEffectiveDomain convertGenericModelToEffectiveDomain(GJaxbGenericModel model) throws Exception {
        GJaxbEffectiveDomain effDomain = new GJaxbEffectiveDomain();
        HashMap<String, GJaxbEffectivePackage> effPackages = new HashMap<String, GJaxbEffectivePackage>();
        List nodePackages = model.getNode().stream().filter(n -> "PACKAGE".equals(GenericModelHelper.findProperty("meta_type", n.getProperty(), true).getValue())).collect(Collectors.toList());
        model.getNode().removeAll(nodePackages);
        for (Object _package : nodePackages) {
            GJaxbEffectivePackage effPack = this.convertNodeToEffectivePackage((GJaxbNode)((Object)_package));
            effPack.setEffectiveMetaModelOfPackage(new GJaxbEffectivePackage.EffectiveMetaModelOfPackage());
            effPack.getEffectiveMetaModelOfPackage().setEffectiveMetaModel(new GJaxbEffectiveMetaModel());
            effDomain.getEffectivePackage().add(effPack);
            effPackages.put(RegExpHelper.toRegexFriendlyName((String)effPack.getName()), effPack);
        }
        GJaxbEffectiveMetaModel effMetaModel = this.convertGenericModelToEffectiveMetaModel(model);
        for (GJaxbEffectiveConceptType effConcept : effMetaModel.getEffectiveConcept()) {
            if (effConcept.getPackages() == null || effConcept.getPackages().size() <= 0) continue;
            for (String packageName : effConcept.getPackages()) {
                GJaxbEffectivePackage effPack = (GJaxbEffectivePackage)((Object)effPackages.get(RegExpHelper.toRegexFriendlyName((String)packageName.toLowerCase().trim())));
                if (effPack != null) {
                    effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getEffectiveConcept().add(effConcept);
                }
                if (effPack.getImportedNode().stream().filter(in -> in.getRef().equals(effConcept.getType())).count() != 0L) continue;
                GJaxbImportedNode in2 = new GJaxbImportedNode();
                in2.setRef(effConcept.getType());
                effPack.getImportedNode().add(in2);
                GJaxbContainmentRule.Contain c = new GJaxbContainmentRule.Contain();
                c.setType(effConcept.getType());
                effPack.getRules().getContainmentRule().getContain().add(c);
            }
        }
        for (GJaxbConnectionRule rule : effMetaModel.getRules().getConnectionRules().getConnectionRule()) {
            QName sourceNodeType = rule.getFrom();
            QName targetNodeType = rule.getTo();
            GJaxbEffectiveConceptType conceptSource = EffectiveMetaModelHelper.getConceptByType(effMetaModel, sourceNodeType);
            GJaxbEffectiveConceptType conceptTarget = EffectiveMetaModelHelper.getConceptByType(effMetaModel, targetNodeType);
            if (conceptSource == null) continue;
            for (GJaxbEffectivePackage effPack : effPackages.values()) {
                if (conceptSource.getPackages().stream().filter(p -> RegExpHelper.toRegexFriendlyName((String)p.trim()).equals(RegExpHelper.toRegexFriendlyName((String)effPack.getName().trim()))).count() <= 0L || conceptTarget.getPackages().stream().filter(p -> RegExpHelper.toRegexFriendlyName((String)p.trim()).equals(RegExpHelper.toRegexFriendlyName((String)effPack.getName().trim()))).count() <= 0L) continue;
                if (!effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().isSetRules()) {
                    effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().setRules(new GJaxbRules());
                }
                if (!effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRules().isSetConnectionRules()) {
                    effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRules().setConnectionRules(new GJaxbConnectionRules());
                }
                effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRules().getConnectionRules().getConnectionRule().add(rule);
            }
        }
        for (GJaxbRelation relation : effMetaModel.getRelation()) {
            for (GJaxbEffectivePackage effPack : effPackages.values()) {
                if (!effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().isSetRules()) {
                    effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().setRules(new GJaxbRules());
                }
                if (!effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRules().isSetConnectionRules()) {
                    effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRules().setConnectionRules(new GJaxbConnectionRules());
                }
                if (effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRules().getConnectionRules().getConnectionRule().stream().filter(cr -> cr.getRelationType().equals(relation.getType())).count() <= 0L) continue;
                effPack.getEffectiveMetaModelOfPackage().getEffectiveMetaModel().getRelation().add(relation);
            }
        }
        effDomain.setGlobalEffectiveMetaModel(new GJaxbEffectiveDomain.GlobalEffectiveMetaModel());
        effDomain.getGlobalEffectiveMetaModel().setEffectiveMetaModel(EffectiveMetaModelHelper.mergeEffectiveMetaModel(effDomain.getEffectivePackage().stream().map(ep -> ep.getEffectiveMetaModelOfPackage().getEffectiveMetaModel()).collect(Collectors.toList())));
        boolean isCollaborativeDomain = false;
        for (GJaxbEffectivePackage effP : effDomain.getEffectivePackage()) {
            if (!effP.getName().toLowerCase().equals("collaborative process")) continue;
            isCollaborativeDomain = true;
        }
        effDomain.setIsCollaborativeDomain(isCollaborativeDomain);
        return effDomain;
    }
}

