/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.models.generic.modeler.plugins;

import fr.emac.gind.models.generic.modeler.plugins.AbstractMetaModelPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public class MetaModelPluginsManager {
    private ServiceLoader<AbstractMetaModelPlugin> ucLoader = ServiceLoader.load(AbstractMetaModelPlugin.class);
    private List<AbstractMetaModelPlugin> plugins = new ArrayList<AbstractMetaModelPlugin>();
    private static MetaModelPluginsManager INSTANCE = null;

    private MetaModelPluginsManager() throws Exception {
        this.initPlugins();
    }

    public static MetaModelPluginsManager getInstance() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new MetaModelPluginsManager();
        }
        return INSTANCE;
    }

    private void initPlugins() throws Exception {
        this.plugins.clear();
        this.ucLoader.reload();
        for (AbstractMetaModelPlugin uc : this.ucLoader) {
            this.plugins.add(uc);
        }
    }

    public List<AbstractMetaModelPlugin> getPlugins() {
        return this.plugins;
    }

    public AbstractMetaModelPlugin findPluginByClass(Class<?> clazz) {
        for (AbstractMetaModelPlugin plug : this.getPlugins()) {
            if (!plug.getClass().getName().equals(clazz.getName())) continue;
            return plug;
        }
        return null;
    }
}

