/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.models.generic.modeler.utils.checker;

import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.modeler.genericmodel.GJaxbGenericModel;
import fr.emac.gind.models.generic.modeler.utils.checker.ModelAnomaly;
import fr.emac.gind.models.generic.modeler.utils.checker.anomalies.SeveralSameEdgesDetected;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelChecker {
    public Map<File, List<ModelAnomaly>> checkDirectory(File dir) throws Exception {
        HashMap<File, List<ModelAnomaly>> map = new HashMap<File, List<ModelAnomaly>>();
        if (dir.isDirectory()) {
            File[] files;
            for (File file : files = FileUtil.getAllFiles((File)dir)) {
                List<ModelAnomaly> anomaliesOnFile;
                if (!file.isFile() || !FileUtil.getExtension((String)file.getName()).toLowerCase().contains("xml") || (anomaliesOnFile = this.checkModel(file)).isEmpty()) continue;
                map.put(file, this.checkModel(file));
            }
        }
        return map;
    }

    public List<ModelAnomaly> checkModel(File urlModel) throws Exception {
        ArrayList<ModelAnomaly> res = new ArrayList<ModelAnomaly>();
        GJaxbGenericModel model = (GJaxbGenericModel)XMLJAXBContext.getInstance().unmarshallDocument(urlModel.toURI().toURL(), GJaxbGenericModel.class);
        SeveralSameEdgesDetected severalSameEdgesDetectedAnomaly = new SeveralSameEdgesDetected(model);
        boolean check = severalSameEdgesDetectedAnomaly.check();
        if (!check) {
            res.add(severalSameEdgesDetectedAnomaly);
        }
        return res;
    }

    public void repairAllAnomalies(Map<File, List<ModelAnomaly>> mapAnomalies) throws Exception {
        for (Map.Entry<File, List<ModelAnomaly>> entry : mapAnomalies.entrySet()) {
            System.out.println("Repair " + entry.getKey().getName() + ": ");
            for (ModelAnomaly anomaly : entry.getValue()) {
                this.repairAnomaly(anomaly);
            }
        }
    }

    public void repairAnomaly(ModelAnomaly anomaly) throws Exception {
        System.out.println("\t repair anomaly: " + anomaly.getClass().getSimpleName());
        anomaly.repair();
    }
}

