/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.models.generic.modeler.utils.svg;

import fr.emac.gind.modeler.metamodel.GJaxbConceptType;
import fr.emac.gind.modeler.metamodel.GJaxbConnectorViewType;
import fr.emac.gind.modeler.metamodel.GJaxbRelation;
import fr.emac.gind.modeler.metamodel.GJaxbShapeType;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGGenerator {
    private static final int LINE_SIZE = 100;
    private static Logger LOG = LoggerFactory.getLogger(SVGGenerator.class);

    public Document createSVGFromEdge(GJaxbRelation edge) {
        LOG.debug("Create SVG Icon for:" + String.valueOf(edge.getType()));
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document doc = impl.createDocument(svgNS, "svg", null);
        Element svgRoot = doc.getDocumentElement();
        int width = this.calculWidth(edge);
        int height = this.calculHeight(edge);
        svgRoot.setAttributeNS(null, "width", String.valueOf(width + 10));
        svgRoot.setAttributeNS(null, "height", String.valueOf(width + 10));
        int y = this.findY(edge);
        int x = this.findX(edge);
        Element rectangle = doc.createElementNS(svgNS, "rect");
        rectangle.setAttributeNS(null, "x", "0");
        rectangle.setAttributeNS(null, "y", "0");
        rectangle.setAttributeNS(null, "width", String.valueOf(width));
        rectangle.setAttributeNS(null, "height", String.valueOf(width));
        rectangle.setAttributeNS(null, "style", "fill:white");
        svgRoot.appendChild(rectangle);
        Element line = doc.createElementNS(svgNS, "line");
        line.setAttributeNS(null, "x1", String.valueOf(edge.getEdgeMetaModeling() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView() != null ? edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().getSize() + 5 : 5));
        line.setAttributeNS(null, "y1", String.valueOf(y + width / 2));
        line.setAttributeNS(null, "x2", String.valueOf(105));
        line.setAttributeNS(null, "y2", String.valueOf(y + width / 2));
        line.setAttributeNS(null, "style", this.generateStrokeAttributes(edge));
        if (edge.getEdgeMetaModeling() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStrokeDashArray() != null) {
            line.setAttributeNS(null, "stroke-dasharray", edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStrokeDashArray().replace("[", "").replace("]", ""));
        }
        svgRoot.appendChild(line);
        if (edge.getEdgeMetaModeling() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView() != null) {
            this.createConnector(doc, svgNS, svgRoot, edge, edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView(), x + 5, y + width / 2, ConnectorType.START);
        }
        if (edge.getEdgeMetaModeling() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView() != null) {
            this.createConnector(doc, svgNS, svgRoot, edge, edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView(), 100 - edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView().getSize() + 5, y + width / 2, ConnectorType.END);
        }
        SVGGraphics2D g = new SVGGraphics2D(doc);
        g.setSVGCanvasSize(new Dimension(width + 10, width + 10));
        Element root = doc.getDocumentElement();
        g.getRoot(root);
        return doc;
    }

    private int findX(GJaxbRelation edge) {
        int x = 0;
        if (edge.getEdgeMetaModeling() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().getShape() == GJaxbShapeType.CIRCLE) {
            x = edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().getSize() / 2;
        }
        return x;
    }

    private int calculHeight(GJaxbRelation edge) {
        int height;
        int n = height = edge.getEdgeMetaModeling() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStrokeWidth() != null ? edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStrokeWidth().intValue() : 1;
        if (edge.getEdgeMetaModeling() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView() != null) {
            height = edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().getSize() > edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView().getSize() ? edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().getSize() : edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView().getSize();
        } else if (edge.getEdgeMetaModeling() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView() != null) {
            height = edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().getSize();
        } else if (edge.getEdgeMetaModeling() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView() != null) {
            height = edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView().getSize();
        }
        return height;
    }

    private int calculWidth(GJaxbRelation edge) {
        int sizeStart = edge.getEdgeMetaModeling() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView() != null ? edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().getSize() : 0;
        int sizeEnd = edge.getEdgeMetaModeling() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView() != null ? edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView().getSize() : 0;
        return sizeStart + 100 + sizeEnd;
    }

    private void createConnector(Document doc, String svgNS, Element svgRoot, GJaxbRelation edge, GJaxbConnectorViewType connectorView, int x, int y, ConnectorType type) {
        if (connectorView != null) {
            Element connector = null;
            if (connectorView.getShape() == GJaxbShapeType.CIRCLE) {
                connector = doc.createElementNS(svgNS, "circle");
                connector.setAttributeNS(null, "r", String.valueOf(connectorView.getSize()));
                connector.setAttributeNS(null, "cx", String.valueOf(x));
                connector.setAttributeNS(null, "cy", String.valueOf(y));
            } else if (connectorView.getShape() == GJaxbShapeType.SQUARE) {
                connector = doc.createElementNS(svgNS, "rect");
                connector.setAttributeNS(null, "width", String.valueOf(connectorView.getSize() * 2));
                connector.setAttributeNS(null, "height", String.valueOf(connectorView.getSize() * 2));
                connector.setAttributeNS(null, "x", String.valueOf(x));
                connector.setAttributeNS(null, "y", String.valueOf(y - connectorView.getSize() / 2));
            } else if (connectorView.getShape() == GJaxbShapeType.TRIANGLE) {
                connector = doc.createElementNS(svgNS, "polygon");
                if (type == ConnectorType.START) {
                    connector.setAttributeNS(null, "points", String.valueOf(x + " " + y + " " + (x + connectorView.getSize() * 2) + " " + (y - connectorView.getSize()) + " " + (x + connectorView.getSize() * 2) + " " + (y + connectorView.getSize()) + " " + x + " " + y));
                } else {
                    connector.setAttributeNS(null, "points", String.valueOf(x + " " + (y + connectorView.getSize()) + " " + (x + connectorView.getSize() * 2) + " " + y + " " + x + " " + (y - connectorView.getSize()) + " " + x + " " + (y + connectorView.getSize())));
                }
            }
            connector.setAttributeNS(null, "fill", connectorView.getBackgroundColor());
            svgRoot.appendChild(connector);
        }
    }

    private String generateStrokeAttributes(GJaxbRelation edge) {
        Object style = "";
        if (edge.getEdgeMetaModeling() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStrokeColor() != null) {
            style = "stroke:" + edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStrokeColor();
        }
        if (edge.getEdgeMetaModeling() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStrokeWidth() != null) {
            style = (String)style + ";stroke-width:" + String.valueOf(edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStrokeWidth().intValue() * 2);
        }
        return style;
    }

    private int findY(GJaxbRelation edge) {
        int y = 0;
        if (edge.getEdgeMetaModeling() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView() != null) {
            y = edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().getSize() > edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView().getSize() ? edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().getSize() : edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView().getSize();
        } else if (edge.getEdgeMetaModeling() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView() != null) {
            y = edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getStartConnectorView().getSize();
        } else if (edge.getEdgeMetaModeling() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition() != null && edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView() != null) {
            y = edge.getEdgeMetaModeling().getModelingEdgeViewDefinition().getEndConnectorView().getSize();
        }
        return y / 2;
    }

    public static void convertSVGToPNG(File svgFile, File pngFile) throws Exception {
        String svg_URI_input = svgFile.toString();
        String png_URI_output = pngFile.toString();
        TranscoderInput input_svg_image = new TranscoderInput(svgFile.toURI().toURL().openStream());
        FileOutputStream png_ostream = new FileOutputStream(png_URI_output);
        TranscoderOutput output_png_image = new TranscoderOutput((OutputStream)png_ostream);
        PNGTranscoder my_converter = new PNGTranscoder();
        my_converter.transcode(input_svg_image, output_png_image);
        png_ostream.flush();
        ((OutputStream)png_ostream).close();
    }

    public static BufferedImage rasterize(URL svgFile) throws Exception {
        JPEGTranscoder t = new JPEGTranscoder();
        t.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
        TranscoderInput input = new TranscoderInput(svgFile.openStream());
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
        t.transcode(input, output);
        byte[] data = ostream.toByteArray();
        ByteArrayInputStream inputArray = new ByteArrayInputStream(data);
        BufferedImage image = ImageIO.read(inputArray);
        ostream.flush();
        ostream.close();
        return image;
    }

    public void setSizeOnView(GJaxbConceptType node) throws Exception {
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
        if (node.isSetNodeMetaModeling() && node.getNodeMetaModeling().isSetModelingViewDefinition() && node.getNodeMetaModeling().getModelingViewDefinition().isSetView() && (!node.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().isSetWidth() || !node.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().isSetHeight())) {
            String imgUrl = node.getNodeMetaModeling().getModelingViewDefinition().getView().getUrl();
            URL url = null;
            if (imgUrl.contains("webjars")) {
                String classpathUrl = "META-INF/resources/webjars" + imgUrl.substring(imgUrl.indexOf("webjars") + "webjars".length(), imgUrl.length());
                url = Thread.currentThread().getContextClassLoader().getResource(classpathUrl);
            } else {
                url = new URL(imgUrl);
            }
            InputStream is = url.openStream();
            Document document = factory.createDocument(url.toString(), is);
            UserAgentAdapter agent = new UserAgentAdapter();
            DocumentLoader loader = new DocumentLoader((UserAgent)agent);
            BridgeContext context = new BridgeContext((UserAgent)agent, loader);
            context.setDynamic(true);
            GVTBuilder builder = new GVTBuilder();
            GraphicsNode root = builder.build(context, document);
            node.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setWidth((float)root.getPrimitiveBounds().getWidth());
            node.getNodeMetaModeling().getModelingViewDefinition().getView().getDimension().setHeight((float)root.getPrimitiveBounds().getHeight());
        }
    }

    private static enum ConnectorType {
        START,
        END;

    }
}

