/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.event.interpretation.config;

import fr.emac.gind.commons.utils.io.FileUtil;
import fr.emac.gind.commons.utils.io.zip.InputZip;
import fr.emac.gind.commons.utils.io.zip.OutputZip;
import fr.emac.gind.commons.utils.io.zip.ZipUtil;
import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.model.interpretation.config.GJaxbDeploy;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfig;
import fr.emac.gind.model.interpretation.config.GJaxbInterpretationConfigs;
import fr.emac.gind.model.interpretation.config.GJaxbPackage;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class InterpretationConfigDeployHelper {
    private static final Logger LOG = LoggerFactory.getLogger((String)InterpretationConfigDeployHelper.class.getName());

    public static GJaxbDeploy buildRequest(GJaxbInterpretationConfigs configs, String collaborationName, String knowledgeSpaceName, File ... additionalFiles) throws Exception {
        ArrayList<InputZip> zips = new ArrayList<InputZip>();
        int cpt = 0;
        for (GJaxbInterpretationConfig config : configs.getInterpretationConfig()) {
            Document configDom = XMLJAXBContext.getInstance().marshallAnyElement((AbstractJaxbObject)config);
            zips.add(new InputZip("interpretationConfig" + cpt++ + ".xml", (InputStream)new ByteArrayInputStream(XMLPrettyPrinter.print((Node)configDom).getBytes())));
        }
        if (additionalFiles != null && additionalFiles.length > 0) {
            for (File addFile : additionalFiles) {
                zips.add(new InputZip(addFile.getName(), (InputStream)new ByteArrayInputStream(FileUtil.getContents((File)addFile).getBytes())));
            }
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ZipUtil.zip((OutputStream)output, (InputZip[])zips.toArray(new InputZip[zips.size()]));
        ByteArrayDataSource dataSource = new ByteArrayDataSource(output.toByteArray(), "application/octet-stream");
        DataHandler value = new DataHandler((DataSource)dataSource);
        GJaxbDeploy request = new GJaxbDeploy();
        GJaxbPackage package_ = new GJaxbPackage();
        package_.setZip(value);
        request.setPackage(package_);
        request.setRuleId("interpretationConfig-" + UUID.randomUUID().toString());
        request.setCollaborationName(collaborationName);
        request.setKnowledgeSpaceName(knowledgeSpaceName);
        return request;
    }

    public static GJaxbInterpretationConfigs extractInterpretationConfig(GJaxbDeploy request) throws Exception {
        OutputZip[] outputs;
        GJaxbInterpretationConfigs res = new GJaxbInterpretationConfigs();
        String packageName = request.getRuleId();
        DataHandler packageInterpretation = request.getPackage().getZip();
        for (OutputZip ic : outputs = ZipUtil.unZip((InputStream)packageInterpretation.getDataSource().getInputStream())) {
            Document parsedIC = DOMUtil.getInstance().parse((InputStream)new ByteArrayInputStream(ic.getStream().toByteArray()));
            GJaxbInterpretationConfig tmp = (GJaxbInterpretationConfig)XMLJAXBContext.getInstance().unmarshallDocument(parsedIC, GJaxbInterpretationConfig.class);
            res.getInterpretationConfig().add(tmp);
        }
        return res;
    }
}

