/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.servlet.soap.impl.servlet;

import fr.emac.gind.commons.utils.xml.DOMUtil;
import fr.emac.gind.commons.utils.xml.XMLCompactPrinter;
import fr.emac.gind.commons.utils.xml.XMLPrettyPrinter;
import fr.emac.gind.marshaller.AbstractJaxbObject;
import fr.emac.gind.marshaller.xml.XMLJAXBContext;
import fr.emac.gind.servlet.soap.impl.servlet.SoapReceiver;
import fr.emac.gind.transport.protocol.soap.binding.SOAPBindingHelper;
import fr.emac.gind.transport.protocols.soap.handler.SOAPHandler;
import fr.emac.gind.wsdl11.WSDLDefinitionsManager;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTBinding;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTBindingOperation;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTDefinitions;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTMessage;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTOperation;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTParam;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTPart;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTPort;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTPortType;
import gind.org.xmlsoap.schemas.wsdl.GJaxbTService;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.ws.WebServiceException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapHandler
extends Handler.Abstract {
    private static final Logger LOG = LoggerFactory.getLogger(SoapHandler.class);
    private static final String HTML_TITLE = "<html><head><title>Welcome SOAP Listener</title></head><body>";
    private SoapReceiver receiver;
    private WSDLDefinitionsManager definition;
    private QName serviceQName;
    private String endpointName;
    private URL endpointURL;

    public SoapHandler(SoapReceiver receiver, QName serviceQName, String endpoint, WSDLDefinitionsManager definition) {
        this.receiver = receiver;
        this.definition = definition;
        this.serviceQName = serviceQName;
        this.endpointName = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        System.out.println("SOAP Handler started !!!");
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        try {
            String path = request.getHttpURI().getPath();
            String query = request.getHttpURI().getQuery();
            LOG.debug("path        = {}", (Object)path);
            LOG.debug("queryString = {}", (Object)query);
            if (this.endpointURL != null && (this.endpointURL.getPath().contains(path) || path.contains(this.endpointURL.getPath()))) {
                String method = request.getMethod();
                if ("POST".equalsIgnoreCase(method)) {
                    this.handleRequestFromExternalClient(request, response, callback);
                    return true;
                }
                if (this.isImportWSDLRequest(query)) {
                    LOG.debug("Print imported WSDL description");
                    this.printImportedDocuments(request, response, query, callback);
                    return true;
                }
                LOG.debug("Welcome");
                this.welcomeMessage(response, callback);
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            callback.failed((Throwable)new WebServiceException((Throwable)new SOAPException(e)));
            return true;
        }
    }

    private void printImportedDocuments(Request request, Response response, String queryString, Callback callback) {
        block33: {
            try {
                if ("wsdl".equals(queryString)) {
                    try (OutputStream out = Response.asBufferedOutputStream((Request)request, (Response)response);){
                        this.printWSDL(out);
                    }
                    callback.succeeded();
                    break block33;
                }
                if (request.getHttpURI().getPath().contains(".jar!/")) {
                    String pathName = request.getHttpURI().getPath();
                    pathName = pathName.substring(pathName.indexOf(".jar!/") + ".jar!/".length());
                    URL url = Thread.currentThread().getContextClassLoader().getResource(pathName);
                    try (InputStream is = url.openStream();
                         OutputStream out = Response.asBufferedOutputStream((Request)request, (Response)response);){
                        Document importedDoc = DOMUtil.getInstance().parse(is);
                        this.setXml(response);
                        XMLPrettyPrinter.print((Node)importedDoc, (OutputStream)out, (String)XMLPrettyPrinter.getEncoding((Document)importedDoc));
                    }
                    callback.succeeded();
                    break block33;
                }
                String endpointName = request.getHttpURI().getPath().replaceFirst("/services/", "").replace("/", "");
                Object listener = null;
                if (listener == null) {
                    throw new IllegalStateException("Print imported documents ... Impossible de r\u00e9soudre l'endpoint: " + endpointName);
                }
                String importsRootURL = "http://" + request.getHttpURI().getAuthority() + request.getHttpURI().getPath() + "?wsdl=";
                Map<URI, Document> importedDocsMap = this.getImportedDocuments(importsRootURL);
                String docFileName = queryString;
                int idx = queryString.lastIndexOf("wsdl=");
                if (idx > 0) {
                    docFileName = queryString.substring(idx + "wsdl=".length());
                }
                boolean find = false;
                for (URI uri : importedDocsMap.keySet()) {
                    if (!uri.toString().contains(docFileName)) continue;
                    find = true;
                    Document importedDoc = importedDocsMap.get(uri);
                    try (OutputStream out = Response.asBufferedOutputStream((Request)request, (Response)response);){
                        this.setXml(response);
                        XMLPrettyPrinter.print((Node)importedDoc, (OutputStream)out, (String)XMLPrettyPrinter.getEncoding((Document)importedDoc));
                        break;
                    }
                }
                if (!find) {
                    throw new IllegalStateException("Document inconnu: " + docFileName + ". Disponibles: " + String.valueOf(importedDocsMap.keySet()));
                }
                callback.succeeded();
            }
            catch (Exception e) {
                callback.failed((Throwable)e);
            }
        }
    }

    private Map<URI, Document> getImportedDocuments(String importRootUrl) {
        return new HashMap<URI, Document>();
    }

    private boolean isImportWSDLRequest(String queryString) {
        return queryString != null && queryString.toLowerCase().startsWith("wsdl");
    }

    private void printWSDL(OutputStream out) {
        try {
            if (this.serviceQName != null && this.endpointName != null && this.definition != null) {
                GJaxbTPort port = this.definition.getEndpointOfService(this.endpointName, this.serviceQName);
                GJaxbTDefinitions definitions = (GJaxbTDefinitions)port.getNaturalParent().getNaturalParent();
                SOAPBindingHelper.setSOAPAddress((GJaxbTPort)port, (String)this.endpointURL.toString());
                Document doc = XMLJAXBContext.getInstance().marshallAnyType(new QName("http://schemas.xmlsoap.org/wsdl/", "definitions"), (AbstractJaxbObject)definitions, GJaxbTDefinitions.class);
                LOG.debug("Print WSDL: {}", (Object)XMLCompactPrinter.print((Node)doc));
                if (doc == null) {
                    this.printWSDLError(out, "WSDL description can not been retrieved from endpoint");
                } else {
                    XMLPrettyPrinter.print((Node)doc, (OutputStream)out, (String)XMLPrettyPrinter.getEncoding((Document)doc));
                }
            }
        }
        catch (Throwable e) {
            LOG.error("Error printing WSDL", e);
        }
    }

    private void printWSDLError(OutputStream out, String message) throws IOException {
        String wsdlntfound = "<error><description>Unable to get WSDL for this service</description><reason>" + message + "</reason></error>";
        out.write(wsdlntfound.getBytes(StandardCharsets.UTF_8));
        out.flush();
    }

    private void welcomeMessage(Response response, Callback callback) {
        try (OutputStream out = Response.asBufferedOutputStream(null, (Response)response);){
            response.setStatus(200);
            response.getHeaders().put(HttpHeader.CONTENT_TYPE, "text/html; charset=utf-8");
            out.write(HTML_TITLE.getBytes(StandardCharsets.UTF_8));
            out.write("<h1>SOAP Handler</h1>".getBytes(StandardCharsets.UTF_8));
            out.write("<h2>Web Service information</h2><ul>".getBytes(StandardCharsets.UTF_8));
            out.write(("<li>Endpoint URL    : " + String.valueOf(this.endpointURL)).getBytes(StandardCharsets.UTF_8));
            out.write(("<li>Endpoint Name   : " + this.endpointName).getBytes(StandardCharsets.UTF_8));
            out.write(("<li>Service  QName  : " + String.valueOf(this.serviceQName)).getBytes(StandardCharsets.UTF_8));
            out.write(("<li>WSDL Definition : " + String.valueOf(this.definition)).getBytes(StandardCharsets.UTF_8));
            out.write("</ul></body></html>".getBytes(StandardCharsets.UTF_8));
            out.flush();
            callback.succeeded();
        }
        catch (Exception e) {
            callback.failed((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleRequestFromExternalClient(Request request, Response response, Callback callback) {
        try {
            String buffer = Content.Source.asString((Content.Source)request, (Charset)StandardCharsets.UTF_8);
            LOG.trace("BUFFER size = {}", (Object)(buffer == null ? 0 : buffer.length()));
            Document soapRequest = null;
            if (buffer != null && !buffer.trim().isEmpty()) {
                try (ByteArrayInputStream is = new ByteArrayInputStream(buffer.getBytes(StandardCharsets.UTF_8));){
                    soapRequest = DOMUtil.getInstance().parse((InputStream)is);
                }
                LOG.trace("REQUEST = {}", (Object)XMLPrettyPrinter.print((Node)soapRequest));
            }
            if (soapRequest != null) {
                String ct;
                String endpointPath = request.getHttpURI().getPath().replaceFirst("/services/", "");
                String soapAction = request.getHeaders().get("SOAPAction");
                if (soapAction != null) {
                    soapAction = soapAction.replace("\"", "");
                }
                if (soapAction == null && (ct = request.getHeaders().get(HttpHeader.CONTENT_TYPE)) != null && ct.toLowerCase().startsWith("application/soap+xml") && (soapAction = SoapHandler.extractParam(ct, "action")) != null) {
                    soapAction = soapAction.replace("\"", "");
                }
                if (LOG.isTraceEnabled()) {
                    LOG.debug("endpointName = {}", (Object)endpointPath);
                    LOG.debug("soapAction   = {}", (Object)soapAction);
                }
                Map<String, Object> context = this.createContextFromSoapRequest(soapRequest, soapAction);
                Document soapResponse = DOMUtil.getInstance().newDocument();
                this.receiver.accept(soapRequest, context, soapResponse);
                Object pattern = context.get("pattern");
                if ("in-out".equals(pattern)) {
                    String msg = XMLPrettyPrinter.print((Node)soapResponse);
                    LOG.debug("SOAP Response: {}", (Object)msg);
                    this.setXml(response);
                    try (OutputStream out = Response.asBufferedOutputStream((Request)request, (Response)response);){
                        out.write(msg.getBytes(StandardCharsets.UTF_8));
                    }
                    callback.succeeded();
                    return;
                }
                if (!"in-only".equals(pattern)) throw new IllegalStateException("MEP pattern not accepted for the moment");
                response.setStatus(202);
                callback.succeeded();
                return;
            }
            response.setStatus(400);
            callback.succeeded();
            return;
        }
        catch (Throwable e) {
            callback.failed(e);
        }
    }

    private static String extractParam(String headerValue, String paramName) {
        for (String part : headerValue.split(";")) {
            String name;
            String p = part.trim();
            int eq = p.indexOf(61);
            if (eq <= 0 || !(name = p.substring(0, eq).trim()).equalsIgnoreCase(paramName)) continue;
            String val = p.substring(eq + 1).trim();
            if (val.startsWith("\"") && val.endsWith("\"") && val.length() >= 2) {
                val = val.substring(1, val.length() - 1);
            }
            return val;
        }
        return null;
    }

    private void setXml(Response response) {
        response.setStatus(200);
        response.getHeaders().put(HttpHeader.CONTENT_TYPE, "text/xml; charset=utf-8");
    }

    private Map<String, Object> createContextFromSoapRequest(Document soapRequest, String soapAction) throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>();
        GJaxbTBindingOperation operation = null;
        if (this.definition != null) {
            operation = this.findOperation(soapAction, SOAPHandler.getPayload((Document)soapRequest), this.definition, context);
        }
        if (operation != null) {
            if (operation.getInput() != null && operation.getOutput() != null) {
                context.put("pattern", "in-out");
            } else if (operation.getInput() != null && operation.getOutput() == null) {
                context.put("pattern", "in-only");
            } else {
                throw new Exception("Unsupported pattern for this operation: " + String.valueOf(operation));
            }
        }
        context.put("soapHeader", SOAPHandler.getHeaderMap((Document)soapRequest));
        context.put("soapAction", soapAction);
        return context;
    }

    private GJaxbTBindingOperation findOperation(String soapAction, Element body, WSDLDefinitionsManager desc, Map<String, Object> context) {
        GJaxbTBindingOperation res = this.findOperationUsingSoapAction(soapAction, desc, context);
        if (res == null) {
            res = this.findOperationUsingElement(body, desc, context);
        }
        return res;
    }

    private GJaxbTBindingOperation findOperationUsingElement(Element body, WSDLDefinitionsManager desc, Map<String, Object> context) {
        GJaxbTBindingOperation res = null;
        boolean find = false;
        Element elmt = body;
        if (elmt != null) {
            QName elmtName = new QName(elmt.getNamespaceURI(), elmt.getLocalName());
            LOG.debug("find operation corresponding to element: {}", (Object)elmtName);
            for (GJaxbTBinding b : desc.getBindings()) {
                GJaxbTPortType itf = desc.getInterfaceOfBinding(new QName(b.findTargetNamespace(), b.getName()));
                for (GJaxbTOperation op : itf.getOperation()) {
                    GJaxbTParam input = desc.getInputOfOperation(op);
                    GJaxbTMessage msgInput = desc.getMessage(input.getMessage());
                    assert (msgInput.getPart().size() != 0) : "Operation with no part is unauthorized";
                    assert (msgInput.getPart().size() == 1) : "Only Service exposed in DOCUMENT mode is authorized";
                    GJaxbTPart inputPart = (GJaxbTPart)msgInput.getPart().get(0);
                    assert (inputPart.getType() == null) : "Only element attribute must be defined in a wsdl part";
                    if (!elmtName.getNamespaceURI().equals(inputPart.getElement().getNamespaceURI()) || !elmtName.getLocalPart().equals(inputPart.getElement().getLocalPart())) continue;
                    context.put("messageQName", new QName(msgInput.findTargetNamespace(), msgInput.getName()));
                    context.put("interfaceQName", new QName(itf.findTargetNamespace(), itf.getName()));
                    context.put("operation", op.getName());
                    res = desc.getOperationOfBinding(op.getName(), new QName(b.findTargetNamespace(), b.getName()));
                    find = true;
                    break;
                }
                if (find) break;
            }
        }
        return res;
    }

    private GJaxbTBindingOperation findOperationUsingSoapAction(String soapAction, WSDLDefinitionsManager desc, Map<String, Object> context) {
        LOG.debug("SOAPACTION in request = {}", (Object)soapAction);
        if (this.definition != null) {
            for (GJaxbTService s : desc.getServices()) {
                for (GJaxbTPort ep : s.getPort()) {
                    GJaxbTBinding binding = desc.getBinding(ep.getBinding());
                    for (GJaxbTBindingOperation op : binding.getOperation()) {
                        String action = SOAPBindingHelper.getSOAPAction((GJaxbTBindingOperation)op);
                        LOG.debug("SOAPACTION in desc = {}", (Object)action);
                        if (action == null || !action.equals(soapAction)) continue;
                        GJaxbTOperation operation = this.definition.getOperationOfInterface(op.getName(), binding.getType());
                        GJaxbTParam input = desc.getInputOfOperation(operation);
                        GJaxbTMessage msgInput = desc.getMessage(input.getMessage());
                        context.put("messageQName", new QName(msgInput.findTargetNamespace(), msgInput.getName()));
                        context.put("interfaceQName", binding.getType());
                        context.put("operation", operation.getName());
                        return op;
                    }
                }
            }
        }
        return null;
    }

    public void setURL(URL endpointURL) {
        this.endpointURL = endpointURL;
    }

    public URL getURL() {
        return this.endpointURL;
    }
}

