/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.timeseries.mongodb.launcher;

import fr.emac.gind.launcher.AbstractLauncher;
import fr.emac.gind.launcher.Configuration;
import fr.emac.gind.timeseries.mongodb.server.TimeSeriesWebService;
import java.util.HashMap;
import java.util.Map;

public class TimeSeriesLauncher
extends AbstractLauncher {
    private TimeSeriesWebService tsws = null;
    private Map<String, Object> map = new HashMap<String, Object>();

    public String getInfo() {
        StringBuffer res = new StringBuffer();
        res.append("TimeSeries Service.\n");
        res.append("Number of services exposed: " + this.tsws.getAllAddresses().size() + "\n");
        res.append("\nList of services:\n");
        for (String string : this.tsws.getAllAddresses()) {
            res.append("\t- " + string + "\n");
        }
        if (!this.map.isEmpty()) {
            res.append("\nConfiguration:\n");
            for (Map.Entry entry : this.map.entrySet()) {
                res.append("\t" + (String)entry.getKey() + " = " + String.valueOf(entry.getValue()) + "\n");
            }
        }
        return res.toString();
    }

    public String getName() {
        return "TimeSeries Service";
    }

    public String getPromptName() {
        return "TimeSeries";
    }

    public void startRunner(Configuration conf) throws Exception {
        this.tsws = new TimeSeriesWebService();
        this.map.clear();
        this.map.putAll(conf.getProperties());
        this.tsws.start(this.map);
    }

    public void stopRunner() throws Exception {
        this.tsws.stop();
    }
}

