/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.rest;

import fr.emac.gind.commons.utils.rest.StaticRestExceptionMapper;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;

public class StaticRestServer {
    private Map<Integer, HttpServer> restServers = new HashMap<Integer, HttpServer>();
    private ResourceConfig rc = new ResourceConfig().setProperties(new HashMap());
    private static StaticRestServer INSTANCE = null;

    private StaticRestServer() {
    }

    public static StaticRestServer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StaticRestServer();
        }
        return INSTANCE;
    }

    public ResourceConfig getResourceConfig() {
        return this.rc;
    }

    public void start(Integer port, ResourceConfig rc) {
        if (this.restServers.get(port) == null) {
            rc.register(JacksonFeature.class);
            rc.register(StaticRestExceptionMapper.class);
            rc.property("jersey.config.server.tracing.type", (Object)"ALL");
            rc.property("jersey.config.server.tracing.threshold", (Object)"VERBOSE");
            rc.property("jersey.config.server.response.setStatusOverSendError", (Object)true);
            rc.property("jersey.config.server.disableChunkedEncoding", (Object)true);
            String base_uri = "http://0.0.0.0:" + port;
            System.out.println("base uri: " + base_uri);
            HttpServer restServer = GrizzlyHttpServerFactory.createHttpServer((URI)URI.create(base_uri), (ResourceConfig)rc, (boolean)true);
            NetworkListener listener = (NetworkListener)restServer.getListeners().iterator().next();
            listener.setUploadTimeout(30000);
            listener.getKeepAlive().setIdleTimeoutInSeconds(30);
            this.restServers.put(port, restServer);
        }
    }

    public void stop() {
        for (HttpServer restServer : this.restServers.values()) {
            restServer.shutdownNow();
        }
    }
}

