/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.jaxws;

import fr.emac.gind.commons.utils.uri.URIHelper;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClasspathResolver
implements EntityResolver {
    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId.startsWith("file:/")) {
            String cp = ClasspathResolver.getClasspath(systemId);
            URL cpUrl = Thread.currentThread().getContextClassLoader().getResource(cp);
            if (cpUrl == null) {
                throw new RuntimeException("Impossible to find resource in classpath resolver: " + systemId);
            }
            InputSource source = new InputSource(cpUrl.openStream());
            return source;
        }
        return null;
    }

    public static String getClasspath(String systemId) {
        String cp = systemId;
        if (systemId.startsWith("file:/")) {
            cp = systemId.replace("file:/", "");
        }
        if (cp.contains("/target/classes/")) {
            cp = cp.substring(cp.indexOf("/target/classes/") + "/target/classes/".length());
        }
        if (cp.contains("/target/test-classes/")) {
            cp = cp.substring(cp.indexOf("/target/test-classes/") + "/target/test-classes/".length());
        }
        return cp;
    }

    public static URL resolveEntityUrl(URL baseUrl, String systemId) {
        URL cpUrl = null;
        try {
            URI newUri = URIHelper.resolve((URI)baseUrl.toURI(), (String)systemId);
            cpUrl = newUri.toURL();
            if (cpUrl == null) {
                throw new RuntimeException("Impossible to find resource in classpath resolver: " + systemId);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cpUrl;
    }
}

