/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.ws;

import fr.emac.gind.commons.utils.lang.UncheckedException;
import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.ws.LocalRegistry;
import fr.emac.gind.commons.utils.ws.StaticJettyServer;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.ws.Endpoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SPIWebServicePrimitives {
    private static final Logger LOG = LoggerFactory.getLogger((String)SPIWebServicePrimitives.class.getName());
    protected String host = null;
    protected int port = -1;
    protected int proxyPort = -1;
    protected IPUtil.TRANSPORT_PROTOCOL protocol = IPUtil.TRANSPORT_PROTOCOL.HTTP;
    protected boolean isStarted = false;
    private Map<String, Object> wsMap = Collections.synchronizedMap(new HashMap());
    protected Map<Object, Endpoint> endpoints = Collections.synchronizedMap(new HashMap());
    protected Map<String, Object> context = Collections.synchronizedMap(new HashMap());

    public SPIWebServicePrimitives() throws Exception {
        StaticJettyServer.getInstance().start();
    }

    public void init(Map<String, Object> context) throws RuntimeException {
        this.host = (String)context.get("host");
        this.port = Integer.parseInt(String.valueOf(context.get("port")));
        if (context.get("proxy-port") != null) {
            this.proxyPort = Integer.parseInt(String.valueOf(context.get("proxy-port")));
        }
        if (context.get("protocol") != null) {
            this.protocol = IPUtil.TRANSPORT_PROTOCOL.fromString((String)context.get("protocol").toString());
        }
        if (this.host == null) {
            throw new UncheckedException((Throwable)new Exception("host variable must be set statically in init method"));
        }
        if (this.port == -1) {
            throw new UncheckedException((Throwable)new Exception("port variable must be set statically in init method"));
        }
        this.onInit(context);
    }

    public abstract void onInit(Map<String, Object> var1) throws RuntimeException;

    public boolean isStarted() {
        return this.isStarted;
    }

    public static String createAddress(IPUtil.TRANSPORT_PROTOCOL protocol, String host, int port, int proxify, String queryPath) {
        return String.valueOf(protocol) + "://" + host + ":" + port + ("/" + queryPath).replace("//", "/");
    }

    public static String createTwoInterfacesAddresses(IPUtil.TRANSPORT_PROTOCOL protocol, int port, String queryPath) {
        return String.valueOf(protocol) + "://0.0.0.0:" + port + ("/" + queryPath).replace("//", "/");
    }

    public void start(String queryPath, Object implementation, JAXBContext ... jaxbcontexts) throws Exception {
        this.start(queryPath, implementation, (ClassLoader)null, jaxbcontexts);
    }

    public synchronized void start(String queryPath, Object implementation, ClassLoader cl, JAXBContext ... jaxbcontexts) throws Exception {
        StaticJettyServer.getInstance().addConnector(this.port);
        String prettyAddress = SPIWebServicePrimitives.createAddress(IPUtil.TRANSPORT_PROTOCOL.HTTP, this.host, this.port, this.proxyPort, queryPath);
        String twoInterfaceAddresses = SPIWebServicePrimitives.createTwoInterfacesAddresses(IPUtil.TRANSPORT_PROTOCOL.HTTP, this.port, queryPath);
        LOG.info("Start ws at: " + prettyAddress + " with implementation: " + implementation.getClass().getSimpleName());
        Endpoint endpoint = null;
        try {
            endpoint = Endpoint.publish((String)twoInterfaceAddresses, (Object)implementation);
        }
        catch (Throwable t) {
            Throwable c = t;
            while (c.getCause() != null) {
                c = c.getCause();
            }
            LOG.error("WSDL generation root cause", c);
            throw t;
        }
        LOG.info(implementation.getClass().getSimpleName() + " is started at: " + prettyAddress);
        this.endpoints.put(implementation, endpoint);
        this.registerWSImplementation(queryPath, implementation);
        LocalRegistry.getInstance().addWebService(this);
    }

    public void registerWSImplementation(String queryPath, Object implementation) {
        this.wsMap.put(queryPath, implementation);
    }

    public void start() throws Exception {
        this.init(this.context);
        for (Map.Entry<String, Object> entry : this.wsMap.entrySet()) {
            if (this.endpoints.get(entry.getValue()) != null) continue;
            this.start(entry.getKey(), entry.getValue(), new JAXBContext[0]);
        }
        this.isStarted = true;
    }

    public synchronized void start(Map<String, Object> context) throws Exception {
        if (context != null) {
            this.context = context;
        }
        this.start();
    }

    public void stop(Object implementation) throws Exception {
        Endpoint server = this.endpoints.get(implementation);
        if (server != null) {
            server.stop();
        }
        if (this.endpoints.size() == 1) {
            StaticJettyServer.getInstance().removeConnector(this.port);
            while (!IPUtil.available((int)this.port)) {
                LOG.debug("Wait port become available : " + this.port);
                Thread.sleep(300L);
            }
            this.isStarted = false;
        }
    }

    public void stop() throws Exception {
        for (Object implementation : this.endpoints.keySet()) {
            Endpoint server = this.endpoints.get(implementation);
            String address = this.getAddress(implementation.getClass());
            LOG.debug("stopping  " + String.valueOf(server.getImplementor()) + " " + address + ".");
            server.stop();
        }
        StaticJettyServer.getInstance().removeConnector(this.port);
        while (!IPUtil.available((int)this.port)) {
            LOG.debug("Wait port become available : " + this.port);
            Thread.sleep(300L);
        }
        this.isStarted = false;
    }

    public String getAddress(Class<?> implementationClass) {
        for (Map.Entry<String, Object> entry : this.wsMap.entrySet()) {
            if (!implementationClass.getName().equals(entry.getValue().getClass().getName())) continue;
            return SPIWebServicePrimitives.createAddress(IPUtil.TRANSPORT_PROTOCOL.HTTP, this.host, this.port, this.proxyPort, entry.getKey());
        }
        return null;
    }

    public Endpoint getEndpoint(Class<?> implementationClass) {
        for (Map.Entry<Object, Endpoint> entry : this.endpoints.entrySet()) {
            if (!implementationClass.getName().equals(entry.getKey().getClass().getName())) continue;
            return entry.getValue();
        }
        return null;
    }

    public Endpoint findEndpointByQueryPath(String queryPath) {
        for (Map.Entry<String, Object> entry : this.wsMap.entrySet()) {
            if (!entry.getKey().equals(queryPath)) continue;
            return this.endpoints.get(entry.getValue());
        }
        return null;
    }

    public <T> T findImplementationByQueryPath(String queryPath, Class<T> implementationClass) {
        for (Map.Entry<String, Object> entry : this.wsMap.entrySet()) {
            if (!entry.getKey().equals(queryPath)) continue;
            return (T)entry.getValue();
        }
        return null;
    }

    public <T> T getImplementation(Class<T> implementationClass) {
        for (Map.Entry<String, Object> entry : this.wsMap.entrySet()) {
            if (!implementationClass.getName().equals(entry.getValue().getClass().getName())) continue;
            return (T)entry.getValue();
        }
        return null;
    }

    public List<String> getAllAddresses() {
        ArrayList<String> res = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.wsMap.entrySet()) {
            res.add(SPIWebServicePrimitives.createAddress(IPUtil.TRANSPORT_PROTOCOL.HTTP, this.host, this.port, this.proxyPort, entry.getKey()));
        }
        return res;
    }

    public Map<String, Object> getWsMap() {
        return this.wsMap;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public IPUtil.TRANSPORT_PROTOCOL getProtocol() {
        return this.protocol;
    }
}

