/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.ws;

import fr.emac.gind.commons.utils.lang.reflect.ReflectionHelper;
import jakarta.xml.ws.Endpoint;
import java.net.URL;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.eclipse.jetty.http.spi.DelegatingThreadPool;
import org.eclipse.jetty.http.spi.JettyHttpServerProvider;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticJettyServer {
    private static final Logger LOG = LoggerFactory.getLogger((String)StaticJettyServer.class.getName());
    private Server JETTY_SERVER = null;
    private ContextHandlerCollection contextHandlerCollection = null;
    private static StaticJettyServer INSTANCE = null;

    private StaticJettyServer() {
        this.createJettyServer();
    }

    private void createJettyServer() {
        this.JETTY_SERVER = new Server((ThreadPool)new DelegatingThreadPool((Executor)Executors.newCachedThreadPool()));
        this.contextHandlerCollection = new ContextHandlerCollection(new ContextHandler[0]);
        this.JETTY_SERVER.setHandler((Handler)this.contextHandlerCollection);
        JettyHttpServerProvider.setServer((Server)this.JETTY_SERVER);
        System.setProperty("com.sun.net.httpserver.HttpServerProvider", JettyHttpServerProvider.class.getName());
    }

    public static StaticJettyServer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StaticJettyServer();
        }
        return INSTANCE;
    }

    public void start() throws Exception {
        if (this.JETTY_SERVER == null) {
            this.createJettyServer();
        }
        if (!this.JETTY_SERVER.isStarting() && !this.JETTY_SERVER.isStarted()) {
            try {
                this.JETTY_SERVER.start();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void stop(boolean reset) throws Exception {
        if (this.JETTY_SERVER != null && (this.JETTY_SERVER.isStarting() || this.JETTY_SERVER.isStarted())) {
            this.JETTY_SERVER.stop();
            System.out.println(this.JETTY_SERVER.getState());
            for (Connector c : this.JETTY_SERVER.getConnectors()) {
                c.stop();
                c.shutdown();
                this.JETTY_SERVER.removeConnector(c);
            }
            if (reset) {
                JettyHttpServerProvider.setServer(null);
                this.JETTY_SERVER = null;
            }
        }
    }

    public synchronized Connector addConnector(int port) throws Exception {
        Connector foundConnector = null;
        for (Connector c : this.JETTY_SERVER.getConnectors()) {
            if (c == null || !c.toString().contains(":" + port)) continue;
            foundConnector = c;
            break;
        }
        if (foundConnector == null) {
            ServerConnector connector = new ServerConnector(this.JETTY_SERVER, -1, 0, new ConnectionFactory[]{new HttpConnectionFactory()});
            LOG.debug("start jetty server on port: " + port);
            connector.setPort(port);
            connector.setHost("0.0.0.0");
            connector.setAcceptQueueSize(128);
            this.JETTY_SERVER.addConnector((Connector)connector);
            connector.start();
            foundConnector = connector;
        }
        return foundConnector;
    }

    public void removeConnector(int port) throws Exception {
        Connector foundConnector = null;
        if (this.JETTY_SERVER != null) {
            for (Connector c : this.JETTY_SERVER.getConnectors()) {
                if (c.getTransport() == null || !c.getTransport().toString().contains(":" + port)) continue;
                foundConnector = c;
                break;
            }
        }
        if (foundConnector != null) {
            this.JETTY_SERVER.removeConnector(foundConnector);
            foundConnector.stop();
            foundConnector.getConnectedEndPoints().forEach(endpoint -> endpoint.close());
            while (!foundConnector.isStopped()) {
                Thread.sleep(400L);
                System.out.println("Wait stop connector");
            }
            foundConnector.shutdown().get();
        }
    }

    public synchronized Endpoint publishJAXWSEndpoint(String address, Object implementation) throws Exception {
        URL url = new URL(address);
        this.addConnector(url.getPort());
        Endpoint ep = null;
        try {
            ep = Endpoint.publish((String)address, (Object)implementation);
        }
        catch (Exception e) {
            this.removeConnector(url.getPort());
            throw new Exception("Impossible to publish: " + String.valueOf(implementation.getClass()), e);
        }
        LOG.info("endpoint pusblish at : " + address);
        return ep;
    }

    public synchronized void unPublishJAXWSEndpoint(Endpoint endpoint) throws Exception {
        Object endpointImpl = ReflectionHelper.getPrivateFieldValue(endpoint.getClass(), (Object)endpoint, (String)"actualEndpoint");
        if (endpointImpl != null) {
            String address = (String)ReflectionHelper.getPrivateFieldValue(endpointImpl.getClass(), (Object)endpointImpl, (String)"address");
            URL url = new URL(address);
            this.removeConnector(url.getPort());
        }
    }

    public ContextHandlerCollection getHandlers() {
        return this.contextHandlerCollection;
    }

    public void addHandler(String path, Handler.Abstract servlet) throws Exception {
        ContextHandler contextHandler = new ContextHandler(path);
        contextHandler.setHandler((Handler)servlet);
        contextHandler.setAllowNullPathInContext(true);
        this.contextHandlerCollection.addHandler((Handler)contextHandler);
        servlet.start();
        contextHandler.start();
    }
}

