/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BijectiveMap<K, V> {
    private Map<K, V> map = new HashMap();
    private Map<V, K> inverseMap = new HashMap<V, K>();

    public void put(K key, V value) {
        this.map.put(key, value);
        this.inverseMap.put(value, key);
    }

    public V getValue(K key) {
        return this.map.get(key);
    }

    public K getKey(V value) {
        return this.inverseMap.get(value);
    }

    public Collection<V> values() {
        return this.map.values();
    }

    public RemovedKey<K, V> removeKeyValuePairByKey(K key) {
        if (key == null || !this.map.containsKey(key)) {
            return RemovedKey.EMPTY_ENTRY;
        }
        V value = this.map.remove(key);
        this.inverseMap.remove(value);
        RemovedKey<K, V> removedKey = new RemovedKey<K, V>(key, value);
        return removedKey;
    }

    public RemovedKey<K, V> removeKeyValuePairByValue(V value) {
        if (value == null || !this.inverseMap.containsKey(value)) {
            return RemovedKey.EMPTY_ENTRY;
        }
        K key = this.inverseMap.remove(value);
        this.map.remove(key);
        RemovedKey<K, V> removedKey = new RemovedKey<K, V>(key, value);
        return removedKey;
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.inverseMap.containsKey(value);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public static class RemovedKey<K, V> {
        K key;
        V value;
        public static final RemovedKey EMPTY_ENTRY = new RemovedKey();

        private RemovedKey() {
            this.key = null;
            this.value = null;
        }

        public RemovedKey(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public static RemovedKey getEmptyEntry() {
            return EMPTY_ENTRY;
        }
    }
}

