/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.maths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

public class CartesianProduct<V> {
    public static List<Object> POISON_KILL = new ArrayList<Object>();

    public List<List<V>> product(List<List<V>> lists, Integer maxSolution, LinkedBlockingQueue<List<V>> queue) {
        ArrayList<List<V>> product = new ArrayList<List<V>>();
        this.backtrack(product, new ArrayList(), lists, maxSolution, queue);
        if (maxSolution != null) {
            while (product.size() > maxSolution) {
                product.removeLast();
            }
        }
        queue.add(POISON_KILL);
        return product;
    }

    public int productNumber(List<List<V>> lists) {
        ArrayList<List<V>> product = new ArrayList<List<V>>();
        this.backtrack(product, new ArrayList(), lists, null, null);
        return product.size();
    }

    private void backtrack(List<List<V>> result, List<V> existingTupleToComplete, List<List<V>> valuesToUse, Integer maxSolution, LinkedBlockingQueue<List<V>> queue) {
        if (maxSolution != null && result.size() >= maxSolution) {
            queue.add(POISON_KILL);
            return;
        }
        if (!valuesToUse.isEmpty()) {
            for (V value : valuesToUse.get(0)) {
                ArrayList<V> newExisting = new ArrayList<V>(existingTupleToComplete);
                newExisting.add(value);
                if (valuesToUse.size() == 1) {
                    if (queue != null) {
                        queue.add(newExisting);
                    } else {
                        result.add(newExisting);
                    }
                    if (maxSolution == null || result.size() <= maxSolution) continue;
                    queue.add(POISON_KILL);
                    return;
                }
                ArrayList<List<V>> newValues = new ArrayList<List<V>>();
                for (int i = 1; i < valuesToUse.size(); ++i) {
                    if (valuesToUse.get(i) == null || valuesToUse.get(i).isEmpty()) continue;
                    newValues.add(valuesToUse.get(i));
                }
                this.backtrack(result, newExisting, newValues, maxSolution, queue);
            }
        }
    }

    public static void main(String[] args) {
        ArrayList<Integer> list1 = new ArrayList<Integer>(Arrays.asList(1776, 1789));
        ArrayList<Integer> list2 = new ArrayList<Integer>(Arrays.asList(7, 12));
        ArrayList<Integer> list3 = new ArrayList<Integer>(Arrays.asList(4, 14, 23));
        ArrayList<Integer> list31 = new ArrayList<Integer>(Arrays.asList(new Integer[0]));
        ArrayList<Integer> list4 = new ArrayList<Integer>(Arrays.asList(0, 1));
        ArrayList input = new ArrayList();
        input.add(list1);
        input.add(list2);
        input.add(list3);
        input.add(list31);
        input.add(list4);
        CartesianProduct cartesianProduct = new CartesianProduct();
        List product = cartesianProduct.product(input, null, null);
        System.out.println(product);
        System.out.println("size: " + product.size());
    }
}

