/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.io.zip;

import fr.emac.gind.commons.utils.io.zip.InputZip;
import fr.emac.gind.commons.utils.io.zip.OutputZip;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)ZipUtil.class.getName());

    public static File unZip(ZipFile archive, File destDir) throws Exception {
        File mainDirectory = null;
        assert (archive != null);
        assert (destDir != null && destDir.isDirectory());
        Enumeration<? extends ZipEntry> entries = archive.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            File extractedFile = null;
            if (entry.isDirectory()) {
                extractedFile = new File(destDir, entryName.trim());
                extractedFile.mkdirs();
            } else {
                InputStream inputStream = archive.getInputStream(entry);
                extractedFile = new File(destDir, entryName.trim());
                extractedFile.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(extractedFile);
                byte[] buffer = new byte[2048];
                int length = inputStream.read(buffer);
                while (length > 0) {
                    fileOutputStream.write(buffer, 0, length);
                    length = inputStream.read(buffer);
                }
                inputStream.close();
                fileOutputStream.close();
            }
            if (mainDirectory != null || !(mainDirectory = extractedFile).isFile()) continue;
            mainDirectory = mainDirectory.getParentFile();
        }
        return mainDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unZip(InputStream is, File destDir) throws Exception {
        File mainDirectory = null;
        try (ZipInputStream zipInputStream = new ZipInputStream(is);){
            int BUFFER_LENGTH = 1024;
            byte[] buf = new byte[BUFFER_LENGTH];
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String entryName = zipEntry.getName();
                File extractedFile = new File(destDir, entryName);
                if (zipEntry.isDirectory()) {
                    extractedFile.mkdirs();
                } else {
                    extractedFile.getParentFile().mkdirs();
                    try (FileOutputStream fileoutputstream = new FileOutputStream(extractedFile);){
                        int n;
                        while ((n = zipInputStream.read(buf, 0, BUFFER_LENGTH)) > -1) {
                            fileoutputstream.write(buf, 0, n);
                        }
                    }
                    if (mainDirectory == null && (mainDirectory = extractedFile).isFile()) {
                        mainDirectory = mainDirectory.getParentFile();
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        return mainDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputZip[] unZip(InputStream is) throws Exception {
        ArrayList<OutputZip> outputs = new ArrayList<OutputZip>();
        Object mainDirectory = null;
        try (ZipInputStream zipInputStream = new ZipInputStream(is);){
            int BUFFER_LENGTH = 1024;
            byte[] buf = new byte[BUFFER_LENGTH];
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String entryName = zipEntry.getName();
                try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                    int n;
                    while ((n = zipInputStream.read(buf, 0, BUFFER_LENGTH)) > -1) {
                        output.write(buf, 0, n);
                    }
                }
                outputs.add(new OutputZip(entryName, output));
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        return outputs.toArray(new OutputZip[outputs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream unZipFile(InputStream is) throws Exception {
        ByteArrayOutputStream outputstream = new ByteArrayOutputStream();
        try (ZipInputStream zipInputStream = new ZipInputStream(is);){
            int BUFFER_LENGTH = 1024;
            byte[] buf = new byte[BUFFER_LENGTH];
            try {
                int n;
                while ((n = zipInputStream.read(buf, 0, BUFFER_LENGTH)) > -1) {
                    outputstream.write(buf, 0, n);
                }
            }
            finally {
                outputstream.close();
            }
        }
        return outputstream;
    }

    public static void zip(File zipFile, String pathFolderInZip, File ... fileList) {
        byte[] buffer = new byte[1024];
        try {
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            if (pathFolderInZip == null) {
                pathFolderInZip = "";
            }
            for (File file : fileList) {
                int len;
                if (!file.isFile()) continue;
                ZipEntry ze = new ZipEntry(pathFolderInZip + "/" + file.getName().toString());
                try {
                    zos.putNextEntry(ze);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                FileInputStream in = new FileInputStream(file);
                while ((len = ((InputStream)in).read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                ((InputStream)in).close();
            }
            zos.closeEntry();
            zos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void zip(OutputStream output, InputZip ... fileList) {
        byte[] buffer = new byte[1024];
        try {
            ZipOutputStream zos = new ZipOutputStream(output);
            for (InputZip file : fileList) {
                int len;
                ZipEntry ze = new ZipEntry(file.getName().toString());
                zos.putNextEntry(ze);
                InputStream in = file.getStream();
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                in.close();
            }
            zos.closeEntry();
            zos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void zipFolder(File zipFile, File folderToZip) throws Exception {
        byte[] buffer = new byte[1024];
        try {
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            LOG.debug("Output to Zip : " + String.valueOf(zipFile));
            ArrayList<String> fileList = new ArrayList<String>();
            ZipUtil.generateFileList(folderToZip, fileList, folderToZip);
            for (String file : fileList) {
                int len;
                LOG.debug("File Added : " + file);
                ZipEntry ze = new ZipEntry(file);
                zos.putNextEntry(ze);
                FileInputStream in = new FileInputStream(folderToZip.toString() + "/" + file);
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                in.close();
            }
            zos.closeEntry();
            zos.close();
            LOG.debug("Done");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void generateFileList(File node, List<String> fileList, File topParent) throws Exception {
        if (node.isFile()) {
            fileList.add(ZipUtil.generateZipEntry(node.getAbsoluteFile().toString(), topParent));
        }
        if (node.isDirectory()) {
            String[] subNote;
            for (String filename : subNote = node.list()) {
                ZipUtil.generateFileList(new File(node, filename), fileList, topParent);
            }
        }
    }

    private static String generateZipEntry(String file, File folderToZip) throws Exception {
        return file.substring(folderToZip.getAbsoluteFile().toString().length() + 1, file.length());
    }
}

