/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.net;

import fr.emac.gind.commons.utils.net.IPUtil;
import fr.emac.gind.commons.utils.random.RandomUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortAssigner {
    private static Logger LOG = LoggerFactory.getLogger((String)PortAssigner.class.getName());
    public static int PORT_MIN = 10000;
    public static int PORT_MAX = 20000;
    private Map<String, Integer> assigners = new HashMap<String, Integer>();

    public int assign(String key, Integer defaultPort) throws Exception {
        if (this.assigners.get(key) != null) {
            return this.assigners.get(key);
        }
        if (defaultPort != null && !this.assigners.values().contains(defaultPort) && IPUtil.available(defaultPort)) {
            this.assigners.put(key, defaultPort);
            LOG.debug("defaultPort port assign for '" + key + "' : " + defaultPort);
            return defaultPort;
        }
        if (defaultPort == null || this.assigners.values().contains(defaultPort) || !IPUtil.available(defaultPort)) {
            int new_port = RandomUtil.randomBetween(PORT_MIN, PORT_MAX);
            while (this.assigners.values().contains(new_port) && !IPUtil.available(new_port)) {
                new_port = RandomUtil.randomBetween(PORT_MIN, PORT_MAX);
                LOG.debug("try to find new port for '" + key + "' : " + new_port);
            }
            this.assigners.put(key, new_port);
            LOG.debug("new port assign for '" + key + "' : " + new_port);
            return new_port;
        }
        throw new Exception("Impossible to assign available port !!! for: " + key);
    }
}

