/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.regexp;

import java.text.Normalizer;
import java.util.regex.Pattern;

public class AccentRemover {
    public static String removeAccents(String input) {
        String normalized = Normalizer.normalize(input, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(normalized).replaceAll("");
    }

    public static void main(String[] args) {
        String original = "\u00e0\u00e9\u00ee\u00f6\u00f9\u00e7";
        String withoutAccents = AccentRemover.removeAccents(original);
        System.out.println("Original: " + original);
        System.out.println("Without Accents: " + withoutAccents);
    }
}

