/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.color;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ColorHelper {
    private static Map<String, Color> DARKER_COLOR_CACHES = new HashMap<String, Color>();
    private static Map<String, Color> BRIGHTER_COLOR_CACHES = new HashMap<String, Color>();

    public static Color randomColor(Mode mode) {
        Color color = new Color(Color.HSBtoRGB((float)Math.random(), (float)Math.random(), 0.5f + (float)Math.random() / 2.0f));
        color = mode == Mode.BRIGHTER ? color.brighter() : color.darker();
        return color;
    }

    public static String formatColorToHexaString(Color color) {
        String hex = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        return hex;
    }

    public static Color randomBrighterColor() {
        return ColorHelper.randomColor(Mode.BRIGHTER);
    }

    public static Color randomDarkerColor() {
        return ColorHelper.randomColor(Mode.DARKER);
    }

    public static double distance(Color a, Color b) {
        int dr = a.getRed() - b.getRed();
        int dg = a.getGreen() - b.getGreen();
        int db = a.getBlue() - b.getBlue();
        int da = a.getAlpha() - b.getAlpha();
        return Math.sqrt(dr * dr + dg * dg + db * db + da * da);
    }

    public static boolean isSimilar(Color c1, Color c2, double distanceMax) {
        double distance = ColorHelper.distance(c1, c2);
        return distance < distanceMax;
    }

    public static String getRandomElementListString(List<String> list) {
        Random rand = new Random();
        return list.get(rand.nextInt(list.size()));
    }

    public static String black() {
        return "#000000";
    }

    public static String white() {
        return "#FFFFFF";
    }

    public static String green() {
        return "#00FF00";
    }

    public static String red() {
        return "#FF0000";
    }

    public static String getDarkerColorCache(String id) {
        if (DARKER_COLOR_CACHES.get(id) == null) {
            Color newColor = ColorHelper.randomDarkerColor();
            double distanceMax = 30.0;
            boolean valid = false;
            for (int reply = 5; reply > 0 && !valid; --reply) {
                Color actualColor = newColor;
                if (DARKER_COLOR_CACHES.values().stream().filter(c -> ColorHelper.isSimilar(c, actualColor, distanceMax)).count() == 0L) {
                    valid = true;
                    continue;
                }
                newColor = ColorHelper.randomDarkerColor();
            }
            DARKER_COLOR_CACHES.put(id, newColor);
        }
        return ColorHelper.formatColorToHexaString(DARKER_COLOR_CACHES.get(id));
    }

    public static String getBrigtherColorCache(String id) {
        if (BRIGHTER_COLOR_CACHES.get(id) == null) {
            Color newColor = ColorHelper.randomBrighterColor();
            double distanceMax = 30.0;
            boolean valid = false;
            for (int reply = 5; reply > 0 && !valid; --reply) {
                Color actualColor = newColor;
                if (BRIGHTER_COLOR_CACHES.values().stream().filter(c -> ColorHelper.isSimilar(c, actualColor, distanceMax)).count() == 0L) {
                    valid = true;
                    continue;
                }
                newColor = ColorHelper.randomBrighterColor();
            }
            BRIGHTER_COLOR_CACHES.put(id, newColor);
        }
        return ColorHelper.formatColorToHexaString(BRIGHTER_COLOR_CACHES.get(id));
    }

    static enum Mode {
        BRIGHTER,
        DARKER;

    }
}

