/*
 * Decompiled with CFR 0.152.
 */
package fr.emac.gind.commons.utils.esb;

import fr.emac.gind.commons.utils.esb.Epr;
import fr.emac.gind.commons.utils.esb.QueryParam;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class EprUtil {
    public static Epr analyzeURI(URI address) throws Exception {
        Epr res = null;
        String addr = address.toString().replace("epr://", "");
        String ns = null;
        String serv = null;
        String ep = null;
        if (!addr.contains("@")) {
            throw new Exception("Endpoint address not valid: " + String.valueOf(address));
        }
        if (addr.contains("::")) {
            ns = addr.substring(0, addr.indexOf("::"));
            serv = addr.substring(addr.indexOf("::") + "::".length(), addr.indexOf("@"));
        } else {
            ns = addr.substring(0, addr.indexOf("@"));
        }
        if (serv != null && "null".equals(serv)) {
            serv = null;
        }
        if (addr.indexOf("?") > 0) {
            ep = addr.substring(addr.indexOf("@") + "@".length(), addr.indexOf("?"));
            if (ep.equals("null")) {
                ep = null;
            }
            String query = addr.substring(addr.indexOf("?"));
            List<QueryParam> params = EprUtil.analyseQuery(query);
            res = new Epr(ns, serv, ep, new QueryParam[0]);
        } else {
            ep = addr.substring(addr.indexOf("@") + "@".length(), addr.length());
            if (ep.equals("null")) {
                ep = null;
            }
            res = new Epr(ns, serv, ep, new QueryParam[0]);
        }
        return res;
    }

    private static List<QueryParam> analyseQuery(String query) {
        ArrayList<QueryParam> params = new ArrayList<QueryParam>();
        for (String param : query.split(",")) {
            String key = param.trim().split("=")[0];
            String value = param.trim().split("=")[1];
            params.add(new QueryParam(key, value));
        }
        return params;
    }

    public static URI generateURI(Epr addr) {
        URI res = null;
        Object ref = "epr://";
        ref = (String)ref + addr.getNamespace();
        if (addr.getServicename() != null && addr.getServicename().trim().length() > 0) {
            ref = (String)ref + "::" + addr.getServicename();
        }
        ref = (String)ref + "@" + addr.getEndpointname();
        if (addr.getQueryString() != null && addr.getQueryString().trim().length() > 0) {
            ref = (String)ref + "?" + addr.getQueryString();
        }
        res = URI.create((String)ref);
        return res;
    }

    public static URI getURIWithoutQuery(URI uri) {
        if (uri.toString().indexOf("?") > 0) {
            return URI.create(uri.toString().substring(0, uri.toString().indexOf("?")));
        }
        return uri;
    }
}

